(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16010,        565]
NotebookOptionsPosition[     12029,        431]
NotebookOutlinePosition[     14151,        497]
CellTagsIndexPosition[     14033,        491]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::mxsst", "ObjectName",
 CellID->24793],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"mxsst\"\>"}], ":", 
  " ", "\<\"Using maximum number of grid points `1` allowed by the MaxPoints \
or MinStepSize options for independent variable `2`.\"\>"}]], "Message", \
"MSG",
 CellID->16795962],

Cell[TextData[{
 "Generated when the number of grid points used by the   partial differential \
equation solver is the number specified in the value of   the ",
 Cell[BoxData[
  ButtonBox["MaxSteps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxSteps"]], "InlineFormula"],
 " option rather than the number that would have been chosen by default. "
}], "Notes",
 CellID->8483],

Cell[TextData[{
 "This warning is normally seen only if the solution to a   partial \
differential equation has sharp or oscillating features, or when   using \
relatively small values in the ",
 Cell[BoxData[
  ButtonBox["MaxSteps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxSteps"]], "InlineFormula"],
 " option."
}], "Notes",
 CellID->7427]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->37854397],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->7683139],

Cell[TextData[{
 "A warning message is generated in this example because the sharp feature in \
 the initial condition cannot be handled reliably with the number of grid  \
points specified by the ",
 Cell[BoxData[
  ButtonBox["MaxSteps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxSteps"]], "InlineFormula"],
 " option."
}], "ExampleText",
 CellID->367891694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", "\[Equal]", 
      " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"MaxSteps", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"15", ",", " ", "Infinity"}], "}"}]}]}], "]"}]], "Input",
 CellTags->"NDSolve::mxsst",
 CellLabel->"In[1]:=",
 CellID->18409],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"mxsst\"\>"}], ":", 
  " ", "\<\"Using maximum number of grid points \\!\\(15\\) allowed by the \
MaxPoints or MinStepSize options for independent variable \
\\!\\(x\\).\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::mxsst",
 CellID->484595282],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.`"}], ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "2.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::mxsst",
 CellLabel->"Out[1]=",
 CellID->258902580]
}, Open  ]],

Cell[TextData[{
 "The error can be avoided in this example by omitting the setting for the ",
 Cell[BoxData[
  ButtonBox["MaxSteps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxSteps"]], "InlineFormula"],
 " option."
}], "ExampleText",
 CellID->14719986],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", "\[Equal]", 
      " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::mxsst",
 CellLabel->"In[2]:=",
 CellID->31504],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.`"}], ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "2.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::mxsst",
 CellLabel->"Out[2]=",
 CellID->330036866]
}, Open  ]],

Cell[TextData[{
 "A warning message is generated in this example because the sharp feature in \
 the initial condition cannot be handled reliably with the number of grid  \
points specified by the ",
 Cell[BoxData[
  ButtonBox["MaxSteps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxSteps"]], "InlineFormula"],
 " option."
}], "ExampleText",
 CellID->271758448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", "\[Equal]", 
      " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<MethodOfLines\>\"", ",", " ", 
      RowBox[{"\"\<SpatialDiscretization\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<TensorProductGrid\>\"", ",", " ", 
         RowBox[{"MaxPoints", "\[Rule]", "15"}]}], "}"}]}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellTags->"NDSolve::mxsst",
 CellLabel->"In[3]:=",
 CellID->21665],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"mxsst\"\>"}], ":", 
  " ", "\<\"Using maximum number of grid points \\!\\(15\\) allowed by the \
MaxPoints or MinStepSize options for independent variable \
\\!\\(x\\).\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::mxsst",
 CellID->382442753],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.`"}], ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "2.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::mxsst",
 CellLabel->"Out[3]=",
 CellID->32622294]
}, Open  ]],

Cell[TextData[{
 "The error can be avoided in this example by omitting the setting for the ",
 Cell[BoxData[
  ButtonBox["MaxSteps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxSteps"]], "InlineFormula"],
 " option."
}], "ExampleText",
 CellID->401237856],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", "\[Equal]", 
      " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<MethodOfLines\>\"", ",", " ", 
      RowBox[{"\"\<SpatialDiscretization\>\"", "\[Rule]", 
       RowBox[{"{", "\"\<TensorProductGrid\>\"", "}"}]}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellTags->"NDSolve::mxsst",
 CellLabel->"In[4]:=",
 CellID->2427],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.`"}], ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "2.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::mxsst",
 CellLabel->"Out[4]=",
 CellID->384567388]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::mxsst - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 43.1719336}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::mxsst", "synonyms" -> {}, "title" -> 
    "NDSolve::mxsst", "type" -> "Message", "uri" -> "ref/message/mxsst"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2291, 83, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->37854397]},
 "NDSolve::mxsst"->{
  Cell[3218, 118, 1195, 38, 70, "Input",
   CellTags->"NDSolve::mxsst",
   CellID->18409],
  Cell[4416, 158, 300, 7, 70, "Message",
   CellTags->"NDSolve::mxsst",
   CellID->484595282],
  Cell[4719, 167, 530, 19, 70, "Output",
   CellTags->"NDSolve::mxsst",
   CellID->258902580],
  Cell[5551, 201, 1079, 35, 70, "Input",
   CellTags->"NDSolve::mxsst",
   CellID->31504],
  Cell[6633, 238, 530, 19, 70, "Output",
   CellTags->"NDSolve::mxsst",
   CellID->330036866],
  Cell[7572, 274, 1400, 43, 70, "Input",
   CellTags->"NDSolve::mxsst",
   CellID->21665],
  Cell[8975, 319, 300, 7, 70, "Message",
   CellTags->"NDSolve::mxsst",
   CellID->382442753],
  Cell[9278, 328, 529, 19, 70, "Output",
   CellTags->"NDSolve::mxsst",
   CellID->32622294],
  Cell[10110, 362, 1320, 41, 70, "Input",
   CellTags->"NDSolve::mxsst",
   CellID->2427],
  Cell[11433, 405, 530, 19, 70, "Output",
   CellTags->"NDSolve::mxsst",
   CellID->384567388]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12936, 453},
 {"NDSolve::mxsst", 13075, 457}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->24793],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 255, 6, 70, "Message",
 CellID->16795962],
Cell[1516, 57, 382, 9, 70, "Notes",
 CellID->8483],
Cell[1901, 68, 353, 10, 70, "Notes",
 CellID->7427]
}, Closed]],
Cell[CellGroupData[{
Cell[2291, 83, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->37854397],
Cell[CellGroupData[{
Cell[2675, 97, 146, 5, 70, "ExampleSection",
 CellID->7683139],
Cell[2824, 104, 369, 10, 70, "ExampleText",
 CellID->367891694],
Cell[CellGroupData[{
Cell[3218, 118, 1195, 38, 70, "Input",
 CellTags->"NDSolve::mxsst",
 CellID->18409],
Cell[4416, 158, 300, 7, 70, "Message",
 CellTags->"NDSolve::mxsst",
 CellID->484595282],
Cell[4719, 167, 530, 19, 70, "Output",
 CellTags->"NDSolve::mxsst",
 CellID->258902580]
}, Open  ]],
Cell[5264, 189, 262, 8, 70, "ExampleText",
 CellID->14719986],
Cell[CellGroupData[{
Cell[5551, 201, 1079, 35, 70, "Input",
 CellTags->"NDSolve::mxsst",
 CellID->31504],
Cell[6633, 238, 530, 19, 70, "Output",
 CellTags->"NDSolve::mxsst",
 CellID->330036866]
}, Open  ]],
Cell[7178, 260, 369, 10, 70, "ExampleText",
 CellID->271758448],
Cell[CellGroupData[{
Cell[7572, 274, 1400, 43, 70, "Input",
 CellTags->"NDSolve::mxsst",
 CellID->21665],
Cell[8975, 319, 300, 7, 70, "Message",
 CellTags->"NDSolve::mxsst",
 CellID->382442753],
Cell[9278, 328, 529, 19, 70, "Output",
 CellTags->"NDSolve::mxsst",
 CellID->32622294]
}, Open  ]],
Cell[9822, 350, 263, 8, 70, "ExampleText",
 CellID->401237856],
Cell[CellGroupData[{
Cell[10110, 362, 1320, 41, 70, "Input",
 CellTags->"NDSolve::mxsst",
 CellID->2427],
Cell[11433, 405, 530, 19, 70, "Output",
 CellTags->"NDSolve::mxsst",
 CellID->384567388]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[12002, 429, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

