(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8141,        306]
NotebookOptionsPosition[      5247,        210]
NotebookOutlinePosition[      6909,        261]
CellTagsIndexPosition[      6792,        255]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::ndinnt", "ObjectName",
 CellID->18960],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndinnt\"\>"}], ":", 
  " ", "\<\"Initial condition `1` is not a number or a rectangular array of \
numbers.\"\>"}]], "Message", "MSG",
 CellID->108978399],

Cell[TextData[{
 "Generated when an initial condition in ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " does not have the required form."
}], "Notes",
 CellID->7183],

Cell["\<\
The most common  cause of  this message is an undefined symbolic parameter in \
the equations.\
\>", "Notes",
 CellID->11892]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->709906953],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->517233819],

Cell[TextData[{
 "The initial value of a solution in ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " cannot be ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->761636367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "0", "]"}], "\[Equal]", "Infinity"}]}], "}"}], ",", 
   "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ndinnt",
 CellLabel->"In[1]:=",
 CellID->16948],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndinnt\"\>"}], ":", 
  " ", "\<\"Initial condition \\!\\(\[Infinity]\\) is not a number or a \
rectangular array of numbers.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::ndinnt",
 CellID->413346867],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "0", "]"}], "\[Equal]", "\[Infinity]"}]}], "}"}], ",",
    "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Output",
 CellTags->"NDSolve::ndinnt",
 CellLabel->"Out[1]=",
 CellID->705001471]
}, Open  ]],

Cell[TextData[{
 "This shows a valid specification of an initial value problem in ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->219194380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "0", "]"}], "==", "1"}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ndinnt",
 CellLabel->"In[2]:=",
 CellID->2055],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::ndinnt",
 CellLabel->"Out[2]=",
 CellID->217585657]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::ndinnt - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 50.8752558}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::ndinnt", "synonyms" -> {}, "title" -> 
    "NDSolve::ndinnt", "type" -> "Message", "uri" -> "ref/message/ndinnt"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1888, 75, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->709906953]},
 "NDSolve::ndinnt"->{
  Cell[2800, 113, 460, 16, 70, "Input",
   CellTags->"NDSolve::ndinnt",
   CellID->16948],
  Cell[3263, 131, 257, 6, 70, "Message",
   CellTags->"NDSolve::ndinnt",
   CellID->413346867],
  Cell[3523, 139, 520, 17, 70, "Output",
   CellTags->"NDSolve::ndinnt",
   CellID->705001471],
  Cell[4328, 171, 442, 15, 70, "Input",
   CellTags->"NDSolve::ndinnt",
   CellID->2055],
  Cell[4773, 188, 408, 15, 70, "Output",
   CellTags->"NDSolve::ndinnt",
   CellID->217585657]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6158, 232},
 {"NDSolve::ndinnt", 6299, 236}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->18960],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 210, 5, 70, "Message",
 CellID->108978399],
Cell[1472, 56, 241, 8, 70, "Notes",
 CellID->7183],
Cell[1716, 66, 135, 4, 70, "Notes",
 CellID->11892]
}, Closed]],
Cell[CellGroupData[{
Cell[1888, 75, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->709906953],
Cell[CellGroupData[{
Cell[2273, 89, 148, 5, 70, "ExampleSection",
 CellID->517233819],
Cell[2424, 96, 351, 13, 70, "ExampleText",
 CellID->761636367],
Cell[CellGroupData[{
Cell[2800, 113, 460, 16, 70, "Input",
 CellTags->"NDSolve::ndinnt",
 CellID->16948],
Cell[3263, 131, 257, 6, 70, "Message",
 CellTags->"NDSolve::ndinnt",
 CellID->413346867],
Cell[3523, 139, 520, 17, 70, "Output",
 CellTags->"NDSolve::ndinnt",
 CellID->705001471]
}, Open  ]],
Cell[4058, 159, 245, 8, 70, "ExampleText",
 CellID->219194380],
Cell[CellGroupData[{
Cell[4328, 171, 442, 15, 70, "Input",
 CellTags->"NDSolve::ndinnt",
 CellID->2055],
Cell[4773, 188, 408, 15, 70, "Output",
 CellTags->"NDSolve::ndinnt",
 CellID->217585657]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5220, 208, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

