(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9099,        311]
NotebookOptionsPosition[      5208,        199]
NotebookOutlinePosition[      7764,        268]
CellTagsIndexPosition[      7603,        261]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
NDSolve::ndnco
NDSolve`Reinitialize::ndnco\
\>", "ObjectName",
 CellID->122],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"ndnco\"\>"}], ":", 
  " ", "\<\"The number of constraints (`1`) (initial conditions) is not equal \
to the total differential order of the system (`2`).\"\>"}]], "Message", \
"MSG",
 CellID->378547354],

Cell["\<\
Generated when the solution of a differential equation is either \
underspecified (insufficient initial conditions) or overspecified (too many \
initial conditions).\
\>", "Notes",
 CellID->12812]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->114720098],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->96216994],

Cell["\<\
An error occurs in this example because there are not enough initial \
conditions to uniquely specify a solution.\
\>", "ExampleText",
 CellID->906249153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"f", "'"}], "'"}], "[", "x", "]"}], "==", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "0", "]"}], "==", "1"}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"},
 CellLabel->"In[1]:=",
 CellID->9258],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndnco\"\>"}], ":", 
  " ", "\<\"The number of constraints (\\!\\(1\\)) (initial conditions) is \
not equal to the total differential order of the system \
(\\!\\(2\\)).\"\>"}]], "Message", "MSG",
 CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"},
 CellID->190207433],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["f", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", "f", ",",
    
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Output",
 CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"},
 CellLabel->"Out[1]=",
 CellID->79559808]
}, Open  ]],

Cell["\<\
This shows a valid specification of a unique solution for this differential \
equation.\
\>", "ExampleText",
 CellID->157254395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"f", "'"}], "'"}], "[", "x", "]"}], "==", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "0", "]"}], "==", "1"}]}], "}"}], ",", "f", 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"},
 CellLabel->"In[2]:=",
 CellID->32027],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"},
 CellLabel->"Out[2]=",
 CellID->463712783]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::ndnco - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 58.2660700}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::ndnco NDSolve`Reinitialize::ndnco", 
    "synonyms" -> {}, "title" -> "NDSolve::ndnco", "type" -> "Message", "uri" -> 
    "ref/message/ndnco"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1816, 71, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->114720098]},
 "NDSolve::ndnco"->{
  Cell[2540, 100, 498, 16, 70, "Input",
   CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"},
   CellID->9258],
  Cell[3041, 118, 333, 7, 70, "Message",
   CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"},
   CellID->190207433],
  Cell[3377, 127, 549, 17, 70, "Output",
   CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"},
   CellID->79559808],
  Cell[4104, 155, 595, 20, 70, "Input",
   CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"},
   CellID->32027],
  Cell[4702, 177, 440, 15, 70, "Output",
   CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"},
   CellID->463712783]},
 "NDSolve`Reinitialize::ndnco"->{
  Cell[2540, 100, 498, 16, 70, "Input",
   CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"},
   CellID->9258],
  Cell[3041, 118, 333, 7, 70, "Message",
   CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"},
   CellID->190207433],
  Cell[3377, 127, 549, 17, 70, "Output",
   CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"},
   CellID->79559808],
  Cell[4104, 155, 595, 20, 70, "Input",
   CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"},
   CellID->32027],
  Cell[4702, 177, 440, 15, 70, "Output",
   CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"},
   CellID->463712783]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6148, 222},
 {"NDSolve::ndnco", 6288, 226},
 {"NDSolve`Reinitialize::ndnco", 6951, 242}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 86, 4, 70, "ObjectName",
 CellID->122],
Cell[CellGroupData[{
Cell[814, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1292, 52, 278, 7, 70, "Message",
 CellID->378547354],
Cell[1573, 61, 206, 5, 70, "Notes",
 CellID->12812]
}, Closed]],
Cell[CellGroupData[{
Cell[1816, 71, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->114720098],
Cell[CellGroupData[{
Cell[2201, 85, 147, 5, 70, "ExampleSection",
 CellID->96216994],
Cell[2351, 92, 164, 4, 70, "ExampleText",
 CellID->906249153],
Cell[CellGroupData[{
Cell[2540, 100, 498, 16, 70, "Input",
 CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"},
 CellID->9258],
Cell[3041, 118, 333, 7, 70, "Message",
 CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"},
 CellID->190207433],
Cell[3377, 127, 549, 17, 70, "Output",
 CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"},
 CellID->79559808]
}, Open  ]],
Cell[3941, 147, 138, 4, 70, "ExampleText",
 CellID->157254395],
Cell[CellGroupData[{
Cell[4104, 155, 595, 20, 70, "Input",
 CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"},
 CellID->32027],
Cell[4702, 177, 440, 15, 70, "Output",
 CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"},
 CellID->463712783]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5181, 197, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

