(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7564,        285]
NotebookOptionsPosition[      4759,        191]
NotebookOutlinePosition[      6398,        242]
CellTagsIndexPosition[      6283,        236]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::ndnl", "ObjectName",
 CellID->10623],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndnl\"\>"}], ":", 
  " ", "\<\"Endpoint `1` in `2` is not a real number.\"\>"}]], "Message", \
"MSG",
 CellID->49558799],

Cell["\<\
Generated when the endpoints specified for the range of integration are not \
real numbers.\
\>", "Notes",
 CellID->19847]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->353949290],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->74058845],

Cell["\<\
An error occurs in this example because the limits on the independent \
variable do not have values.\
\>", "ExampleText",
 CellID->334427602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "t", "]"}], "==", 
      RowBox[{"f", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "==", "1"}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "t1", ",", "t2"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ndnl",
 CellLabel->"In[1]:=",
 CellID->25769],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndnl\"\>"}], ":", 
  " ", "\<\"Endpoint \\!\\(t1\\) in \\!\\({t, t1, t2}\\) is not a real \
number.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::ndnl",
 CellID->135054096],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
      RowBox[{"f", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "\[Equal]", "1"}]}], "}"}], ",", "f", ",",
    
   RowBox[{"{", 
    RowBox[{"t", ",", "t1", ",", "t2"}], "}"}]}], "]"}]], "Output",
 CellTags->"NDSolve::ndnl",
 CellLabel->"Out[1]=",
 CellID->54048381]
}, Open  ]],

Cell["\<\
This shows a correct specification of the limits on the variable.\
\>", "ExampleText",
 CellID->111257125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t1", "=", "1"}], ",", 
     RowBox[{"t2", "=", "2"}]}], "}"}], ",", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"f", "'"}], "[", "t", "]"}], "==", 
        RowBox[{"f", "[", "t", "]"}]}], ",", 
       RowBox[{
        RowBox[{"f", "[", "1", "]"}], "==", "1"}]}], "}"}], ",", "f", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "t1", ",", "t2"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ndnl",
 CellLabel->"In[2]:=",
 CellID->17525],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1.`", ",", "2.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::ndnl",
 CellLabel->"Out[2]=",
 CellID->432698759]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::ndnl - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 58.5317018}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::ndnl", "synonyms" -> {}, "title" -> 
    "NDSolve::ndnl", "type" -> "Message", "uri" -> "ref/message/ndnl"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1605, 65, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->353949290]},
 "NDSolve::ndnl"->{
  Cell[2316, 94, 443, 15, 70, "Input",
   CellTags->"NDSolve::ndnl",
   CellID->25769],
  Cell[2762, 111, 230, 6, 70, "Message",
   CellTags->"NDSolve::ndnl",
   CellID->135054096],
  Cell[2995, 119, 509, 17, 70, "Output",
   CellTags->"NDSolve::ndnl",
   CellID->54048381],
  Cell[3660, 146, 624, 21, 70, "Input",
   CellTags->"NDSolve::ndnl",
   CellID->17525],
  Cell[4287, 169, 406, 15, 70, "Output",
   CellTags->"NDSolve::ndnl",
   CellID->432698759]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5662, 213},
 {"NDSolve::ndnl", 5801, 217}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->10623],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 176, 5, 70, "Message",
 CellID->49558799],
Cell[1436, 56, 132, 4, 70, "Notes",
 CellID->19847]
}, Closed]],
Cell[CellGroupData[{
Cell[1605, 65, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->353949290],
Cell[CellGroupData[{
Cell[1990, 79, 147, 5, 70, "ExampleSection",
 CellID->74058845],
Cell[2140, 86, 151, 4, 70, "ExampleText",
 CellID->334427602],
Cell[CellGroupData[{
Cell[2316, 94, 443, 15, 70, "Input",
 CellTags->"NDSolve::ndnl",
 CellID->25769],
Cell[2762, 111, 230, 6, 70, "Message",
 CellTags->"NDSolve::ndnl",
 CellID->135054096],
Cell[2995, 119, 509, 17, 70, "Output",
 CellTags->"NDSolve::ndnl",
 CellID->54048381]
}, Open  ]],
Cell[3519, 139, 116, 3, 70, "ExampleText",
 CellID->111257125],
Cell[CellGroupData[{
Cell[3660, 146, 624, 21, 70, "Input",
 CellTags->"NDSolve::ndnl",
 CellID->17525],
Cell[4287, 169, 406, 15, 70, "Output",
 CellTags->"NDSolve::ndnl",
 CellID->432698759]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4732, 189, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

