(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12131,        444]
NotebookOptionsPosition[      8353,        316]
NotebookOutlinePosition[     10361,        379]
CellTagsIndexPosition[     10246,        373]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::ntdv", "ObjectName",
 CellID->20200],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ntdv\"\>"}], ":", 
  " ", "\<\"Cannot solve to find an explicit formula for the derivatives.  \
Consider using the option setting SolveDelayed -> True.\"\>"}]], "Message", \
"MSG",
 CellID->244633242],

Cell[TextData[{
 "Generated when ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " is unable to solve for the derivatives in a differential equation. "
}], "Notes",
 CellID->10439],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " to solve symbolically for the derivatives in a differential equation. "
}], "Notes",
 CellID->6751],

Cell["\<\
This error will occur if the equations do not have a   solution, or if it is \
not possible to solve for the derivatives by algebraic   methods.\
\>", "Notes",
 CellID->24955],

Cell[TextData[{
 "In some cases this error can be handled by   solving for the derivatives \
separately and using those solutions in the input   to ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9195]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5502809],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->155703975],

Cell[TextData[{
 "In some versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " an error occurs in this example because this differential equation does  \
not have a solution."
}], "ExampleText",
 CellID->364245235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"f", "'"}], "[", "x", "]"}], "]"}], "==", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "==", "1"}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ntdv",
 CellLabel->"In[1]:=",
 CellID->26089],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ntdv\"\>"}], ":", 
  " ", "\<\"Cannot solve to find an explicit formula for the derivatives.  \
Consider using the option setting SolveDelayed -> True.\"\>"}]], "Message", \
"MSG",
 CellTags->"NDSolve::ntdv",
 CellID->314972186],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SqrtBox[
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "x", "]"}]], "\[Equal]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "\[Equal]", "1"}]}], "}"}], ",", "f", ",",
    
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Output",
 CellTags->"NDSolve::ntdv",
 CellLabel->"Out[1]=",
 CellID->60697299]
}, Open  ]],

Cell["\<\
This calculation fails because the equation to be solved for the derivative \
cannot be solved by algebraic methods.\
\>", "ExampleText",
 CellID->202841746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"f", "'"}], "[", "x", "]"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "==", "1"}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ntdv",
 CellLabel->"In[2]:=",
 CellID->6332],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"The equations appear to involve the variables to be solved for in \
an essentially non-algebraic way.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::ntdv",
 CellID->488993471],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ntdv\"\>"}], ":", 
  " ", "\<\"Cannot solve to find an explicit formula for the derivatives.  \
Consider using the option setting SolveDelayed -> True.\"\>"}]], "Message", \
"MSG",
 CellTags->"NDSolve::ntdv",
 CellID->136139416],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"Cos", "[", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "x", "]"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "\[Equal]", "1"}]}], "}"}], ",", "f", ",",
    
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Output",
 CellTags->"NDSolve::ntdv",
 CellLabel->"Out[2]=",
 CellID->121882788]
}, Open  ]],

Cell[TextData[{
 "This example can be handled by solving numerically for the derivative and   \
using that solution in the input to ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->410687859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "'"}], "[", "x", "]"}], "/.", 
        RowBox[{"FindRoot", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"f", "'"}], "[", "x", "]"}], "==", 
           RowBox[{"Cos", "[", 
            RowBox[{
             RowBox[{"f", "'"}], "[", "x", "]"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"f", "'"}], "[", "x", "]"}], ",", "1", ",", "2"}], 
           "}"}]}], "]"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "==", "1"}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ntdv",
 CellLabel->"In[3]:=",
 CellID->19428],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1.`", ",", "2.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::ntdv",
 CellLabel->"Out[3]=",
 CellID->12326730]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::ntdv - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 22.2823098}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::ntdv", "synonyms" -> {}, "title" -> 
    "NDSolve::ntdv", "type" -> "Message", "uri" -> "ref/message/ntdv"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2659, 101, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->5502809]},
 "NDSolve::ntdv"->{
  Cell[3446, 133, 468, 16, 70, "Input",
   CellTags->"NDSolve::ntdv",
   CellID->26089],
  Cell[3917, 151, 284, 7, 70, "Message",
   CellTags->"NDSolve::ntdv",
   CellID->314972186],
  Cell[4204, 160, 516, 18, 70, "Output",
   CellTags->"NDSolve::ntdv",
   CellID->60697299],
  Cell[4927, 189, 499, 17, 70, "Input",
   CellTags->"NDSolve::ntdv",
   CellID->6332],
  Cell[5429, 208, 261, 6, 70, "Message",
   CellTags->"NDSolve::ntdv",
   CellID->488993471],
  Cell[5693, 216, 284, 7, 70, "Message",
   CellTags->"NDSolve::ntdv",
   CellID->136139416],
  Cell[5980, 225, 614, 20, 70, "Output",
   CellTags->"NDSolve::ntdv",
   CellID->121882788],
  Cell[6929, 261, 950, 31, 70, "Input",
   CellTags->"NDSolve::ntdv",
   CellID->19428],
  Cell[7882, 294, 405, 15, 70, "Output",
   CellTags->"NDSolve::ntdv",
   CellID->12326730]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9256, 338},
 {"NDSolve::ntdv", 9394, 342}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->20200],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 256, 6, 70, "Message",
 CellID->244633242],
Cell[1516, 57, 253, 8, 70, "Notes",
 CellID->10439],
Cell[1772, 67, 359, 12, 70, "Notes",
 CellID->6751],
Cell[2134, 81, 185, 4, 70, "Notes",
 CellID->24955],
Cell[2322, 87, 300, 9, 70, "Notes",
 CellID->9195]
}, Closed]],
Cell[CellGroupData[{
Cell[2659, 101, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5502809],
Cell[CellGroupData[{
Cell[3042, 115, 148, 5, 70, "ExampleSection",
 CellID->155703975],
Cell[3193, 122, 228, 7, 70, "ExampleText",
 CellID->364245235],
Cell[CellGroupData[{
Cell[3446, 133, 468, 16, 70, "Input",
 CellTags->"NDSolve::ntdv",
 CellID->26089],
Cell[3917, 151, 284, 7, 70, "Message",
 CellTags->"NDSolve::ntdv",
 CellID->314972186],
Cell[4204, 160, 516, 18, 70, "Output",
 CellTags->"NDSolve::ntdv",
 CellID->60697299]
}, Open  ]],
Cell[4735, 181, 167, 4, 70, "ExampleText",
 CellID->202841746],
Cell[CellGroupData[{
Cell[4927, 189, 499, 17, 70, "Input",
 CellTags->"NDSolve::ntdv",
 CellID->6332],
Cell[5429, 208, 261, 6, 70, "Message",
 CellTags->"NDSolve::ntdv",
 CellID->488993471],
Cell[5693, 216, 284, 7, 70, "Message",
 CellTags->"NDSolve::ntdv",
 CellID->136139416],
Cell[5980, 225, 614, 20, 70, "Output",
 CellTags->"NDSolve::ntdv",
 CellID->121882788]
}, Open  ]],
Cell[6609, 248, 295, 9, 70, "ExampleText",
 CellID->410687859],
Cell[CellGroupData[{
Cell[6929, 261, 950, 31, 70, "Input",
 CellTags->"NDSolve::ntdv",
 CellID->19428],
Cell[7882, 294, 405, 15, 70, "Output",
 CellTags->"NDSolve::ntdv",
 CellID->12326730]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[8326, 314, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

