(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7999,        284]
NotebookOptionsPosition[      5623,        206]
NotebookOutlinePosition[      7093,        251]
CellTagsIndexPosition[      6977,        245]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::pdnbc", "ObjectName",
 CellID->15622],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"pdnbc\"\>"}], ":", 
  " ", "\<\"Mixed periodic and Dirichlet/Neumann boundary conditions are not \
allowed.\"\>"}]], "Message", "MSG",
 CellID->97310392],

Cell["\<\
Generated when periodic boundary conditions are used together with other \
types of boundary conditions in specifying the solution of a partial \
differential equation.\
\>", "Notes",
 CellID->23734]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->78101513],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->75715746],

Cell["\<\
A error occurs in this example because of the combination of the periodic \
boundary condition and another type of boundary condition.\
\>", "ExampleText",
 CellID->512492478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"2", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "2"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", "t"}], "]"}], "==", 
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", "t"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "1"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "0"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "==", 
      RowBox[{"x", 
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}]}]}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::pdnbc",
 CellLabel->"In[1]:=",
 CellID->616526806],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"pdnbc\"\>"}], ":", 
  " ", "\<\"Mixed periodic and Dirichlet/Neumann boundary conditions are not \
allowed.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::pdnbc",
 CellID->89008390],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", "t"}], "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "0"}], "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}], " ", "x"}]}]}], "}"}], ",", "f", ",", 
   
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Output",
 CellTags->"NDSolve::pdnbc",
 CellLabel->"Out[1]=",
 CellID->137538172]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::pdnbc - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 22.6416940}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::pdnbc", "synonyms" -> {}, "title" -> 
    "NDSolve::pdnbc", "type" -> "Message", "uri" -> "ref/message/pdnbc"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1716, 66, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->78101513]},
 "NDSolve::pdnbc"->{
  Cell[2460, 95, 1324, 42, 70, "Input",
   CellTags->"NDSolve::pdnbc",
   CellID->616526806],
  Cell[3787, 139, 238, 6, 70, "Message",
   CellTags->"NDSolve::pdnbc",
   CellID->89008390],
  Cell[4028, 147, 1529, 52, 70, "Output",
   CellTags->"NDSolve::pdnbc",
   CellID->137538172]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6530, 228},
 {"NDSolve::pdnbc", 6669, 232}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->15622],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 209, 5, 70, "Message",
 CellID->97310392],
Cell[1470, 56, 209, 5, 70, "Notes",
 CellID->23734]
}, Closed]],
Cell[CellGroupData[{
Cell[1716, 66, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->78101513],
Cell[CellGroupData[{
Cell[2100, 80, 147, 5, 70, "ExampleSection",
 CellID->75715746],
Cell[2250, 87, 185, 4, 70, "ExampleText",
 CellID->512492478],
Cell[CellGroupData[{
Cell[2460, 95, 1324, 42, 70, "Input",
 CellTags->"NDSolve::pdnbc",
 CellID->616526806],
Cell[3787, 139, 238, 6, 70, "Message",
 CellTags->"NDSolve::pdnbc",
 CellID->89008390],
Cell[4028, 147, 1529, 52, 70, "Output",
 CellTags->"NDSolve::pdnbc",
 CellID->137538172]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5596, 204, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

