(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6945,        253]
NotebookOptionsPosition[      4522,        173]
NotebookOutlinePosition[      5989,        218]
CellTagsIndexPosition[      5873,        212]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::pdord", "ObjectName",
 CellID->25726],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"pdord\"\>"}], ":", 
  " ", "\<\"Some of the functions have zero differential order so the \
equations will be solved as a system of differential-algebraic \
equations.\"\>"}]], "Message", "MSG",
 CellID->297248964],

Cell[TextData[{
 "Generated when the equations do not include  derivatives of one or more of \
the functions specified in the second argument  of ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->19197],

Cell["This message does not necessarily indicate an  error.", "Notes",
 CellID->3456]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->327742149],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->385266098],

Cell[TextData[{
 "A message is generated in this example because there are no derivatives of  \
",
 StyleBox["y[t]", "MR"],
 " in the equations."
}], "ExampleText",
 CellID->285595128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], " ", "\[Equal]", " ", 
      RowBox[{"2", " ", 
       RowBox[{"y", "[", "t", "]"}]}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], " ", "\[Equal]", " ", 
      RowBox[{"1", " ", "-", " ", 
       RowBox[{"y", "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", "1"}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::pdord",
 CellLabel->"In[1]:=",
 CellID->29111],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"pdord\"\>"}], ":", 
  " ", "\<\"Some of the functions have zero differential order so the \
equations will be solved as a system of differential-algebraic \
equations.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::pdord",
 CellID->470598978],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], ",", 
    RowBox[{"y", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::pdord",
 CellLabel->"Out[1]=",
 CellID->550334252]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::pdord - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 22.7666972}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::pdord", "synonyms" -> {}, "title" -> 
    "NDSolve::pdord", "type" -> "Message", "uri" -> "ref/message/pdord"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1955, 74, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->327742149]},
 "NDSolve::pdord"->{
  Cell[2700, 105, 738, 24, 70, "Input",
   CellTags->"NDSolve::pdord",
   CellID->29111],
  Cell[3441, 131, 299, 7, 70, "Message",
   CellTags->"NDSolve::pdord",
   CellID->470598978],
  Cell[3743, 140, 713, 26, 70, "Output",
   CellTags->"NDSolve::pdord",
   CellID->550334252]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5429, 195},
 {"NDSolve::pdord", 5569, 199}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->25726],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 270, 6, 70, "Message",
 CellID->297248964],
Cell[1531, 57, 299, 9, 70, "Notes",
 CellID->19197],
Cell[1833, 68, 85, 1, 70, "Notes",
 CellID->3456]
}, Closed]],
Cell[CellGroupData[{
Cell[1955, 74, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->327742149],
Cell[CellGroupData[{
Cell[2340, 88, 148, 5, 70, "ExampleSection",
 CellID->385266098],
Cell[2491, 95, 184, 6, 70, "ExampleText",
 CellID->285595128],
Cell[CellGroupData[{
Cell[2700, 105, 738, 24, 70, "Input",
 CellTags->"NDSolve::pdord",
 CellID->29111],
Cell[3441, 131, 299, 7, 70, "Message",
 CellTags->"NDSolve::pdord",
 CellID->470598978],
Cell[3743, 140, 713, 26, 70, "Output",
 CellTags->"NDSolve::pdord",
 CellID->550334252]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4495, 171, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

