(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8322,        300]
NotebookOptionsPosition[      5503,        206]
NotebookOutlinePosition[      7153,        257]
CellTagsIndexPosition[      7037,        251]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::precw", "ObjectName",
 CellID->14216],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"precw\"\>"}], ":", 
  " ", "\<\"The precision of the argument function (`1`) is less than \
WorkingPrecision (`2`).\"\>"}]], "Message", "MSG",
 CellID->16329465],

Cell[TextData[{
 "Generated when the value of the ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " option exceeds the precision of the least precise number in the  \
differential equations."
}], "Notes",
 CellID->750]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->327585017],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->13883787],

Cell[TextData[{
 "An error is generated in this example because the precision of the machine  \
number in the equations is less than the value of the ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " option."
}], "ExampleText",
 CellID->756585652],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"1.3", " ", 
       RowBox[{"f", "[", "x", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "\[Equal]", "1"}]}], "}"}], ",", "f", ",",
    
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "50"}]}], "]"}]], "Input",
 CellTags->"NDSolve::precw",
 CellLabel->"In[1]:=",
 CellID->15800],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"precw\"\>"}], ":", 
  " ", "\<\"The precision of the differential equation \
(\\!\\({\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"f\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[x]\\)\\) \[Equal] \\(\\(1.3`\\\\ \
\\(\\(f[x]\\)\\)\\)\\)\\)\\), \\(\\(\\(\\(f[1]\\)\\) \[Equal] 1\\)\\)}\\)) is \
less than WorkingPrecision (\\!\\(50.`\\)).\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::precw",
 CellID->184805499],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1.`50.", ",", "2.`50."}], "}"}], "}"}], ",", "\<\"<>\"\>"}],
       "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::precw",
 CellLabel->"Out[1]=",
 CellID->53931041]
}, Open  ]],

Cell["\<\
A high-precision result can be computed if the low-precision number in the \
input is replaced by an exact number.\
\>", "ExampleText",
 CellID->430634261],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"13", "/", "10"}], ")"}], " ", 
       RowBox[{"f", "[", "x", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "\[Equal]", "1"}]}], "}"}], ",", "f", ",",
    
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "50"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "30"}]}], "]"}]], "Input",
 CellTags->"NDSolve::precw",
 CellLabel->"In[2]:=",
 CellID->3090],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1.`50.", ",", "2.`50."}], "}"}], "}"}], ",", "\<\"<>\"\>"}],
       "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::precw",
 CellLabel->"Out[2]=",
 CellID->508874799]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::precw - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 22.9229512}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::precw", "synonyms" -> {}, "title" -> 
    "NDSolve::precw", "type" -> "Message", "uri" -> "ref/message/precw"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1824, 70, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->327585017]},
 "NDSolve::precw"->{
  Cell[2722, 104, 544, 18, 70, "Input",
   CellTags->"NDSolve::precw",
   CellID->15800],
  Cell[3269, 124, 479, 9, 70, "Message",
   CellTags->"NDSolve::precw",
   CellID->184805499],
  Cell[3751, 135, 412, 15, 70, "Output",
   CellTags->"NDSolve::precw",
   CellID->53931041],
  Cell[4368, 161, 653, 21, 70, "Input",
   CellTags->"NDSolve::precw",
   CellID->3090],
  Cell[5024, 184, 413, 15, 70, "Output",
   CellTags->"NDSolve::precw",
   CellID->508874799]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6410, 228},
 {"NDSolve::precw", 6550, 232}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->14216],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 217, 5, 70, "Message",
 CellID->16329465],
Cell[1478, 56, 309, 9, 70, "Notes",
 CellID->750]
}, Closed]],
Cell[CellGroupData[{
Cell[1824, 70, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->327585017],
Cell[CellGroupData[{
Cell[2209, 84, 147, 5, 70, "ExampleSection",
 CellID->13883787],
Cell[2359, 91, 338, 9, 70, "ExampleText",
 CellID->756585652],
Cell[CellGroupData[{
Cell[2722, 104, 544, 18, 70, "Input",
 CellTags->"NDSolve::precw",
 CellID->15800],
Cell[3269, 124, 479, 9, 70, "Message",
 CellTags->"NDSolve::precw",
 CellID->184805499],
Cell[3751, 135, 412, 15, 70, "Output",
 CellTags->"NDSolve::precw",
 CellID->53931041]
}, Open  ]],
Cell[4178, 153, 165, 4, 70, "ExampleText",
 CellID->430634261],
Cell[CellGroupData[{
Cell[4368, 161, 653, 21, 70, "Input",
 CellTags->"NDSolve::precw",
 CellID->3090],
Cell[5024, 184, 413, 15, 70, "Output",
 CellTags->"NDSolve::precw",
 CellID->508874799]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5476, 204, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

