(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8601,        298]
NotebookOptionsPosition[      6221,        220]
NotebookOutlinePosition[      7696,        265]
CellTagsIndexPosition[      7579,        259]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::rclist", "ObjectName",
 CellID->5220],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"rclist\"\>"}], ":", 
  " ", "\<\"The value of the option `1` -> `2` should be Automatic or a list \
of the coordinate lists for each spatial dimension.\"\>"}]], "Message", "MSG",
 
 CellID->313237371],

Cell["\<\
Generated when the indicated option does not have one of the expected forms.\
\>", "Notes",
 CellID->22147]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->49233269],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->716239589],

Cell[TextData[{
 "An error occurs in this example because a matrix is not a valid value for  \
the ",
 StyleBox["Coordinates", "MR"],
 " option in this example."
}], "ExampleText",
 CellID->12247715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", "\[Equal]", 
      " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<MethodOfLines\>\"", ",", " ", 
      RowBox[{"\"\<SpatialDiscretization\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<TensorProductGrid\>\"", ",", " ", 
         RowBox[{"\"\<Coordinates\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "3"}], "}"}]}], "}"}]}]}], "}"}]}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellTags->"NDSolve::rclist",
 CellLabel->"In[1]:=",
 CellID->5961],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"rclist\"\>"}], ":", 
  " ", "\<\"The value of the option \\!\\(\\\"Coordinates\\\"\\) -> \
\\!\\({\\(\\({1, 2}\\)\\), \\(\\({2, 3}\\)\\)}\\) should be Automatic or a \
list of the coordinate lists for each spatial dimension.\"\>"}]], "Message", \
"MSG",
 CellTags->"NDSolve::rclist",
 CellID->407675110],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["u", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{
       SuperscriptBox["u", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "\[Equal]", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        SuperscriptBox["x", "2"]}]]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"MethodOfLines\"\>", ",", 
      RowBox[{"\<\"SpatialDiscretization\"\>", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\<\"TensorProductGrid\"\>", ",", 
         RowBox[{"\<\"Coordinates\"\>", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "3"}], "}"}]}], "}"}]}]}], "}"}]}]}], 
     "}"}]}]}], "]"}]], "Output",
 CellTags->"NDSolve::rclist",
 CellLabel->"Out[1]=",
 CellID->276761668]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::rclist - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 23.0635798}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::rclist", "synonyms" -> {}, "title" -> 
    "NDSolve::rclist", "type" -> "Message", "uri" -> "ref/message/rclist"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1671, 65, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->49233269]},
 "NDSolve::rclist"->{
  Cell[2430, 96, 1609, 49, 70, "Input",
   CellTags->"NDSolve::rclist",
   CellID->5961],
  Cell[4042, 147, 359, 8, 70, "Message",
   CellTags->"NDSolve::rclist",
   CellID->407675110],
  Cell[4404, 157, 1751, 56, 70, "Output",
   CellTags->"NDSolve::rclist",
   CellID->276761668]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7132, 242},
 {"NDSolve::rclist", 7272, 246}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->5220],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 256, 6, 70, "Message",
 CellID->313237371],
Cell[1517, 57, 117, 3, 70, "Notes",
 CellID->22147]
}, Closed]],
Cell[CellGroupData[{
Cell[1671, 65, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->49233269],
Cell[CellGroupData[{
Cell[2055, 79, 148, 5, 70, "ExampleSection",
 CellID->716239589],
Cell[2206, 86, 199, 6, 70, "ExampleText",
 CellID->12247715],
Cell[CellGroupData[{
Cell[2430, 96, 1609, 49, 70, "Input",
 CellTags->"NDSolve::rclist",
 CellID->5961],
Cell[4042, 147, 359, 8, 70, "Message",
 CellTags->"NDSolve::rclist",
 CellID->407675110],
Cell[4404, 157, 1751, 56, 70, "Output",
 CellTags->"NDSolve::rclist",
 CellID->276761668]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6194, 218, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

