(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9497,        319]
NotebookOptionsPosition[      7174,        243]
NotebookOutlinePosition[      8317,        277]
CellTagsIndexPosition[      8233,        272]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[BoxData[GridBox[{
   {Cell["NIntegrate::bdith", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"bdith\"\>"}], ":", 
  " ", "\<\"The values of the option BisectionDithering should be reals \
between -1/4 and 1/4.\"\>"}]], "Message", "MSG",
 CellID->317944519],

Cell[TextData[{
 "Generated when the bisection parameter for \"",
 Cell[BoxData["AdaptiveMonteCarlo"], "InlineFormula"],
 "\" and \"",
 Cell[BoxData["AdaptiveQuasiMonteCarlo"], "InlineFormula"],
 "\" is not a real number in the interval ",
 Cell[BoxData[
  RowBox[{"[", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], ",", 
    FractionBox["1", "4"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->662354848]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->723178064],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->144479672],

Cell[TextData[{
 "Example of an incorrect specification for \"",
 Cell[BoxData["BisectionDithering"], "InlineFormula"],
 "\":"
}], "ExampleText",
 CellID->2058893149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"x1", "+", "x2", "+", "x3"}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x2", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x3", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<AdaptiveMonteCarlo\>\"", ",", 
      RowBox[{"\"\<BisectionDithering\>\"", "\[Rule]", "1"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37633216],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"bdith\"\>"}], ":", 
  " ", "\<\"The values of the option BisectionDithering should be reals \
between -1/4 and 1/4. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/bdith\\\", ButtonNote -> \
\\\"NIntegrate::bdith\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->591728312],

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"x1", "+", "x2", "+", "x3"}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x2", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x3", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"AdaptiveMonteCarlo\"\>", ",", 
      RowBox[{"\<\"BisectionDithering\"\>", "\[Rule]", "1"}]}], "}"}]}]}], 
  "]"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->537404685]
}, Open  ]],

Cell[TextData[{
 "The integral above with a correct specification for \"",
 Cell[BoxData["BisectionDithering"], "InlineFormula"],
 "\":"
}], "ExampleText",
 CellID->1928571791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"x1", "+", "x2", "+", "x3"}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x2", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x3", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<AdaptiveMonteCarlo\>\"", ",", 
      RowBox[{"\"\<BisectionDithering\>\"", "\[Rule]", 
       RowBox[{"1", "/", "5"}]}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->426975805],

Cell[BoxData["1.5223440355093036`"], "Output",
 CellLabel->"Out[2]=",
 CellID->1377090]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection"],

Cell[TextData[StyleBox[ButtonBox["NIntegrate",
 BaseStyle->"Link",
 ButtonData->"paclet:ref/NIntegrate"],
 FontFamily->"Verdana"]], "RelatedLinks",
 CellID->258960676]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NIntegrate::bdith - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 46.7985624}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NIntegrate::bdith", "synonyms" -> {}, "title" -> 
    "NIntegrate::bdith", "type" -> "Message", "uri" -> "ref/message/bdith"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3479, 111, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->723178064]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8090, 265}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 1582, 37, 70, "ObjectNameGrid"],
Cell[CellGroupData[{
Cell[2310, 68, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2788, 85, 221, 5, 70, "Message",
 CellID->317944519],
Cell[3012, 92, 430, 14, 70, "Notes",
 CellID->662354848]
}, Closed]],
Cell[CellGroupData[{
Cell[3479, 111, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->723178064],
Cell[CellGroupData[{
Cell[3864, 125, 148, 5, 70, "ExampleSection",
 CellID->144479672],
Cell[4015, 132, 166, 5, 70, "ExampleText",
 CellID->2058893149],
Cell[CellGroupData[{
Cell[4206, 141, 547, 16, 70, "Input",
 CellID->37633216],
Cell[4756, 159, 419, 8, 70, "Message",
 CellID->591728312],
Cell[5178, 169, 549, 16, 70, "Output",
 CellID->537404685]
}, Open  ]],
Cell[5742, 188, 176, 5, 70, "ExampleText",
 CellID->1928571791],
Cell[CellGroupData[{
Cell[5943, 197, 573, 16, 70, "Input",
 CellID->426975805],
Cell[6519, 215, 87, 2, 70, "Output",
 CellID->1377090]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6667, 224, 295, 8, 70, "SeeAlsoSection"],
Cell[6965, 234, 167, 4, 70, "RelatedLinks",
 CellID->258960676]
}, Open  ]],
Cell[7147, 241, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

