(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9098,        317]
NotebookOptionsPosition[      6948,        247]
NotebookOutlinePosition[      8089,        281]
CellTagsIndexPosition[      8005,        276]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NIntegrate::crnzo", "ObjectName"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"crnzo\"\>"}], ":", 
  " ", "\<\"DuffyCoordinates should have its corners specified by lists \
containing zeros and ones. Each corner specification should match the \
dimension of the integral.\"\>"}]], "Message", "MSG",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellID->292003180],

Cell[TextData[{
 "Generated by the method \"",
 Cell[BoxData["DuffyCoordinates"], "InlineFormula"],
 "\" if the specifications for the singular corner points are not lists of \
0's and 1's that correspond to the dimension of the integral. "
}], "Notes"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13606210],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->234507486],

Cell["\<\
Example of an incorrect dimension in the singular corner points \
specification:\
\>", "ExampleText",
 CellID->1322480484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], "]"}]}], "+", 
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"y", "-", "1"}], ")"}], "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<DuffyCoordinates\>\"", ",", 
      RowBox[{"\"\<Corners\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "0", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], "}"}]}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->317135732],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"crnzo\"\>"}], ":", " ", 
  RowBox[{
  "DuffyCoordinates", " ", "should", " ", "have", " ", "its", " ", "corners", 
   " ", "specified", " ", "by", " ", "lists", " ", "containing", " ", "zeros",
    " ", "and", " ", 
   RowBox[{"ones", ".", " ", "Each"}], " ", "corner", " ", "specification", 
   " ", "should", " ", "match", " ", "the", " ", "dimension", " ", "of", " ", 
   "the", " ", 
   RowBox[{"integral", "."}]}]}]], "Message", "MSG",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ShowCellLabel->True,
 CellID->1334260937],

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}]]], "+", 
    FractionBox["1", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "1"}], ")"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"y", "-", "1"}], ")"}], "2"], "+", 
       SuperscriptBox["z", "2"]}]]]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"DuffyCoordinates\"\>", ",", 
      RowBox[{"\<\"Corners\"\>", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "0", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], "}"}]}]}], "}"}]}]}], 
  "]"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1070595412]
}, Open  ]],

Cell["Example of a correct singular corner points specification:", \
"ExampleText",
 CellID->676464767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], "]"}]}], "+", 
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"y", "-", "1"}], ")"}], "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<DuffyCoordinates\>\"", ",", 
      RowBox[{"\"\<Corners\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], "}"}]}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->276200009],

Cell[BoxData["2.380076761525041`"], "Output",
 CellLabel->"Out[2]=",
 CellID->687275567]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NIntegrate::crnzo - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 54.4550084}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NIntegrate::crnzo", "synonyms" -> {}, "title" -> 
    "NIntegrate::crnzo", "type" -> "Message", "uri" -> "ref/message/crnzo"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1886, 68, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->13606210]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7864, 269}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 39, 0, 70, "ObjectName"],
Cell[CellGroupData[{
Cell[767, 31, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1245, 48, 348, 8, 70, "Message",
 CellID->292003180],
Cell[1596, 58, 253, 5, 70, "Notes"]
}, Closed]],
Cell[CellGroupData[{
Cell[1886, 68, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13606210],
Cell[CellGroupData[{
Cell[2270, 82, 148, 5, 70, "ExampleSection",
 CellID->234507486],
Cell[2421, 89, 132, 4, 70, "ExampleText",
 CellID->1322480484],
Cell[CellGroupData[{
Cell[2578, 97, 1155, 37, 70, "Input",
 CellID->317135732],
Cell[3736, 136, 592, 14, 70, "Message",
 CellID->1334260937],
Cell[4331, 152, 1121, 37, 70, "Output",
 CellID->1070595412]
}, Open  ]],
Cell[5467, 192, 103, 2, 70, "ExampleText",
 CellID->676464767],
Cell[CellGroupData[{
Cell[5595, 198, 1196, 38, 70, "Input",
 CellID->276200009],
Cell[6794, 238, 88, 2, 70, "Output",
 CellID->687275567]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6921, 245, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

