(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7271,        259]
NotebookOptionsPosition[      5112,        188]
NotebookOutlinePosition[      6262,        223]
CellTagsIndexPosition[      6178,        218]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NIntegrate::deodiv", "ObjectName"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"deodiv\"\>"}], ":", 
  " ", "\<\"DoubleExponentialOscillatory returns a finite integral estimate, \
but the integral might be divergent.\"\>"}]], "Message", "MSG",
 CellID->73594872],

Cell[TextData[{
 "Generated when the \"",
 Cell[BoxData["DoubleExponentialOscillatory"], "InlineFormula"],
 "\" method gives a finite numerical result a for a possible divergent \
integral. In that case the numerical computation of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", "a", "\[Infinity]"], 
    RowBox[{
     RowBox[{"f", "(", "x", ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]]],
 " should be understood as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderscriptBox["lim", 
     RowBox[{"c", "\[Rule]", "0"}]], "\[ThinSpace]", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "a", "\[Infinity]"], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "c"}], " ", "x"}]], " ", 
       RowBox[{"f", "(", "x", ")"}]}], 
      RowBox[{
       RowBox[{"\[DifferentialD]", "x"}], "."}]}]}]}], TraditionalForm]]]
}], "Notes"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->70054793],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->210084149],

Cell[TextData[{
 "Example of a divergent integral for which \"",
 Cell[BoxData["DoubleExponentialOscillatory"], "InlineFormula"],
 "\" gives a finite result:"
}], "ExampleText",
 CellID->1658509430],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<DoubleExponentialOscillatory\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1306607324],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"deodiv\"\>"}], ":", 
  " ", "\<\"DoubleExponentialOscillatory returns a finite integral estimate, \
but the integral might be divergent. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NIntegrate/deodiv\\\", \
ButtonNote -> \\\"NIntegrate::deodiv\\\"]\\)\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellID->2036735911],

Cell[BoxData["1.0000000128987812`"], "Output",
 CellLabel->"Out[1]=",
 CellID->1628867282]
}, Open  ]],

Cell[TextData[{
 "The numerical integration above corresponds to the following symbolic \
computation with ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1052774197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "c"}], " ", "x"}], "]"}], 
      RowBox[{"Sin", "[", "x", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}], ",", 
   RowBox[{"c", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1395387565],

Cell[BoxData["1"], "Output",
 CellLabel->"Out[2]=",
 CellID->721935671]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NIntegrate::deodiv - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 54.6268878}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NIntegrate::deodiv", "synonyms" -> {}, "title" -> 
    "NIntegrate::deodiv", "type" -> "Message", "uri" -> 
    "ref/message/deodiv"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2471, 88, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->70054793]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6037, 211}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 40, 0, 70, "ObjectName"],
Cell[CellGroupData[{
Cell[768, 31, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1246, 48, 241, 5, 70, "Message",
 CellID->73594872],
Cell[1490, 55, 944, 28, 70, "Notes"]
}, Closed]],
Cell[CellGroupData[{
Cell[2471, 88, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->70054793],
Cell[CellGroupData[{
Cell[2855, 102, 148, 5, 70, "ExampleSection",
 CellID->210084149],
Cell[3006, 109, 198, 5, 70, "ExampleText",
 CellID->1658509430],
Cell[CellGroupData[{
Cell[3229, 118, 313, 9, 70, "Input",
 CellID->1306607324],
Cell[3545, 129, 465, 9, 70, "Message",
 CellID->2036735911],
Cell[4013, 140, 90, 2, 70, "Output",
 CellID->1628867282]
}, Open  ]],
Cell[4118, 145, 398, 14, 70, "ExampleText",
 CellID->1052774197],
Cell[CellGroupData[{
Cell[4541, 163, 431, 14, 70, "Input",
 CellID->1395387565],
Cell[4975, 179, 71, 2, 70, "Output",
 CellID->721935671]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5085, 186, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

