(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6666,        226]
NotebookOptionsPosition[      4664,        161]
NotebookOutlinePosition[      5815,        196]
CellTagsIndexPosition[      5731,        191]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NIntegrate::deorel", "ObjectName"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"deorel\"\>"}], ":", 
  " ", "\<\"The relative error `1` is larger than expected for the integrand \
`2` over `3` with DoubleExponentialOscillatory method and tuning parameters, \
TuningParameters -> `4`.\"\>"}]], "Message", "MSG",
 CellID->10296889],

Cell[TextData[{
 "Generated when the error estimates computed by \"",
 Cell[BoxData["DoubleExponentialOscillatory"], "InlineFormula"],
 "\" does not fit the model of the error behavior. The message is given \
together with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NIntegrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NIntegrate"], "::", "deoncon"}]], 
  "InlineFormula"],
 "."
}], "Notes"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->101518305],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->93155511],

Cell[TextData[{
 "Example of a divergent integral attempted to be computed with \"",
 Cell[BoxData["DoubleExponentialOscillatory"], "InlineFormula"],
 "\": "
}], "ExampleText",
 CellID->793040942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"Exp", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<DoubleExponentialOscillatory\>\"", ",", 
      RowBox[{"\"\<Method\>\"", "\[Rule]", "None"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1973926337],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"deorel\"\>"}], ":", 
  " ", "\<\"The relative error \\!\\(1.0000036519892546`\\) is larger than \
expected for the integrand \\!\\(\[ExponentialE]\\^x\\\\ \
\\(\\(Sin[x]\\)\\)\\) over \\!\\({0, \[Infinity]}\\) with \
DoubleExponentialOscillatory method and tuning parameters, TuningParameters \
-> \\!\\({10, 5}\\).\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellID->1950900171],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"deoncon\"\>"}], ":", 
  " ", "\<\"DoubleExponentialOscillatory has failed to converge for the \
integrand \\!\\(\[ExponentialE]\\^x\\\\ \\(\\(Sin[x]\\)\\)\\) over \\!\\({0, \
\[Infinity]}\\). DoubleExponentialOscillatory obtained \
\\!\\(3.2784617803941034`*^6\\) and \\!\\(10.000036519892546`\\) for the \
integral and error estimates.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellID->540337791],

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"DoubleExponentialOscillatory\"\>", ",", 
      RowBox[{"Method", "\[Rule]", "None"}]}], "}"}]}]}], "]"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->806264414]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NIntegrate::deorel - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 55.1269006}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NIntegrate::deorel", "synonyms" -> {}, "title" -> 
    "NIntegrate::deorel", "type" -> "Message", "uri" -> 
    "ref/message/deorel"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1996, 73, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->101518305]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5589, 184}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 40, 0, 70, "ObjectName"],
Cell[CellGroupData[{
Cell[768, 31, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1246, 48, 308, 6, 70, "Message",
 CellID->10296889],
Cell[1557, 56, 402, 12, 70, "Notes"]
}, Closed]],
Cell[CellGroupData[{
Cell[1996, 73, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->101518305],
Cell[CellGroupData[{
Cell[2381, 87, 147, 5, 70, "ExampleSection",
 CellID->93155511],
Cell[2531, 94, 196, 5, 70, "ExampleText",
 CellID->793040942],
Cell[CellGroupData[{
Cell[2752, 103, 462, 14, 70, "Input",
 CellID->1973926337],
Cell[3217, 119, 444, 9, 70, "Message",
 CellID->1950900171],
Cell[3664, 130, 464, 9, 70, "Message",
 CellID->540337791],
Cell[4131, 141, 467, 13, 70, "Output",
 CellID->806264414]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4637, 159, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

