(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6270,        205]
NotebookOptionsPosition[      4328,        142]
NotebookOutlinePosition[      5482,        177]
CellTagsIndexPosition[      5398,        172]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NIntegrate::deorela", "ObjectName"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"deorela\"\>"}], ":", 
  " ", "\<\"The relative error `1` is larger than expected for the integrand \
`2` over `3` with DoubleExponentialOscillatory method and automatic tuning \
parameters, TuningParameters -> `4`. The integration will proceed with \
TuningParameters -> `5`.\"\>"}]], "Message", "MSG",
 CellID->93829353],

Cell[TextData[{
 "Generated when the \"",
 Cell[BoxData["DoubleExponentialOscillatory"], "InlineFormula"],
 "\" method switches its tuning parameters in order to obtain a result that \
satisfies the requested precision goal. The first parameter is an error \
estimate tightness factor; the second parameter is used for truncation of the \
trapezoidal formula (that has infinite number of terms for \"",
 Cell[BoxData["DoubleExponentialOscillatory"], "InlineFormula"],
 "\")."
}], "Notes"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->31315790],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->242210955],

Cell[TextData[{
 "Example in which the  \"",
 Cell[BoxData["DoubleExponentialOscillatory"], "InlineFormula"],
 "\" tuning parameters are switched:"
}], "ExampleText",
 CellID->793040942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"18", "x"}], "]"}], 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"12", "x"}], "]"}], "/", "x"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<DoubleExponentialOscillatory\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->821685256],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"deorela\"\>"}], ":", 
  " ", "\<\"The relative error \\!\\(5.188476251146331`\\) is larger than \
expected for the integrand \\!\\(\\(\\(\\(Cos[\\(\\(18\\\\ x\\)\\)]\\)\\)\\\\ \
\\(\\(Cos[\\(\\(12\\\\ \\(\\((1 + x)\\)\\)\\)\\)]\\)\\)\\\\ \
\\(\\(Sin[18]\\)\\)\\)\\/\\(1 + x\\)\\) over \\!\\({0, \[Infinity]}\\) with \
DoubleExponentialOscillatory method and automatic tuning parameters, \
TuningParameters -> \\!\\({10, 5}\\). The integration will proceed with \
TuningParameters -> \\!\\({1, 5}\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NIntegrate/deorela\\\", \
ButtonNote -> \\\"NIntegrate::deorela\\\"]\\)\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellID->1496457256],

Cell[BoxData["0.07507428114585168`"], "Output",
 CellLabel->"Out[1]=",
 CellID->793140788]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NIntegrate::deorela - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 54.9393958}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NIntegrate::deorela", "synonyms" -> {}, "title" -> 
    "NIntegrate::deorela", "type" -> "Message", "uri" -> 
    "ref/message/deorela"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2155, 71, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->31315790]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5257, 165}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 41, 0, 70, "ObjectName"],
Cell[CellGroupData[{
Cell[769, 31, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1247, 48, 380, 7, 70, "Message",
 CellID->93829353],
Cell[1630, 57, 488, 9, 70, "Notes"]
}, Closed]],
Cell[CellGroupData[{
Cell[2155, 71, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->31315790],
Cell[CellGroupData[{
Cell[2539, 85, 148, 5, 70, "ExampleSection",
 CellID->242210955],
Cell[2690, 92, 186, 5, 70, "ExampleText",
 CellID->793040942],
Cell[CellGroupData[{
Cell[2901, 101, 435, 14, 70, "Input",
 CellID->821685256],
Cell[3339, 117, 830, 14, 70, "Message",
 CellID->1496457256],
Cell[4172, 133, 90, 2, 70, "Output",
 CellID->793140788]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4301, 140, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

