(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9680,        326]
NotebookOptionsPosition[      7333,        249]
NotebookOutlinePosition[      8475,        283]
CellTagsIndexPosition[      8391,        278]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NIntegrate::grpar", "ObjectName"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"grpar\"\>"}], ":", 
  " ", "\<\"The rule data, `1`, for GeneralRule should be a list of lists of \
equal length that represent the abscissas, weights, and error \
weights.\"\>"}]], "Message", "MSG",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellID->88963079],

Cell[TextData[{
 "Generated when ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 "'s method \"",
 Cell[BoxData["GeneralRule"], "InlineFormula"],
 "\" is given an incorrect value for its sub-option \"",
 Cell[BoxData["RuleData"], "InlineFormula"],
 "\"."
}], "Notes",
 CellID->30962]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->599193702],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->302807529],

Cell["\<\
Specification of Simpson's rule abscissas and weights without error weights:\
\>", "ExampleText",
 CellID->224756581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<GeneralRule\>\"", ",", 
      RowBox[{"\"\<RuleData\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"1", "/", "2"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "/", "6"}], ",", 
           RowBox[{"2", "/", "3"}], ",", 
           RowBox[{"1", "/", "6"}]}], "}"}], ",", 
         RowBox[{"{", "}"}]}], "}"}]}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->955244788],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"grpar\"\>"}], ":", 
  " ", "\<\"The rule data, \\!\\({\\(\\({0, 1\\/2, 1}\\)\\), \\(\\({1\\/6, \
2\\/3, 1\\/6}\\)\\), \\(\\({}\\)\\)}\\), for GeneralRule should be a list of \
lists of equal length that represent the abscissas, weights, and error \
weights.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellID->823567675],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"nsr\"\>"}], ":", 
  " ", "\<\"\\!\\({\\\"GeneralRule\\\", \\(\\(\\\"RuleData\\\" \[Rule] \
\\(\\({\\(\\({0, 1\\/2, 1}\\)\\), \\(\\({1\\/6, 2\\/3, 1\\/6}\\)\\), \\(\\({}\
\\)\\)}\\)\\)\\)\\)}\\) is not a valid specification of an integration \
strategy or rule.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellID->281204686],

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["x"]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"GeneralRule\"\>", ",", 
      RowBox[{"\<\"RuleData\"\>", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           FractionBox["1", "2"], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           FractionBox["1", "6"], ",", 
           FractionBox["2", "3"], ",", 
           FractionBox["1", "6"]}], "}"}], ",", 
         RowBox[{"{", "}"}]}], "}"}]}]}], "}"}]}]}], "]"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1168712146]
}, Open  ]],

Cell["\<\
Specification of Simpson's rule abscissas and weights, and error weights that \
utilize the weights of the trapezoidal rule:\
\>", "ExampleText",
 CellID->369555975],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<GeneralRule\>\"", ",", 
      RowBox[{"\"\<RuleData\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"1", "/", "2"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "/", "6"}], ",", 
           RowBox[{"2", "/", "3"}], ",", 
           RowBox[{"1", "/", "6"}]}], "}"}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "/", "6"}], ",", 
            RowBox[{"2", "/", "3"}], ",", 
            RowBox[{"1", "/", "6"}]}], "}"}], "-", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "/", "4"}], ",", 
            RowBox[{"1", "/", "2"}], ",", 
            RowBox[{"1", "/", "4"}]}], "}"}]}]}], "}"}]}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1976947559],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvb\"\>"}], ":", 
  " ", "\<\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(9\\) recursive bisections in \\!\\(x\\) near \\!\\({x}\\) = \
\\!\\({0.064453125`}\\). NIntegrate obtained \\!\\(2.000000000426351`\\) and \
\\!\\(7.2065850565210775`*^-6\\) for the integral and error \
estimates.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellID->171607922],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvb\"\>"}], ":", 
  " ", "\<\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(9\\) recursive bisections in \\!\\(x\\) near \\!\\({x}\\) = \
\\!\\({0.064453125`}\\). NIntegrate obtained \\!\\(2.000000000426351`\\) and \
\\!\\(7.2065850565210775`*^-6\\) for the integral and error \
estimates.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellID->1879813429],

Cell[BoxData["2.000000000426351`"], "Output",
 CellLabel->"Out[2]=",
 CellID->1545772381]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NIntegrate::grpar - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 13, 55.7206658}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NIntegrate::grpar", "synonyms" -> {}, "title" -> 
    "NIntegrate::grpar", "type" -> "Message", "uri" -> "ref/message/grpar"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1972, 75, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->599193702]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8249, 271}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 39, 0, 70, "ObjectName"],
Cell[CellGroupData[{
Cell[767, 31, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1245, 48, 326, 8, 70, "Message",
 CellID->88963079],
Cell[1574, 58, 361, 12, 70, "Notes",
 CellID->30962]
}, Closed]],
Cell[CellGroupData[{
Cell[1972, 75, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->599193702],
Cell[CellGroupData[{
Cell[2357, 89, 148, 5, 70, "ExampleSection",
 CellID->302807529],
Cell[2508, 96, 127, 3, 70, "ExampleText",
 CellID->224756581],
Cell[CellGroupData[{
Cell[2660, 103, 769, 23, 70, "Input",
 CellID->955244788],
Cell[3432, 128, 385, 8, 70, "Message",
 CellID->823567675],
Cell[3820, 138, 388, 8, 70, "Message",
 CellID->281204686],
Cell[4211, 148, 742, 23, 70, "Output",
 CellID->1168712146]
}, Open  ]],
Cell[4968, 174, 175, 4, 70, "ExampleText",
 CellID->369555975],
Cell[CellGroupData[{
Cell[5168, 182, 1122, 34, 70, "Input",
 CellID->1976947559],
Cell[6293, 218, 439, 9, 70, "Message",
 CellID->171607922],
Cell[6735, 229, 440, 9, 70, "Message",
 CellID->1879813429],
Cell[7178, 240, 89, 2, 70, "Output",
 CellID->1545772381]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7306, 247, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

