(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7463,        273]
NotebookOptionsPosition[      4631,        180]
NotebookOutlinePosition[      6202,        228]
CellTagsIndexPosition[      6084,        222]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NIntegrate::inumr", "ObjectName"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"inumr\"\>"}], ":", 
  RowBox[{"\<\"The integrand `1` has evaluated to non-numerical values for \
all sampling points in the region with boundaries `2`\"\>", 
   "."}]}]], "Message", "MSG",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellID->401617034],

Cell["\<\
Generated when none of the values of the integrand for the sampling points in \
a region (one- or multi-dimensional) is a number.\
\>", "Notes"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->848948708],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->858807595],

Cell["\<\
An error occurs in this example because the integrand contains a parameter \
that does not have a numerical value.\
\>", "ExampleText",
 CellID->469901633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"c", " ", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellTags->"NIntegrate::inum",
 CellLabel->"In[1]:=",
 CellID->20896],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"inumr\"\>"}], ":", 
  " ", "\<\"The integrand \\!\\(Cos[\\(\\(c\\\\ x\\)\\)]\\) has evaluated to \
non-numerical values for all sampling points in the region with boundaries \
\\!\\({\\({0, 6}\\)}\\).\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellID->1640862495],

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"c", " ", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}]], "Output",
 CellTags->"NIntegrate::inum",
 CellLabel->"Out[1]=",
 CellID->347257834]
}, Open  ]],

Cell["\<\
The integral is computed without difficulty if the parameter has a numerical \
value.\
\>", "ExampleText",
 CellID->52836414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", "=", "1"}], "}"}], ",", 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"c", " ", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellTags->"NIntegrate::inum",
 CellLabel->"In[2]:=",
 CellID->13714],

Cell[BoxData[
 RowBox[{"-", "0.27941549819892536`"}]], "Output",
 CellTags->"NIntegrate::inum",
 CellLabel->"Out[2]=",
 CellID->3207612]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection"],

Cell[TextData[StyleBox[ButtonBox["NIntegrate",
 BaseStyle->"Link",
 ButtonData->"paclet:ref/NIntegrate"],
 FontFamily->"Verdana"]], "RelatedLinks",
 CellID->258960676]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NIntegrate::inumr - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 14, 2.4239624}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NIntegrate::inumr", "synonyms" -> {}, "title" -> 
    "NIntegrate::inumr", "type" -> "Message", "uri" -> "ref/message/inumr"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1756, 66, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->848948708]},
 "NIntegrate::inum"->{
  Cell[2482, 95, 271, 9, 70, "Input",
   CellTags->"NIntegrate::inum",
   CellID->20896],
  Cell[3088, 115, 276, 9, 70, "Output",
   CellTags->"NIntegrate::inum",
   CellID->347257834],
  Cell[3539, 135, 385, 13, 70, "Input",
   CellTags->"NIntegrate::inum",
   CellID->13714],
  Cell[3927, 150, 136, 4, 70, "Output",
   CellTags->"NIntegrate::inum",
   CellID->3207612]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5546, 202},
 {"NIntegrate::inum", 5688, 206}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 39, 0, 70, "ObjectName"],
Cell[CellGroupData[{
Cell[767, 31, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1245, 48, 317, 8, 70, "Message",
 CellID->401617034],
Cell[1565, 58, 154, 3, 70, "Notes"]
}, Closed]],
Cell[CellGroupData[{
Cell[1756, 66, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->848948708],
Cell[CellGroupData[{
Cell[2141, 80, 148, 5, 70, "ExampleSection",
 CellID->858807595],
Cell[2292, 87, 165, 4, 70, "ExampleText",
 CellID->469901633],
Cell[CellGroupData[{
Cell[2482, 95, 271, 9, 70, "Input",
 CellTags->"NIntegrate::inum",
 CellID->20896],
Cell[2756, 106, 329, 7, 70, "Message",
 CellID->1640862495],
Cell[3088, 115, 276, 9, 70, "Output",
 CellTags->"NIntegrate::inum",
 CellID->347257834]
}, Open  ]],
Cell[3379, 127, 135, 4, 70, "ExampleText",
 CellID->52836414],
Cell[CellGroupData[{
Cell[3539, 135, 385, 13, 70, "Input",
 CellTags->"NIntegrate::inum",
 CellID->13714],
Cell[3927, 150, 136, 4, 70, "Output",
 CellTags->"NIntegrate::inum",
 CellID->3207612]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4124, 161, 295, 8, 70, "SeeAlsoSection"],
Cell[4422, 171, 167, 4, 70, "RelatedLinks",
 CellID->258960676]
}, Open  ]],
Cell[4604, 178, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

