(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15117,        491]
NotebookOptionsPosition[     11894,        384]
NotebookOutlinePosition[     13284,        426]
CellTagsIndexPosition[     13164,        420]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NIntegrate::mdgen", "ObjectName"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"mdgen\"\>"}], ":", 
  " ", "\<\"The number of generators argument at position `2` in `1` should \
be one of 5, 6, 9, or Automatic.\"\>"}]], "Message", "MSG",
 CellID->48721034],

Cell[TextData[{
 "Generated for the method \"",
 Cell[BoxData["MultiDimensionalRule"], "InlineFormula"],
 "\" when the value for its option \"",
 Cell[BoxData["Generators"], "InlineFormula"],
 "\" is not one of 5, 6, or 9. The value of \"",
 Cell[BoxData["Generators"], "InlineFormula"],
 "\" is used to identify which of the fully symmetric rules of \"",
 Cell[BoxData["MultiDimensionalRule"], "InlineFormula"],
 "\" is going to be used. "
}], "Notes"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->206994988],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->61485076],

Cell["\<\
Example of an incorrect specifying of the number of generating points \
(generators):\
\>", "ExampleText",
 CellID->469901633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "6"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<MultiDimensionalRule\>\"", ",", 
      RowBox[{"\"\<Generators\>\"", "\[Rule]", "4"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellTags->"NIntegrate::inum",
 CellLabel->"In[1]:=",
 CellID->20896],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"mdgen\"\>"}], ":", 
  " ", "\<\"The number of generators argument at position \\!\\(2\\) in \
\\!\\(\\\"Generators\\\" \[Rule] 4\\) should be one of 5, 6, 9, or Automatic.\
\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellID->65904246],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"nsr\"\>"}], ":", 
  " ", "\<\"\\!\\({\\\"MultiDimensionalRule\\\", \\(\\(\\\"Generators\\\" \
\[Rule] 4\\)\\)}\\) is not a valid specification of an integration strategy \
or rule.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellID->397645986],

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "6"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"MultiDimensionalRule\"\>", ",", 
      RowBox[{"\<\"Generators\"\>", "\[Rule]", "4"}]}], "}"}]}]}], 
  "]"}]], "Output",
 CellTags->"NIntegrate::inum",
 CellLabel->"Out[1]=",
 CellID->1827331867]
}, Open  ]],

Cell["Example of a correct generators specification:", "ExampleText",
 CellID->52836414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "6"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<MultiDimensionalRule\>\"", ",", 
      RowBox[{"\"\<Generators\>\"", "\[Rule]", "9"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->139577351],

Cell[BoxData[
 RowBox[{"-", "0.11147211509529455`"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1316694571]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->638065591],

Cell[TextData[{
 "The message is generated also for incorrect calls of ",
 Cell[BoxData["NIntegrate`MultiDimensionalRuleData"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1094887930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"generators", "=", "4"}], ",", 
     RowBox[{"prec", "=", "MachinePrecision"}], ",", 
     RowBox[{"dim", "=", "2"}]}], "}"}], ",", 
   RowBox[{"NIntegrate`MultiDimensionalRuleData", "[", 
    RowBox[{"generators", ",", "prec", ",", "dim"}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->454020368],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate`MultiDimensionalRuleData", "::", "\<\"mdgen\"\>"}], ":",
   " ", "\<\"The number of generators argument at position 1 in \
\\!\\(NIntegrate`MultiDimensionalRuleData[\\(\\(4, MachinePrecision, 2\\)\\)]\
\\) should be one of 5, 6, or 9.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellID->1768828988],

Cell[BoxData[
 RowBox[{"NIntegrate`MultiDimensionalRuleData", "[", 
  RowBox[{"4", ",", "MachinePrecision", ",", "2"}], "]"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->937753371]
}, Open  ]],

Cell[TextData[{
 "Example of a correct call of ",
 Cell[BoxData["NIntegrate`MultiDimensionalRuleData"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->61699875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"generators", "=", "6"}], ",", 
     RowBox[{"prec", "=", "MachinePrecision"}], ",", 
     RowBox[{"dim", "=", "2"}]}], "}"}], ",", 
   RowBox[{"NIntegrate`MultiDimensionalRuleData", "[", 
    RowBox[{"generators", ",", "prec", ",", "dim"}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->1158040809],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.20302858736911977`", ",", "0.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.47795365790226946`", ",", "0.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.375`", ",", "0.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.47795365790226946`", ",", "0.47795365790226946`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"0.34303789878087815`", ",", "0.34303789878087815`"}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.08517699964935077`"}], ",", "0.12359398032043246`", 
       ",", "0.04920550817319602`", ",", "0.`", ",", "0.0097089333373742`", 
       ",", "0.08878582808133502`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.05623030977557619`"}], ",", "0.01874453717550841`", 
         ",", 
         RowBox[{"-", "0.000610323840000683`"}], ",", "0.`", ",", 
         "0.001472478363469758`", ",", 
         RowBox[{"-", "0.005549114255083434`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.0843946326797193`", ",", 
         RowBox[{"-", "0.030898495080108116`"}], ",", 
         RowBox[{"-", "0.0018722312409906513`"}], ",", 
         "0.007595432259555253`", ",", 
         RowBox[{"-", "0.0014724783634697592`"}], ",", 
         "0.005549114255083448`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.4609619031946188`"}], ",", "0.13872286762855895`", 
         ",", 
         RowBox[{"-", "0.01117054665256563`"}], ",", "0.`", ",", 
         RowBox[{"-", "0.0012136166671717751`"}], ",", 
         RowBox[{"-", "0.011098228510166874`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.2712942499123377`", ",", 
         RowBox[{"-", "0.030898495080108116`"}], ",", 
         RowBox[{"-", "0.012301377043299005`"}], ",", "0.`", ",", 
         RowBox[{"-", "0.00242723333434355`"}], ",", 
         RowBox[{"-", "0.022196457020333755`"}]}], "}"}]}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.500874404152338`", ",", "1.648400000000003`", ",", 
         RowBox[{"-", "3.06760299743257`"}], ",", "100.`", ",", 
         "1.0000000000000009`", ",", "1.0000000000000024`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.461981272481936`", ",", "4.4896318499947325`", ",", 
         RowBox[{"-", "5.9664353462315765`"}], ",", "0.`", ",", 
         RowBox[{"-", "0.8241999999999997`"}], ",", "1.999999999999996`"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5885394173188252`", ",", "0.22273541203632835`", ",", 
         RowBox[{"-", "1.1012332185617477`"}], ",", "100.`", ",", 
         RowBox[{"-", "1.9999999999999996`"}], ",", 
         RowBox[{"-", "2.0000000000000004`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "60.00269544719045`", ",", "58.47825158969182`", ",", 
         "5.297241410433378`", ",", "0.25038483990726684`", ",", 
         "34.16114210346597`", ",", "34.16114210346603`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "8.237634212122916`", ",", "10.434939511924933`", ",", 
         "1.5121795274236496`", ",", "3.604308421152221`", ",", 
         "3.0452634448388287`", ",", "5.427894964718813`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "9.85311360483532`", ",", "11.860868890552426`", ",", 
         "2.5676551117977104`", ",", "0.03612354413639655`", ",", 
         "1.6215643128887685`", ",", "1.6215643128887676`"}], "}"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
      "1.`", ",", "4.`", ",", "4.`", ",", "4.`", ",", "4.`", ",", "4.`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "5.`", ",", "5.`", ",", "1.`", ",", "1.`", ",", "0.5`", ",", "0.25`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6", ",", "6"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1977290183]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection"],

Cell[TextData[StyleBox[ButtonBox["NIntegrate",
 BaseStyle->"Link",
 ButtonData->"paclet:ref/NIntegrate"],
 FontFamily->"Verdana"]], "RelatedLinks",
 CellID->258960676]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NIntegrate::mdgen - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 14, 2.5645910}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NIntegrate::mdgen", "synonyms" -> {}, "title" -> 
    "NIntegrate::mdgen", "type" -> "Message", "uri" -> "ref/message/mdgen"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1973, 70, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->206994988]},
 "NIntegrate::inum"->{
  Cell[2669, 99, 568, 18, 70, "Input",
   CellTags->"NIntegrate::inum",
   CellID->20896],
  Cell[3854, 137, 576, 18, 70, "Output",
   CellTags->"NIntegrate::inum",
   CellID->1827331867]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12809, 406},
 {"NIntegrate::inum", 12951, 410}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 39, 0, 70, "ObjectName"],
Cell[CellGroupData[{
Cell[767, 31, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1245, 48, 235, 5, 70, "Message",
 CellID->48721034],
Cell[1483, 55, 453, 10, 70, "Notes"]
}, Closed]],
Cell[CellGroupData[{
Cell[1973, 70, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->206994988],
Cell[CellGroupData[{
Cell[2358, 84, 147, 5, 70, "ExampleSection",
 CellID->61485076],
Cell[2508, 91, 136, 4, 70, "ExampleText",
 CellID->469901633],
Cell[CellGroupData[{
Cell[2669, 99, 568, 18, 70, "Input",
 CellTags->"NIntegrate::inum",
 CellID->20896],
Cell[3240, 119, 300, 7, 70, "Message",
 CellID->65904246],
Cell[3543, 128, 308, 7, 70, "Message",
 CellID->397645986],
Cell[3854, 137, 576, 18, 70, "Output",
 CellTags->"NIntegrate::inum",
 CellID->1827331867]
}, Open  ]],
Cell[4445, 158, 88, 1, 70, "ExampleText",
 CellID->52836414],
Cell[CellGroupData[{
Cell[4558, 163, 541, 17, 70, "Input",
 CellID->139577351],
Cell[5102, 182, 108, 3, 70, "Output",
 CellID->1316694571]
}, Open  ]],
Cell[5225, 188, 125, 3, 70, "ExampleDelimiter",
 CellID->638065591],
Cell[5353, 193, 190, 5, 70, "ExampleText",
 CellID->1094887930],
Cell[CellGroupData[{
Cell[5568, 202, 403, 12, 70, "Input",
 CellID->454020368],
Cell[5974, 216, 350, 7, 70, "Message",
 CellID->1768828988],
Cell[6327, 225, 180, 4, 70, "Output",
 CellID->937753371]
}, Open  ]],
Cell[6522, 232, 164, 5, 70, "ExampleText",
 CellID->61699875],
Cell[CellGroupData[{
Cell[6711, 241, 404, 12, 70, "Input",
 CellID->1158040809],
Cell[7118, 255, 4208, 103, 70, "Output",
 CellID->1977290183]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11387, 365, 295, 8, 70, "SeeAlsoSection"],
Cell[11685, 375, 167, 4, 70, "RelatedLinks",
 CellID->258960676]
}, Open  ]],
Cell[11867, 382, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

