(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8704,        306]
NotebookOptionsPosition[      5661,        204]
NotebookOutlinePosition[      7232,        252]
CellTagsIndexPosition[      7114,        246]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NIntegrate::ncvb", "ObjectName",
 CellID->19706],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvb\"\>"}], ":", 
  " ", "\<\"NIntegrate failed to converge to prescribed accuracy after `1` \
recursive bisections in `2` near `3` = `4`. NIntegrate obtained `5` and `6` \
for the integral and error estimates.\"\>"}]], "Message", "MSG",
 CellID->1520425],

Cell["\<\
Generated when the requested error tolerances are not reached at the \
indicated point when the is reached the maximum number of recursive region \
refinements.\
\>", "Notes",
 CellID->25596],

Cell["\<\
This is a warning message only.  This message does not necessarily indicate \
an error or that the result will be incorrect.\
\>", "Notes",
 CellID->10407],

Cell["\<\
This message often indicates a singularity or a divergence in the integral.\
\>", "Notes",
 CellID->4471],

Cell[TextData[{
 "This message is suppressed by increasing the value given to ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " in the cases the integral requires a larger number of steps to reach a \
result that satisfies the requested precision goal. If the message has been \
caused by a singularity or divergence, the message can be avoided by changing \
the limits of integration or by transforming the integral. The integral and \
error estimates given in the message can help to decide what is the nature of \
the difficulties to reach a convergent result."
}], "Notes",
 CellID->13312]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->154865900],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->264787601],

Cell["\<\
A warning is generated in this example because of the singularity at the \
origin for this highly oscillatory integral:\
\>", "ExampleText",
 CellID->190524147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"20000", "x"}], "]"}], "/", 
    RowBox[{"Sqrt", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"NIntegrate::ncvb",
 CellLabel->"In[1]:=",
 CellID->24487],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvb\"\>"}], ":", 
  " ", "\<\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(9\\) recursive bisections in \\!\\(x\\) near \\!\\({x}\\) = \\!\\({0.`}\
\\). NIntegrate obtained \\!\\(-0.0020416831459624985`\\) and \
\\!\\(0.013656381588790465`\\) for the integral and error estimates.\"\>"}]], \
"Message", "MSG",
 ShowCellLabel->True,
 CellID->1106361904],

Cell[BoxData["0.`"], "Output",
 CellTags->"NIntegrate::ncvb",
 CellLabel->"Out[1]=",
 CellID->166727378]
}, Open  ]],

Cell["\<\
This integral can be computed without difficulty using larger number of \
recursive refinements:\
\>", "ExampleText",
 CellID->148820413],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"20000", "x"}], "]"}], "/", 
    RowBox[{"Sqrt", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "12"}]}], "]"}]], "Input",
 CellTags->"NIntegrate::ncvb",
 CellLabel->"In[2]:=",
 CellID->25840],

Cell[BoxData["0.008895734342445848`"], "Output",
 CellTags->"NIntegrate::ncvb",
 CellLabel->"Out[2]=",
 CellID->109010276]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2804],

Cell[TextData[StyleBox[ButtonBox["NIntegrate",
 BaseStyle->"Link",
 ButtonData->"paclet:ref/NIntegrate"],
 FontFamily->"Verdana"]], "RelatedLinks",
 CellID->258960676]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NIntegrate::ncvb - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 14, 2.8770990}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NIntegrate::ncvb", "synonyms" -> {}, "title" -> 
    "NIntegrate::ncvb", "type" -> "Message", "uri" -> "ref/message/ncvb"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2781, 93, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->154865900]},
 "NIntegrate::ncvb"->{
  Cell[3512, 122, 329, 11, 70, "Input",
   CellTags->"NIntegrate::ncvb",
   CellID->24487],
  Cell[4281, 146, 104, 3, 70, "Output",
   CellTags->"NIntegrate::ncvb",
   CellID->166727378],
  Cell[4572, 160, 381, 12, 70, "Input",
   CellTags->"NIntegrate::ncvb",
   CellID->25840],
  Cell[4956, 174, 122, 3, 70, "Output",
   CellTags->"NIntegrate::ncvb",
   CellID->109010276]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6572, 226},
 {"NIntegrate::ncvb", 6714, 230}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 54, 1, 70, "ObjectName",
 CellID->19706],
Cell[CellGroupData[{
Cell[782, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1260, 49, 315, 6, 70, "Message",
 CellID->1520425],
Cell[1578, 57, 201, 5, 70, "Notes",
 CellID->25596],
Cell[1782, 64, 165, 4, 70, "Notes",
 CellID->10407],
Cell[1950, 70, 115, 3, 70, "Notes",
 CellID->4471],
Cell[2068, 75, 676, 13, 70, "Notes",
 CellID->13312]
}, Closed]],
Cell[CellGroupData[{
Cell[2781, 93, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->154865900],
Cell[CellGroupData[{
Cell[3166, 107, 148, 5, 70, "ExampleSection",
 CellID->264787601],
Cell[3317, 114, 170, 4, 70, "ExampleText",
 CellID->190524147],
Cell[CellGroupData[{
Cell[3512, 122, 329, 11, 70, "Input",
 CellTags->"NIntegrate::ncvb",
 CellID->24487],
Cell[3844, 135, 434, 9, 70, "Message",
 CellID->1106361904],
Cell[4281, 146, 104, 3, 70, "Output",
 CellTags->"NIntegrate::ncvb",
 CellID->166727378]
}, Open  ]],
Cell[4400, 152, 147, 4, 70, "ExampleText",
 CellID->148820413],
Cell[CellGroupData[{
Cell[4572, 160, 381, 12, 70, "Input",
 CellTags->"NIntegrate::ncvb",
 CellID->25840],
Cell[4956, 174, 122, 3, 70, "Output",
 CellTags->"NIntegrate::ncvb",
 CellID->109010276]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5139, 184, 310, 9, 70, "SeeAlsoSection",
 CellID->2804],
Cell[5452, 195, 167, 4, 70, "RelatedLinks",
 CellID->258960676]
}, Open  ]],
Cell[5634, 202, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

