(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10614,        401]
NotebookOptionsPosition[      6254,        255]
NotebookOutlinePosition[      8571,        327]
CellTagsIndexPosition[      8453,        321]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NIntegrate::nlim", "ObjectName",
 CellID->730],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"nlim\"\>"}], ":", 
  " ", "\<\"`1` = `2` is not a valid limit of integration.\"\>"}]], "Message",\
 "MSG",
 CellID->848208631],

Cell[TextData[{
 "Generated when non-numerical limits of integration are  encountered in ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11646]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->526645691],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->11529757],

Cell[TextData[{
 "If the symbol ",
 StyleBox["b", "MR"],
 " in this example does not evaluate to a number, a warning message is  \
generated and the integral is returned unevaluated."
}], "ExampleText",
 CellID->821956408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"Exp", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "b"}], "}"}]}], "]"}]], "Input",
 CellTags->"NIntegrate::nlim",
 CellLabel->"In[1]:=",
 CellID->27187],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"nlim\"\>"}], ":", 
  " ", "\<\"\\!\\(x\\) = \\!\\(b\\) is not a valid limit of \
integration.\"\>"}]], "Message", "MSG",
 CellTags->"NIntegrate::nlim",
 CellID->163633427],

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "b"}], "}"}]}], "]"}]], "Output",
 CellTags->"NIntegrate::nlim",
 CellLabel->"Out[1]=",
 CellID->348777461]
}, Open  ]],

Cell[TextData[{
 "This shows a correct use of ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->134166376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"Exp", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellTags->"NIntegrate::nlim",
 CellLabel->"In[2]:=",
 CellID->257],

Cell[BoxData["41.17107384637542`"], "Output",
 CellTags->"NIntegrate::nlim",
 CellLabel->"Out[2]=",
 CellID->7722388]
}, Open  ]],

Cell["\<\
In a multi-dimensional integral, the warning message will include a point on \
the boundary of the region of integration.\
\>", "ExampleText",
 CellID->228790750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"x", " ", "y"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "b"}], "}"}]}], "]"}]], "Input",
 CellTags->"NIntegrate::nlim",
 CellLabel->"In[3]:=",
 CellID->14549],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"nlim\"\>"}], ":", 
  " ", "\<\"\\!\\(y\\) = \\!\\(b\\) is not a valid limit of \
integration.\"\>"}]], "Message", "MSG",
 CellTags->"NIntegrate::nlim",
 CellID->68105814],

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"x", " ", "y"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "b"}], "}"}]}], "]"}]], "Output",
 CellTags->"NIntegrate::nlim",
 CellLabel->"Out[3]=",
 CellID->604143352]
}, Open  ]],

Cell["\<\
If a symbolic limit of integration is needed in a definition, you can use a \
pattern to prevent the rule from being applied until a numerical value is \
inserted for the limit.\
\>", "ExampleText",
 CellID->262810249],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"b_", "?", "NumberQ"}], "]"}], ":=", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"x", " ", 
     RowBox[{"Exp", "[", "x", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "b"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"NIntegrate::nlim",
 CellLabel->"In[4]:=",
 CellID->27721],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "3", "]"}]], "Input",
 CellTags->"NIntegrate::nlim",
 CellLabel->"In[5]:=",
 CellID->22354],

Cell[BoxData["41.17107384637542`"], "Output",
 CellTags->"NIntegrate::nlim",
 CellLabel->"Out[5]=",
 CellID->504147196]
}, Open  ]],

Cell[TextData[{
 "Unset the rule for ",
 StyleBox["f", "MR"],
 "."
}], "ExampleText",
 CellID->44831118],

Cell[BoxData[
 RowBox[{"Unset", "[", 
  RowBox[{"f", "[", 
   RowBox[{"b_", "?", "NumberQ"}], "]"}], "]"}]], "Input",
 CellTags->"NIntegrate::nlim",
 CellLabel->"In[6]:=",
 CellID->8459]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NIntegrate::nlim - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 14, 10.4085418}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NIntegrate::nlim", "synonyms" -> {}, "title" -> 
    "NIntegrate::nlim", "type" -> "Message", "uri" -> "ref/message/nlim"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1731, 69, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->526645691]},
 "NIntegrate::nlim"->{
  Cell[2513, 100, 271, 9, 70, "Input",
   CellTags->"NIntegrate::nlim",
   CellID->27187],
  Cell[2787, 111, 230, 6, 70, "Message",
   CellTags->"NIntegrate::nlim",
   CellID->163633427],
  Cell[3020, 119, 284, 9, 70, "Output",
   CellTags->"NIntegrate::nlim",
   CellID->348777461],
  Cell[3559, 143, 269, 9, 70, "Input",
   CellTags->"NIntegrate::nlim",
   CellID->257],
  Cell[3831, 154, 117, 3, 70, "Output",
   CellTags->"NIntegrate::nlim",
   CellID->7722388],
  Cell[4160, 168, 308, 10, 70, "Input",
   CellTags->"NIntegrate::nlim",
   CellID->14549],
  Cell[4471, 180, 229, 6, 70, "Message",
   CellTags->"NIntegrate::nlim",
   CellID->68105814],
  Cell[4703, 188, 313, 10, 70, "Output",
   CellTags->"NIntegrate::nlim",
   CellID->604143352],
  Cell[5262, 208, 359, 12, 70, "Input",
   CellTags->"NIntegrate::nlim",
   CellID->27721],
  Cell[5646, 224, 124, 4, 70, "Input",
   CellTags->"NIntegrate::nlim",
   CellID->22354],
  Cell[5773, 230, 119, 3, 70, "Output",
   CellTags->"NIntegrate::nlim",
   CellID->504147196],
  Cell[6014, 243, 186, 6, 70, "Input",
   CellTags->"NIntegrate::nlim",
   CellID->8459]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7166, 277},
 {"NIntegrate::nlim", 7308, 281}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->730],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 185, 5, 70, "Message",
 CellID->848208631],
Cell[1446, 56, 248, 8, 70, "Notes",
 CellID->11646]
}, Closed]],
Cell[CellGroupData[{
Cell[1731, 69, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->526645691],
Cell[CellGroupData[{
Cell[2116, 83, 147, 5, 70, "ExampleSection",
 CellID->11529757],
Cell[2266, 90, 222, 6, 70, "ExampleText",
 CellID->821956408],
Cell[CellGroupData[{
Cell[2513, 100, 271, 9, 70, "Input",
 CellTags->"NIntegrate::nlim",
 CellID->27187],
Cell[2787, 111, 230, 6, 70, "Message",
 CellTags->"NIntegrate::nlim",
 CellID->163633427],
Cell[3020, 119, 284, 9, 70, "Output",
 CellTags->"NIntegrate::nlim",
 CellID->348777461]
}, Open  ]],
Cell[3319, 131, 215, 8, 70, "ExampleText",
 CellID->134166376],
Cell[CellGroupData[{
Cell[3559, 143, 269, 9, 70, "Input",
 CellTags->"NIntegrate::nlim",
 CellID->257],
Cell[3831, 154, 117, 3, 70, "Output",
 CellTags->"NIntegrate::nlim",
 CellID->7722388]
}, Open  ]],
Cell[3963, 160, 172, 4, 70, "ExampleText",
 CellID->228790750],
Cell[CellGroupData[{
Cell[4160, 168, 308, 10, 70, "Input",
 CellTags->"NIntegrate::nlim",
 CellID->14549],
Cell[4471, 180, 229, 6, 70, "Message",
 CellTags->"NIntegrate::nlim",
 CellID->68105814],
Cell[4703, 188, 313, 10, 70, "Output",
 CellTags->"NIntegrate::nlim",
 CellID->604143352]
}, Open  ]],
Cell[5031, 201, 228, 5, 70, "ExampleText",
 CellID->262810249],
Cell[5262, 208, 359, 12, 70, "Input",
 CellTags->"NIntegrate::nlim",
 CellID->27721],
Cell[CellGroupData[{
Cell[5646, 224, 124, 4, 70, "Input",
 CellTags->"NIntegrate::nlim",
 CellID->22354],
Cell[5773, 230, 119, 3, 70, "Output",
 CellTags->"NIntegrate::nlim",
 CellID->504147196]
}, Open  ]],
Cell[5907, 236, 104, 5, 70, "ExampleText",
 CellID->44831118],
Cell[6014, 243, 186, 6, 70, "Input",
 CellTags->"NIntegrate::nlim",
 CellID->8459]
}, Open  ]]
}, Open  ]],
Cell[6227, 253, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

