(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8237,        289]
NotebookOptionsPosition[      4540,        178]
NotebookOutlinePosition[      6953,        246]
CellTagsIndexPosition[      6803,        239]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
NMinimize::belt
NMaximize::belt\
\>", "ObjectName",
 CellID->26223],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"belt\"\>"}], ":", 
  " ", "\<\"Invalid integer elements: `1`. Currently only variables may have \
a specified domain.\"\>"}]], "Message", "MSG",
 CellID->362243719],

Cell[TextData[{
 "Generated when a constraint of the form ",
 StyleBox["Element[", "MR"],
 StyleBox["expr", "TI"],
 StyleBox[", Integers]", "MR"],
 " is encountered, and the expression ",
 StyleBox["expr", "TI"],
 " is not one of the variables."
}], "Notes",
 CellID->6676]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->136714893],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->217411771],

Cell[TextData[{
 "An error occurs in this example because the product ",
 StyleBox["2x", "MR"],
 " is not one of the variables."
}], "ExampleText",
 CellID->333323702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], ",", " ", 
     RowBox[{"Element", "[", 
      RowBox[{
       RowBox[{"2", "x"}], ",", " ", "Integers"}], "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellTags->{"NMinimize::belt", "NMaximize::belt"},
 CellLabel->"In[1]:=",
 CellID->3834],

Cell[BoxData[
 RowBox[{
  RowBox[{"NMinimize", "::", "\<\"belt\"\>"}], ":", 
  " ", "\<\"Invalid integer elements: \\!\\({2\\\\ x}\\). Currently only \
variables may have a specified domain.\"\>"}]], "Message", "MSG",
 CellTags->{"NMinimize::belt", "NMaximize::belt"},
 CellID->543260547],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Infinity]", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "Indeterminate"}], "}"}]}], "}"}]], "Output",
 CellTags->{"NMinimize::belt", "NMaximize::belt"},
 CellLabel->"Out[1]=",
 CellID->22860483]
}, Open  ]],

Cell[TextData[{
 "This shows a valid use of ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " to minimize a function with the constraint that the variable be an  \
integer."
}], "ExampleText",
 CellID->130418659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], ",", " ", 
     RowBox[{"Element", "[", 
      RowBox[{"x", ",", " ", "Integers"}], "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellTags->{"NMinimize::belt", "NMaximize::belt"},
 CellLabel->"In[2]:=",
 CellID->343727229],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.9899924966004454`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "3"}]}], "}"}]}], "}"}]], "Output",
 CellTags->{"NMinimize::belt", "NMaximize::belt"},
 CellLabel->"Out[2]=",
 CellID->492305036]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NMinimize::belt - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 14, 26.7370848}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NMinimize::belt NMaximize::belt", "synonyms" -> {}, "title" -> 
    "NMinimize::belt", "type" -> "Message", "uri" -> "ref/message/belt"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1837, 74, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->136714893]},
 "NMinimize::belt"->{
  Cell[2565, 104, 389, 12, 70, "Input",
   CellTags->{"NMinimize::belt", "NMaximize::belt"},
   CellID->3834],
  Cell[2957, 118, 288, 6, 70, "Message",
   CellTags->{"NMinimize::belt", "NMaximize::belt"},
   CellID->543260547],
  Cell[3248, 126, 243, 7, 70, "Output",
   CellTags->{"NMinimize::belt", "NMaximize::belt"},
   CellID->22860483],
  Cell[3820, 149, 371, 11, 70, "Input",
   CellTags->{"NMinimize::belt", "NMaximize::belt"},
   CellID->343727229],
  Cell[4194, 162, 280, 9, 70, "Output",
   CellTags->{"NMinimize::belt", "NMaximize::belt"},
   CellID->492305036]},
 "NMaximize::belt"->{
  Cell[2565, 104, 389, 12, 70, "Input",
   CellTags->{"NMinimize::belt", "NMaximize::belt"},
   CellID->3834],
  Cell[2957, 118, 288, 6, 70, "Message",
   CellTags->{"NMinimize::belt", "NMaximize::belt"},
   CellID->543260547],
  Cell[3248, 126, 243, 7, 70, "Output",
   CellTags->{"NMinimize::belt", "NMaximize::belt"},
   CellID->22860483],
  Cell[3820, 149, 371, 11, 70, "Input",
   CellTags->{"NMinimize::belt", "NMaximize::belt"},
   CellID->343727229],
  Cell[4194, 162, 280, 9, 70, "Output",
   CellTags->{"NMinimize::belt", "NMaximize::belt"},
   CellID->492305036]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5465, 200},
 {"NMinimize::belt", 5606, 204},
 {"NMaximize::belt", 6204, 220}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 77, 4, 70, "ObjectName",
 CellID->26223],
Cell[CellGroupData[{
Cell[805, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1283, 52, 241, 6, 70, "Message",
 CellID->362243719],
Cell[1527, 60, 273, 9, 70, "Notes",
 CellID->6676]
}, Closed]],
Cell[CellGroupData[{
Cell[1837, 74, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->136714893],
Cell[CellGroupData[{
Cell[2222, 88, 148, 5, 70, "ExampleSection",
 CellID->217411771],
Cell[2373, 95, 167, 5, 70, "ExampleText",
 CellID->333323702],
Cell[CellGroupData[{
Cell[2565, 104, 389, 12, 70, "Input",
 CellTags->{"NMinimize::belt", "NMaximize::belt"},
 CellID->3834],
Cell[2957, 118, 288, 6, 70, "Message",
 CellTags->{"NMinimize::belt", "NMaximize::belt"},
 CellID->543260547],
Cell[3248, 126, 243, 7, 70, "Output",
 CellTags->{"NMinimize::belt", "NMaximize::belt"},
 CellID->22860483]
}, Open  ]],
Cell[3506, 136, 289, 9, 70, "ExampleText",
 CellID->130418659],
Cell[CellGroupData[{
Cell[3820, 149, 371, 11, 70, "Input",
 CellTags->{"NMinimize::belt", "NMaximize::belt"},
 CellID->343727229],
Cell[4194, 162, 280, 9, 70, "Output",
 CellTags->{"NMinimize::belt", "NMaximize::belt"},
 CellID->492305036]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4513, 176, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

