(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8634,        293]
NotebookOptionsPosition[      4856,        179]
NotebookOutlinePosition[      7293,        248]
CellTagsIndexPosition[      7141,        241]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
NMinimize::incst
NMaximize::incst\
\>", "ObjectName",
 CellID->28187],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"incst\"\>"}], ":", 
  " ", "\<\"`1` was unable to generate any initial points satisfying the \
inequality constraints `2`. The initial region specified may not contain any \
feasible points. Changing the initial region or specifying explicit initial \
points may provide a better solution.\"\>"}]], "Message", "MSG",
 CellID->557828749],

Cell["\<\
Generated when the indicated function did not find any points that satisfy \
the constraints.\
\>", "Notes",
 CellID->4797],

Cell["\<\
This error can occur if the constraints are inconsistent, or if the procedure \
used to find starting values for the variables does not find starting values \
that satisfy the constraints.\
\>", "Notes",
 CellID->11230]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->282184171],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->43922263],

Cell["\<\
A warning is generated in this example because NMinimize uses a starting \
value that does not satisfy the constraint.\
\>", "ExampleText",
 CellID->200162288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["x", "2"], ",", " ", 
     RowBox[{
      SuperscriptBox["x", "2"], "\[GreaterEqual]", "1"}]}], "}"}], ",", " ", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellTags->{"NMinimize::incst", "NMaximize::incst"},
 CellLabel->"In[1]:=",
 CellID->17318],

Cell[BoxData[
 RowBox[{
  RowBox[{"NMinimize", "::", "\<\"incst\"\>"}], ":", 
  " ", "\<\"\\!\\(NMinimize\\) was unable to generate any initial points \
satisfying the inequality constraints \\!\\({\\(\\(1 - x\\^2\\)\\) \
\[LessEqual] 0}\\). The initial region specified may not contain any feasible \
points. Changing the initial region or specifying explicit initial points may \
provide a better solution.\"\>"}]], "Message", "MSG",
 CellTags->{"NMinimize::incst", "NMaximize::incst"},
 CellID->26633775],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.9999999990686774`", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0.9999999995343387`"}], "}"}]}], "}"}]], "Output",\

 CellTags->{"NMinimize::incst", "NMaximize::incst"},
 CellLabel->"Out[1]=",
 CellID->488952813]
}, Open  ]],

Cell["\<\
This error can typically be avoided by providing starting values for the \
variable.\
\>", "ExampleText",
 CellID->230667180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["x", "2"], ",", " ", 
     RowBox[{
      SuperscriptBox["x", "2"], "\[GreaterEqual]", "1"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->{"NMinimize::incst", "NMaximize::incst"},
 CellLabel->"In[2]:=",
 CellID->14143],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.9999999990686774`", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0.9999999995343387`"}], "}"}]}], "}"}]], "Output",\

 CellTags->{"NMinimize::incst", "NMaximize::incst"},
 CellLabel->"Out[2]=",
 CellID->4841324]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NMinimize::incst - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 14, 27.2839738}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NMinimize::incst NMaximize::incst", "synonyms" -> {}, 
    "title" -> "NMinimize::incst", "type" -> "Message", "uri" -> 
    "ref/message/incst"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2103, 78, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->282184171]},
 "NMinimize::incst"->{
  Cell[2832, 107, 355, 11, 70, "Input",
   CellTags->{"NMinimize::incst", "NMaximize::incst"},
   CellID->17318],
  Cell[3190, 120, 507, 9, 70, "Message",
   CellTags->{"NMinimize::incst", "NMaximize::incst"},
   CellID->26633775],
  Cell[3700, 131, 262, 8, 70, "Output",
   CellTags->{"NMinimize::incst", "NMaximize::incst"},
   CellID->488952813],
  Cell[4137, 150, 390, 12, 70, "Input",
   CellTags->{"NMinimize::incst", "NMaximize::incst"},
   CellID->14143],
  Cell[4530, 164, 260, 8, 70, "Output",
   CellTags->{"NMinimize::incst", "NMaximize::incst"},
   CellID->4841324]},
 "NMaximize::incst"->{
  Cell[2832, 107, 355, 11, 70, "Input",
   CellTags->{"NMinimize::incst", "NMaximize::incst"},
   CellID->17318],
  Cell[3190, 120, 507, 9, 70, "Message",
   CellTags->{"NMinimize::incst", "NMaximize::incst"},
   CellID->26633775],
  Cell[3700, 131, 262, 8, 70, "Output",
   CellTags->{"NMinimize::incst", "NMaximize::incst"},
   CellID->488952813],
  Cell[4137, 150, 390, 12, 70, "Input",
   CellTags->{"NMinimize::incst", "NMaximize::incst"},
   CellID->14143],
  Cell[4530, 164, 260, 8, 70, "Output",
   CellTags->{"NMinimize::incst", "NMaximize::incst"},
   CellID->4841324]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5791, 202},
 {"NMinimize::incst", 5933, 206},
 {"NMaximize::incst", 6537, 222}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 79, 4, 70, "ObjectName",
 CellID->28187],
Cell[CellGroupData[{
Cell[807, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1285, 52, 413, 8, 70, "Message",
 CellID->557828749],
Cell[1701, 62, 133, 4, 70, "Notes",
 CellID->4797],
Cell[1837, 68, 229, 5, 70, "Notes",
 CellID->11230]
}, Closed]],
Cell[CellGroupData[{
Cell[2103, 78, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->282184171],
Cell[CellGroupData[{
Cell[2488, 92, 147, 5, 70, "ExampleSection",
 CellID->43922263],
Cell[2638, 99, 169, 4, 70, "ExampleText",
 CellID->200162288],
Cell[CellGroupData[{
Cell[2832, 107, 355, 11, 70, "Input",
 CellTags->{"NMinimize::incst", "NMaximize::incst"},
 CellID->17318],
Cell[3190, 120, 507, 9, 70, "Message",
 CellTags->{"NMinimize::incst", "NMaximize::incst"},
 CellID->26633775],
Cell[3700, 131, 262, 8, 70, "Output",
 CellTags->{"NMinimize::incst", "NMaximize::incst"},
 CellID->488952813]
}, Open  ]],
Cell[3977, 142, 135, 4, 70, "ExampleText",
 CellID->230667180],
Cell[CellGroupData[{
Cell[4137, 150, 390, 12, 70, "Input",
 CellTags->{"NMinimize::incst", "NMaximize::incst"},
 CellID->14143],
Cell[4530, 164, 260, 8, 70, "Output",
 CellTags->{"NMinimize::incst", "NMaximize::incst"},
 CellID->4841324]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4829, 177, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

