(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6549,        254]
NotebookOptionsPosition[      3783,        160]
NotebookOutlinePosition[      5397,        211]
CellTagsIndexPosition[      5284,        205]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NSum::nslim", "ObjectName",
 CellID->10142],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NSum", "::", "\<\"nslim\"\>"}], ":", 
  " ", "\<\"Limit of summation `1` is not a number.\"\>"}]], "Message", "MSG",
 
 CellID->11122700],

Cell[TextData[{
 "Generated when the limits on the summation variable in  ",
 Cell[BoxData[
  ButtonBox["NSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSum"]], "InlineFormula"],
 " are not numeric quantities."
}], "Notes",
 CellID->16068]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->336526978],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->173352955],

Cell[TextData[{
 "This input generates an error because the second element in ",
 Cell[BoxData[
  ButtonBox["NSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSum"]], "InlineFormula"],
 " does not give a numerical limit for the variable of summation."
}], "ExampleText",
 CellID->672942354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSum", "[", 
  RowBox[{"k", ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "k"}], "}"}]}], "]"}]], "Input",
 CellTags->"NSum::nslim",
 CellLabel->"In[1]:=",
 CellID->28081],

Cell[BoxData[
 RowBox[{
  RowBox[{"NSum", "::", "\<\"nslim\"\>"}], ":", 
  " ", "\<\"Limit of summation \\!\\(k\\) is not a number.\"\>"}]], "Message",\
 "MSG",
 CellTags->"NSum::nslim",
 CellID->47951449],

Cell[BoxData[
 RowBox[{"NSum", "[", 
  RowBox[{"k", ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "k"}], "}"}]}], "]"}]], "Output",
 CellTags->"NSum::nslim",
 CellLabel->"Out[1]=",
 CellID->175029320]
}, Open  ]],

Cell[TextData[{
 "This shows a correct use of ",
 Cell[BoxData[
  ButtonBox["NSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSum"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->399581025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSum", "[", 
  RowBox[{"k", ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellTags->"NSum::nslim",
 CellLabel->"In[2]:=",
 CellID->22789],

Cell[BoxData["55.`"], "Output",
 CellTags->"NSum::nslim",
 CellLabel->"Out[2]=",
 CellID->33729954]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NSum::nslim - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 15, 6.4724770}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NSum::nslim", "synonyms" -> {}, "title" -> "NSum::nslim", 
    "type" -> "Message", "uri" -> "ref/message/nslim"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1715, 69, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->336526978]},
 "NSum::nslim"->{
  Cell[2573, 102, 194, 7, 70, "Input",
   CellTags->"NSum::nslim",
   CellID->28081],
  Cell[2770, 111, 205, 6, 70, "Message",
   CellTags->"NSum::nslim",
   CellID->47951449],
  Cell[2978, 119, 199, 7, 70, "Output",
   CellTags->"NSum::nslim",
   CellID->175029320],
  Cell[3420, 141, 195, 7, 70, "Input",
   CellTags->"NSum::nslim",
   CellID->22789],
  Cell[3618, 150, 99, 3, 70, "Output",
   CellTags->"NSum::nslim",
   CellID->33729954]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4680, 182},
 {"NSum::nslim", 4817, 186}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 49, 1, 70, "ObjectName",
 CellID->10142],
Cell[CellGroupData[{
Cell[777, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1255, 49, 172, 5, 70, "Message",
 CellID->11122700],
Cell[1430, 56, 248, 8, 70, "Notes",
 CellID->16068]
}, Closed]],
Cell[CellGroupData[{
Cell[1715, 69, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->336526978],
Cell[CellGroupData[{
Cell[2100, 83, 148, 5, 70, "ExampleSection",
 CellID->173352955],
Cell[2251, 90, 297, 8, 70, "ExampleText",
 CellID->672942354],
Cell[CellGroupData[{
Cell[2573, 102, 194, 7, 70, "Input",
 CellTags->"NSum::nslim",
 CellID->28081],
Cell[2770, 111, 205, 6, 70, "Message",
 CellTags->"NSum::nslim",
 CellID->47951449],
Cell[2978, 119, 199, 7, 70, "Output",
 CellTags->"NSum::nslim",
 CellID->175029320]
}, Open  ]],
Cell[3192, 129, 203, 8, 70, "ExampleText",
 CellID->399581025],
Cell[CellGroupData[{
Cell[3420, 141, 195, 7, 70, "Input",
 CellTags->"NSum::nslim",
 CellID->22789],
Cell[3618, 150, 99, 3, 70, "Output",
 CellTags->"NSum::nslim",
 CellID->33729954]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3756, 158, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

