(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25120,        612]
NotebookOptionsPosition[     13801,        333]
NotebookOutlinePosition[     23310,        559]
CellTagsIndexPosition[     22984,        547]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
ParametricPlot::plld
Plot::plld
Plot3D::plld
ContourPlot::plld
DensityPlot::plld
ParametricPlot3D::plld
Play::plld\
\>", "ObjectName",
 CellID->27565],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"plld\"\>"}], ":", 
  " ", "\<\"Endpoints for `1` in `2` must have distinct machine-precision \
numerical values.\"\>"}]], "Message", "MSG",
 CellID->51482378],

Cell["\<\
Generated when the upper limit on the plotting variable is the same as the \
lower limit.\
\>", "Notes",
 CellID->3505]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->778873399],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->814025158],

Cell["\<\
An error occurs in this example because the limits on the plotting variable \
are the same.\
\>", "ExampleText",
 CellID->24092293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
   "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
 CellLabel->"In[1]:=",
 CellID->15974],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "::", "\<\"plld\"\>"}], ":", 
  " ", "\<\"Endpoints for \\!\\(x\\) in \\!\\({x, 0, 0}\\) must have distinct \
machine-precision numerical values.\"\>"}]], "Message", "MSG",
 CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
   "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
 CellID->156879385],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "0"}], "}"}]}], "]"}]], "Output",
 CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
   "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
 CellLabel->"Out[1]=",
 CellID->231177212]
}, Open  ]],

Cell[TextData[{
 "This shows valid limits on the plotting variable in ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->165203807],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
   "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
 CellLabel->"In[2]:=",
 CellID->3037],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2Xk41N/3AHC7GWv2oUhKSVKfLC3onlQKJVooW6WUpEJFH2lRiTbZkz6h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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->
   NCache[{{0, 2 Pi}, {-0.9999998830731719, 0.9999999999999918}}, {{
     0, 6.283185307179586}, {-0.9999998830731719, 0.9999999999999918}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
   "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
 CellLabel->"Out[2]=",
 CellID->451550245]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ParametricPlot::plld - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 15, 31.0199804}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "ParametricPlot::plld Plot::plld Plot3D::plld ContourPlot::plld \
DensityPlot::plld ParametricPlot3D::plld Play::plld", "synonyms" -> {}, 
    "title" -> "ParametricPlot::plld", "type" -> "Message", "uri" -> 
    "ref/message/plld"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1770, 74, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->778873399]},
 "ParametricPlot::plld"->{
  Cell[2472, 103, 365, 10, 70, "Input",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->15974],
  Cell[2840, 115, 390, 8, 70, "Message",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->156879385],
  Cell[3233, 125, 370, 10, 70, "Output",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->231177212],
  Cell[3870, 150, 386, 11, 70, "Input",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->3037],
  Cell[4259, 163, 9476, 163, 70, "Output",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->451550245]},
 "Plot::plld"->{
  Cell[2472, 103, 365, 10, 70, "Input",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->15974],
  Cell[2840, 115, 390, 8, 70, "Message",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->156879385],
  Cell[3233, 125, 370, 10, 70, "Output",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->231177212],
  Cell[3870, 150, 386, 11, 70, "Input",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->3037],
  Cell[4259, 163, 9476, 163, 70, "Output",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->451550245]},
 "Plot3D::plld"->{
  Cell[2472, 103, 365, 10, 70, "Input",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->15974],
  Cell[2840, 115, 390, 8, 70, "Message",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->156879385],
  Cell[3233, 125, 370, 10, 70, "Output",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->231177212],
  Cell[3870, 150, 386, 11, 70, "Input",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->3037],
  Cell[4259, 163, 9476, 163, 70, "Output",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->451550245]},
 "ContourPlot::plld"->{
  Cell[2472, 103, 365, 10, 70, "Input",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->15974],
  Cell[2840, 115, 390, 8, 70, "Message",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->156879385],
  Cell[3233, 125, 370, 10, 70, "Output",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->231177212],
  Cell[3870, 150, 386, 11, 70, "Input",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->3037],
  Cell[4259, 163, 9476, 163, 70, "Output",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->451550245]},
 "DensityPlot::plld"->{
  Cell[2472, 103, 365, 10, 70, "Input",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->15974],
  Cell[2840, 115, 390, 8, 70, "Message",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->156879385],
  Cell[3233, 125, 370, 10, 70, "Output",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->231177212],
  Cell[3870, 150, 386, 11, 70, "Input",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->3037],
  Cell[4259, 163, 9476, 163, 70, "Output",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->451550245]},
 "ParametricPlot3D::plld"->{
  Cell[2472, 103, 365, 10, 70, "Input",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->15974],
  Cell[2840, 115, 390, 8, 70, "Message",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->156879385],
  Cell[3233, 125, 370, 10, 70, "Output",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->231177212],
  Cell[3870, 150, 386, 11, 70, "Input",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->3037],
  Cell[4259, 163, 9476, 163, 70, "Output",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->451550245]},
 "Play::plld"->{
  Cell[2472, 103, 365, 10, 70, "Input",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->15974],
  Cell[2840, 115, 390, 8, 70, "Message",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->156879385],
  Cell[3233, 125, 370, 10, 70, "Output",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->231177212],
  Cell[3870, 150, 386, 11, 70, "Input",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->3037],
  Cell[4259, 163, 9476, 163, 70, "Output",
   CellTags->{
    "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld",
      "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
   CellID->451550245]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14831, 358},
 {"ParametricPlot::plld", 14977, 362},
 {"Plot::plld", 16116, 388},
 {"Plot3D::plld", 17257, 414},
 {"ContourPlot::plld", 18403, 440},
 {"DensityPlot::plld", 19549, 466},
 {"ParametricPlot3D::plld", 20700, 492},
 {"Play::plld", 21839, 518}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 160, 9, 70, "ObjectName",
 CellID->27565],
Cell[CellGroupData[{
Cell[888, 40, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1366, 57, 235, 6, 70, "Message",
 CellID->51482378],
Cell[1604, 65, 129, 4, 70, "Notes",
 CellID->3505]
}, Closed]],
Cell[CellGroupData[{
Cell[1770, 74, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->778873399],
Cell[CellGroupData[{
Cell[2155, 88, 148, 5, 70, "ExampleSection",
 CellID->814025158],
Cell[2306, 95, 141, 4, 70, "ExampleText",
 CellID->24092293],
Cell[CellGroupData[{
Cell[2472, 103, 365, 10, 70, "Input",
 CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
   "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
 CellID->15974],
Cell[2840, 115, 390, 8, 70, "Message",
 CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
   "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
 CellID->156879385],
Cell[3233, 125, 370, 10, 70, "Output",
 CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
   "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
 CellID->231177212]
}, Open  ]],
Cell[3618, 138, 227, 8, 70, "ExampleText",
 CellID->165203807],
Cell[CellGroupData[{
Cell[3870, 150, 386, 11, 70, "Input",
 CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
   "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
 CellID->3037],
Cell[4259, 163, 9476, 163, 70, "Output",
 CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
   "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"},
 CellID->451550245]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[13774, 331, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

