(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7932,        301]
NotebookOptionsPosition[      4548,        190]
NotebookOutlinePosition[      6453,        248]
CellTagsIndexPosition[      6331,        242]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["PolynomialMod::polym", "ObjectName",
 CellID->27894],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"PolynomialMod", "::", "\<\"polym\"\>"}], ":", 
  " ", "\<\"Modulus `1` is not a positive integer.\"\>"}]], "Message", "MSG",
 CellID->650051324],

Cell[TextData[{
 "Generated when the second argument in ",
 Cell[BoxData[
  ButtonBox["PolynomialMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialMod"]], "InlineFormula"],
 " includes a modulus that is a number other than integer."
}], "Notes",
 CellID->20624]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->382237105],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->461376547],

Cell[TextData[{
 "This input generates an error because ",
 StyleBox["7.5", "MR"],
 " is not an integer."
}], "ExampleText",
 CellID->868205256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{
   RowBox[{"11", " ", "+", " ", 
    RowBox[{"37", " ", "x"}]}], ",", " ", "7.5"}], "]"}]], "Input",
 CellTags->"PolynomialMod::polym",
 CellLabel->"In[1]:=",
 CellID->14804],

Cell[BoxData[
 RowBox[{
  RowBox[{"PolynomialMod", "::", "\<\"polym\"\>"}], ":", 
  " ", "\<\"Modulus \\!\\(15\\/2\\) is not a positive integer.\"\>"}]], \
"Message", "MSG",
 CellTags->"PolynomialMod::polym",
 CellID->163574285],

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{
   RowBox[{"11", "+", 
    RowBox[{"37", " ", "x"}]}], ",", "7.5`"}], "]"}]], "Output",
 CellTags->"PolynomialMod::polym",
 CellLabel->"Out[1]=",
 CellID->51911589]
}, Open  ]],

Cell[TextData[{
 "This shows a valid use of ",
 Cell[BoxData[
  ButtonBox["PolynomialMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialMod"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->148356991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{
   RowBox[{"11", "+", 
    RowBox[{"37", "x"}]}], ",", "7"}], "]"}]], "Input",
 CellTags->"PolynomialMod::polym",
 CellLabel->"In[2]:=",
 CellID->27417],

Cell[BoxData[
 RowBox[{"4", "+", 
  RowBox[{"2", " ", "x"}]}]], "Output",
 CellTags->"PolynomialMod::polym",
 CellLabel->"Out[2]=",
 CellID->82664493]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Mod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mod"]], "InlineFormula"],
 " to reduce coefficients modulo a non-integer modulus."
}], "ExampleText",
 CellID->603194596],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"CoefficientList", "[", 
    RowBox[{
     RowBox[{"11", "+", 
      RowBox[{"37", "x"}]}], ",", "x"}], "]"}], ",", "7.5"}], "]"}]], "Input",\

 CellTags->"PolynomialMod::polym",
 CellLabel->"In[3]:=",
 CellID->28182],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.5`", ",", "7.`"}], "}"}]], "Output",
 CellTags->"PolynomialMod::polym",
 CellLabel->"Out[3]=",
 CellID->151746511]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PolynomialMod::polym - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 16, 2.6457900}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "PolynomialMod::polym", "synonyms" -> {}, "title" -> 
    "PolynomialMod::polym", "type" -> "Message", "uri" -> 
    "ref/message/polym"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1759, 68, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->382237105]},
 "PolynomialMod::polym"->{
  Cell[2464, 98, 231, 7, 70, "Input",
   CellTags->"PolynomialMod::polym",
   CellID->14804],
  Cell[2698, 107, 228, 6, 70, "Message",
   CellTags->"PolynomialMod::polym",
   CellID->163574285],
  Cell[2929, 115, 221, 7, 70, "Output",
   CellTags->"PolynomialMod::polym",
   CellID->51911589],
  Cell[3409, 137, 209, 7, 70, "Input",
   CellTags->"PolynomialMod::polym",
   CellID->27417],
  Cell[3621, 146, 150, 5, 70, "Output",
   CellTags->"PolynomialMod::polym",
   CellID->82664493],
  Cell[4048, 166, 275, 10, 70, "Input",
   CellTags->"PolynomialMod::polym",
   CellID->28182],
  Cell[4326, 178, 156, 5, 70, "Output",
   CellTags->"PolynomialMod::polym",
   CellID->151746511]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5477, 213},
 {"PolynomialMod::polym", 5623, 217}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 58, 1, 70, "ObjectName",
 CellID->27894],
Cell[CellGroupData[{
Cell[786, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1264, 49, 179, 4, 70, "Message",
 CellID->650051324],
Cell[1446, 55, 276, 8, 70, "Notes",
 CellID->20624]
}, Closed]],
Cell[CellGroupData[{
Cell[1759, 68, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->382237105],
Cell[CellGroupData[{
Cell[2144, 82, 148, 5, 70, "ExampleSection",
 CellID->461376547],
Cell[2295, 89, 144, 5, 70, "ExampleText",
 CellID->868205256],
Cell[CellGroupData[{
Cell[2464, 98, 231, 7, 70, "Input",
 CellTags->"PolynomialMod::polym",
 CellID->14804],
Cell[2698, 107, 228, 6, 70, "Message",
 CellTags->"PolynomialMod::polym",
 CellID->163574285],
Cell[2929, 115, 221, 7, 70, "Output",
 CellTags->"PolynomialMod::polym",
 CellID->51911589]
}, Open  ]],
Cell[3165, 125, 219, 8, 70, "ExampleText",
 CellID->148356991],
Cell[CellGroupData[{
Cell[3409, 137, 209, 7, 70, "Input",
 CellTags->"PolynomialMod::polym",
 CellID->27417],
Cell[3621, 146, 150, 5, 70, "Output",
 CellTags->"PolynomialMod::polym",
 CellID->82664493]
}, Open  ]],
Cell[3786, 154, 237, 8, 70, "ExampleText",
 CellID->603194596],
Cell[CellGroupData[{
Cell[4048, 166, 275, 10, 70, "Input",
 CellTags->"PolynomialMod::polym",
 CellID->28182],
Cell[4326, 178, 156, 5, 70, "Output",
 CellTags->"PolynomialMod::polym",
 CellID->151746511]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4521, 188, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

