(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6814,        253]
NotebookOptionsPosition[      3887,        156]
NotebookOutlinePosition[      5575,        208]
CellTagsIndexPosition[      5456,        202]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Product::prodwarn", "ObjectName",
 CellID->26714],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Product", "::", "\<\"prodwarn\"\>"}], ":", 
  " ", "\<\"Warning: `1` contains a capital Pi. Use \[EscapeKey]prod\
\[EscapeKey] to enter a product sign.\"\>"}]], "Message", "MSG",
 CellID->784723338],

Cell["\<\
Generated in typeset input when a capital pi   character \[CapitalPi] is \
encountered where a product sign \[Product] is   expected.\
\>", "Notes",
 CellID->29593],

Cell[TextData[{
 "You can enter a product sign using   \[Backslash]",
 StyleBox["[Product]", "MR"],
 ", \[EscapeKey]prod\[EscapeKey], or by selecting the corresponding item   \
from a palette."
}], "Notes",
 CellID->2388]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->100084986],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->113734289],

Cell["\<\
A warning message is generated in this example because of an unexpected use \
of a capital pi character.\
\>", "ExampleText",
 CellID->128695255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   UnderoverscriptBox["\[CapitalPi]", "k", "5"],
   ScriptLevel->0], 
  StyleBox[" ",
   ScriptLevel->0], "k"}]], "Input",
 CellTags->"Product::prodwarn",
 CellLabel->"In[1]:=",
 CellID->78167449],

Cell[BoxData[
 RowBox[{
  RowBox[{"Product", "::", "\<\"prodwarn\"\>"}], ":", 
  " ", "\<\"Warning: \\!\\(\[CapitalPi]\\+k\\%5\\) contains a capital Pi. Use \
\[EscapeKey]prod\[EscapeKey] to enter a product sign.\"\>"}]], "Message", \
"MSG",
 CellTags->"Product::prodwarn",
 CellID->275414799],

Cell[BoxData[
 RowBox[{"k", " ", 
  UnderoverscriptBox["\[CapitalPi]", "k", "5"]}]], "Output",
 CellTags->"Product::prodwarn",
 CellLabel->"Out[1]=",
 CellID->651483389]
}, Open  ]],

Cell["This shows the expected notation for entering a product.", "ExampleText",
 CellID->340174876],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   UnderoverscriptBox["\[Product]", "k", "5"],
   ScriptLevel->0], 
  StyleBox[" ",
   ScriptLevel->0], "k"}]], "Input",
 CellTags->"Product::prodwarn",
 CellLabel->"In[2]:=",
 CellID->16763],

Cell[BoxData["120"], "Output",
 CellTags->"Product::prodwarn",
 CellLabel->"Out[2]=",
 CellID->91642851]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Product::prodwarn - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 16, 18.5836980}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Product::prodwarn", "synonyms" -> {}, "title" -> 
    "Product::prodwarn", "type" -> "Message", "uri" -> 
    "ref/message/prodwarn"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1932, 73, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->100084986]},
 "Product::prodwarn"->{
  Cell[2648, 102, 232, 9, 70, "Input",
   CellTags->"Product::prodwarn",
   CellID->78167449],
  Cell[2883, 113, 293, 7, 70, "Message",
   CellTags->"Product::prodwarn",
   CellID->275414799],
  Cell[3179, 122, 169, 5, 70, "Output",
   CellTags->"Product::prodwarn",
   CellID->651483389],
  Cell[3487, 135, 227, 9, 70, "Input",
   CellTags->"Product::prodwarn",
   CellID->16763],
  Cell[3717, 146, 104, 3, 70, "Output",
   CellTags->"Product::prodwarn",
   CellID->91642851]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4811, 179},
 {"Product::prodwarn", 4954, 183}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 55, 1, 70, "ObjectName",
 CellID->26714],
Cell[CellGroupData[{
Cell[783, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1261, 49, 233, 5, 70, "Message",
 CellID->784723338],
Cell[1497, 56, 174, 4, 70, "Notes",
 CellID->29593],
Cell[1674, 62, 221, 6, 70, "Notes",
 CellID->2388]
}, Closed]],
Cell[CellGroupData[{
Cell[1932, 73, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->100084986],
Cell[CellGroupData[{
Cell[2317, 87, 148, 5, 70, "ExampleSection",
 CellID->113734289],
Cell[2468, 94, 155, 4, 70, "ExampleText",
 CellID->128695255],
Cell[CellGroupData[{
Cell[2648, 102, 232, 9, 70, "Input",
 CellTags->"Product::prodwarn",
 CellID->78167449],
Cell[2883, 113, 293, 7, 70, "Message",
 CellTags->"Product::prodwarn",
 CellID->275414799],
Cell[3179, 122, 169, 5, 70, "Output",
 CellTags->"Product::prodwarn",
 CellID->651483389]
}, Open  ]],
Cell[3363, 130, 99, 1, 70, "ExampleText",
 CellID->340174876],
Cell[CellGroupData[{
Cell[3487, 135, 227, 9, 70, "Input",
 CellTags->"Product::prodwarn",
 CellID->16763],
Cell[3717, 146, 104, 3, 70, "Output",
 CellTags->"Product::prodwarn",
 CellID->91642851]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3860, 154, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

