(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7660,        287]
NotebookOptionsPosition[      4865,        193]
NotebookOutlinePosition[      6497,        244]
CellTagsIndexPosition[      6383,        238]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["RSolve::deqx", "ObjectName",
 CellID->28175],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"RSolve", "::", "\<\"deqx\"\>"}], ":", 
  " ", "\<\"Supplied equations are not difference equations of the given \
functions.\"\>"}]], "Message", "MSG",
 CellID->17127035],

Cell[TextData[{
 "Generated when ",
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 " does not recognize the first argument as a valid specification of a  \
differential equation."
}], "Notes",
 CellID->14465]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->255017140],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->224088493],

Cell[TextData[{
 "An error occurs in this example because the function specified in the  \
second argument of ",
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 " is not the same as the function used in the equations."
}], "ExampleText",
 CellID->9239221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "n", "]"}], "\[Equal]", 
      RowBox[{"n", " ", 
       RowBox[{"f", "[", 
        RowBox[{"n", "-", "1"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"g", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellTags->"RSolve::deqx",
 CellLabel->"In[1]:=",
 CellID->198061354],

Cell[BoxData[
 RowBox[{
  RowBox[{"RSolve", "::", "\<\"deqx\"\>"}], ":", 
  " ", "\<\"Supplied equations are not difference equations of the given \
functions.\"\>"}]], "Message", "MSG",
 CellTags->"RSolve::deqx",
 CellID->68080778],

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "n", "]"}], "\[Equal]", 
      RowBox[{"n", " ", 
       RowBox[{"f", "[", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "n"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"g", "[", "n", "]"}], ",", "n"}], "]"}]], "Output",
 CellTags->"RSolve::deqx",
 CellLabel->"Out[1]=",
 CellID->278814602]
}, Open  ]],

Cell[TextData[{
 "This shows a valid input to ",
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->161139679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "n", "]"}], "\[Equal]", 
      RowBox[{"n", " ", 
       RowBox[{"f", "[", 
        RowBox[{"n", "-", "1"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"f", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellTags->"RSolve::deqx",
 CellLabel->"In[2]:=",
 CellID->8444],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "n", "]"}], "\[Rule]", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "n"}], "]"}]}], "}"}], "}"}]], "Output",
 CellTags->"RSolve::deqx",
 CellLabel->"Out[2]=",
 CellID->175424495]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RSolve::deqx - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 18.8211510}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "RSolve::deqx", "synonyms" -> {}, "title" -> "RSolve::deqx", 
    "type" -> "Message", "uri" -> "ref/message/deqx"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1778, 70, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->255017140]},
 "RSolve::deqx"->{
  Cell[2662, 104, 453, 15, 70, "Input",
   CellTags->"RSolve::deqx",
   CellID->198061354],
  Cell[3118, 121, 232, 6, 70, "Message",
   CellTags->"RSolve::deqx",
   CellID->68080778],
  Cell[3353, 129, 485, 16, 70, "Output",
   CellTags->"RSolve::deqx",
   CellID->278814602],
  Cell[4085, 160, 448, 15, 70, "Input",
   CellTags->"RSolve::deqx",
   CellID->8444],
  Cell[4536, 177, 263, 9, 70, "Output",
   CellTags->"RSolve::deqx",
   CellID->175424495]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5765, 215},
 {"RSolve::deqx", 5903, 219}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 50, 1, 70, "ObjectName",
 CellID->28175],
Cell[CellGroupData[{
Cell[778, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1256, 49, 205, 5, 70, "Message",
 CellID->17127035],
Cell[1464, 56, 277, 9, 70, "Notes",
 CellID->14465]
}, Closed]],
Cell[CellGroupData[{
Cell[1778, 70, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->255017140],
Cell[CellGroupData[{
Cell[2163, 84, 148, 5, 70, "ExampleSection",
 CellID->224088493],
Cell[2314, 91, 323, 9, 70, "ExampleText",
 CellID->9239221],
Cell[CellGroupData[{
Cell[2662, 104, 453, 15, 70, "Input",
 CellTags->"RSolve::deqx",
 CellID->198061354],
Cell[3118, 121, 232, 6, 70, "Message",
 CellTags->"RSolve::deqx",
 CellID->68080778],
Cell[3353, 129, 485, 16, 70, "Output",
 CellTags->"RSolve::deqx",
 CellID->278814602]
}, Open  ]],
Cell[3853, 148, 207, 8, 70, "ExampleText",
 CellID->161139679],
Cell[CellGroupData[{
Cell[4085, 160, 448, 15, 70, "Input",
 CellTags->"RSolve::deqx",
 CellID->8444],
Cell[4536, 177, 263, 9, 70, "Output",
 CellTags->"RSolve::deqx",
 CellID->175424495]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4838, 191, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

