(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6316,        248]
NotebookOptionsPosition[      3580,        154]
NotebookOutlinePosition[      5173,        205]
CellTagsIndexPosition[      5062,        199]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Root::deg", "ObjectName",
 CellID->32484],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Root", "::", "\<\"deg\"\>"}], ":", 
  " ", "\<\"`1` has less than `2` root(s) as a polynomial in `3`.\"\>"}]], \
"Message", "MSG",
 CellID->118281799],

Cell["\<\
Generated when a requested root number exceeds the number of roots in the \
polynomial.\
\>", "Notes",
 CellID->27463]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->248332165],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->493678640],

Cell["\<\
An error occurs in this example because this polynomial does not have a third \
root.\
\>", "ExampleText",
 CellID->34461129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "2"}], ",", "3"}], "]"}]], "Input",
 CellTags->"Root::deg",
 CellLabel->"In[1]:=",
 CellID->17628],

Cell[BoxData[
 RowBox[{
  RowBox[{"Root", "::", "\<\"deg\"\>"}], ":", 
  " ", "\<\"\\!\\(\\(\\(-2\\)\\) + x\\^2\\) has less than \\!\\(3\\) root(s) \
as a polynomial in \\!\\(x\\).\"\>"}]], "Message", "MSG",
 CellTags->"Root::deg",
 CellID->483731905],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    SuperscriptBox["x", "2"]}], ",", "3"}], "]"}]], "Output",
 CellTags->"Root::deg",
 CellLabel->"Out[1]=",
 CellID->85616037]
}, Open  ]],

Cell[TextData[{
 "This shows valid arguments in ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->392842237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "2"}], ",", "2"}], "]"}]], "Input",
 CellTags->"Root::deg",
 CellLabel->"In[2]:=",
 CellID->27914],

Cell[BoxData[
 SqrtBox["2"]], "Output",
 CellTags->"Root::deg",
 CellLabel->"Out[2]=",
 CellID->376072477]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Root::deg - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 2.7113636}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Root::deg", "synonyms" -> {}, "title" -> "Root::deg", 
    "type" -> "Message", "uri" -> "ref/message/deg"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1606, 65, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->248332165]},
 "Root::deg"->{
  Cell[2302, 94, 192, 7, 70, "Input",
   CellTags->"Root::deg",
   CellID->17628],
  Cell[2497, 103, 251, 6, 70, "Message",
   CellTags->"Root::deg",
   CellID->483731905],
  Cell[2751, 111, 217, 8, 70, "Output",
   CellTags->"Root::deg",
   CellID->85616037],
  Cell[3213, 134, 192, 7, 70, "Input",
   CellTags->"Root::deg",
   CellID->27914],
  Cell[3408, 143, 106, 4, 70, "Output",
   CellTags->"Root::deg",
   CellID->376072477]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4469, 176},
 {"Root::deg", 4604, 180}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 47, 1, 70, "ObjectName",
 CellID->32484],
Cell[CellGroupData[{
Cell[775, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1253, 49, 185, 5, 70, "Message",
 CellID->118281799],
Cell[1441, 56, 128, 4, 70, "Notes",
 CellID->27463]
}, Closed]],
Cell[CellGroupData[{
Cell[1606, 65, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->248332165],
Cell[CellGroupData[{
Cell[1991, 79, 148, 5, 70, "ExampleSection",
 CellID->493678640],
Cell[2142, 86, 135, 4, 70, "ExampleText",
 CellID->34461129],
Cell[CellGroupData[{
Cell[2302, 94, 192, 7, 70, "Input",
 CellTags->"Root::deg",
 CellID->17628],
Cell[2497, 103, 251, 6, 70, "Message",
 CellTags->"Root::deg",
 CellID->483731905],
Cell[2751, 111, 217, 8, 70, "Output",
 CellTags->"Root::deg",
 CellID->85616037]
}, Open  ]],
Cell[2983, 122, 205, 8, 70, "ExampleText",
 CellID->392842237],
Cell[CellGroupData[{
Cell[3213, 134, 192, 7, 70, "Input",
 CellTags->"Root::deg",
 CellID->27914],
Cell[3408, 143, 106, 4, 70, "Output",
 CellTags->"Root::deg",
 CellID->376072477]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3553, 152, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

