(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6986,        269]
NotebookOptionsPosition[      4210,        175]
NotebookOutlinePosition[      5830,        226]
CellTagsIndexPosition[      5716,        220]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["RootSum::pfn", "ObjectName",
 CellID->28456],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"RootSum", "::", "\<\"pfn\"\>"}], ":", 
  " ", "\<\"`1` is not a pure function.\"\>"}]], "Message", "MSG",
 CellID->19099148],

Cell[TextData[{
 "Generated when the first argument in ",
 Cell[BoxData[
  ButtonBox["RootSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootSum"]], "InlineFormula"],
 " is not a ",
 Cell[BoxData[
  ButtonBox["Function",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"]], "InlineFormula"],
 " expression."
}], "Notes",
 CellID->12504]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->63363867],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->200430665],

Cell[TextData[{
 "An error occurs in this example because the first argument in ",
 Cell[BoxData[
  ButtonBox["RootSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootSum"]], "InlineFormula"],
 " is a polynomial rather than a ",
 Cell[BoxData[
  ButtonBox["Function",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"]], "InlineFormula"],
 " expression."
}], "ExampleText",
 CellID->319603459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{"2", "+", "x", "-", 
    RowBox[{"x", "^", "2"}]}], ",", "x"}], "]"}]], "Input",
 CellTags->"RootSum::pfn",
 CellLabel->"In[1]:=",
 CellID->125],

Cell[BoxData[
 RowBox[{
  RowBox[{"RootSum", "::", "\<\"pfn\"\>"}], ":", 
  " ", "\<\"\\!\\(2 + x - x\\^2\\) is not a pure function.\"\>"}]], "Message",\
 "MSG",
 CellTags->"RootSum::pfn",
 CellID->225889179],

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{"2", "+", "x", "-", 
    SuperscriptBox["x", "2"]}], ",", "x"}], "]"}]], "Output",
 CellTags->"RootSum::pfn",
 CellLabel->"Out[1]=",
 CellID->1906523]
}, Open  ]],

Cell[TextData[{
 "This shows valid arguments in ",
 Cell[BoxData[
  ButtonBox["RootSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootSum"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->259244035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "+", "#", "-", 
     SuperscriptBox["#1", "2"]}], "&"}], ",", "Identity"}], "]"}]], "Input",
 CellTags->"RootSum::pfn",
 CellLabel->"In[2]:=",
 CellID->4189],

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "+", "#1", "-", 
     SuperscriptBox["#1", "2"]}], "&"}], ",", "Identity"}], "]"}]], "Output",
 CellTags->"RootSum::pfn",
 CellLabel->"Out[2]=",
 CellID->653629805]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RootSum::pfn - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 11.6490924}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "RootSum::pfn", "synonyms" -> {}, "title" -> "RootSum::pfn", 
    "type" -> "Message", "uri" -> "ref/message/pfn"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1808, 73, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->63363867]},
 "RootSum::pfn"->{
  Cell[2777, 111, 206, 7, 70, "Input",
   CellTags->"RootSum::pfn",
   CellID->125],
  Cell[2986, 120, 208, 6, 70, "Message",
   CellTags->"RootSum::pfn",
   CellID->225889179],
  Cell[3197, 128, 212, 7, 70, "Output",
   CellTags->"RootSum::pfn",
   CellID->1906523],
  Cell[3660, 150, 237, 8, 70, "Input",
   CellTags->"RootSum::pfn",
   CellID->4189],
  Cell[3900, 160, 244, 8, 70, "Output",
   CellTags->"RootSum::pfn",
   CellID->653629805]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5109, 197},
 {"RootSum::pfn", 5246, 201}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 50, 1, 70, "ObjectName",
 CellID->28456],
Cell[CellGroupData[{
Cell[778, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1256, 49, 159, 4, 70, "Message",
 CellID->19099148],
Cell[1418, 55, 353, 13, 70, "Notes",
 CellID->12504]
}, Closed]],
Cell[CellGroupData[{
Cell[1808, 73, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->63363867],
Cell[CellGroupData[{
Cell[2192, 87, 148, 5, 70, "ExampleSection",
 CellID->200430665],
Cell[2343, 94, 409, 13, 70, "ExampleText",
 CellID->319603459],
Cell[CellGroupData[{
Cell[2777, 111, 206, 7, 70, "Input",
 CellTags->"RootSum::pfn",
 CellID->125],
Cell[2986, 120, 208, 6, 70, "Message",
 CellTags->"RootSum::pfn",
 CellID->225889179],
Cell[3197, 128, 212, 7, 70, "Output",
 CellTags->"RootSum::pfn",
 CellID->1906523]
}, Open  ]],
Cell[3424, 138, 211, 8, 70, "ExampleText",
 CellID->259244035],
Cell[CellGroupData[{
Cell[3660, 150, 237, 8, 70, "Input",
 CellTags->"RootSum::pfn",
 CellID->4189],
Cell[3900, 160, 244, 8, 70, "Output",
 CellTags->"RootSum::pfn",
 CellID->653629805]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4183, 173, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

