(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9284,        314]
NotebookOptionsPosition[      5025,        192]
NotebookOutlinePosition[      7866,        271]
CellTagsIndexPosition[      7689,        264]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
SchurDecomposition::schurn
HessenbergDecomposition::schurn\
\>", "ObjectName",
 CellID->8029],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"schurn\"\>"}], ":", 
  " ", "\<\"`1` has received a matrix with non-numeric elements.\"\>"}]], \
"Message", "MSG",
 CellID->44666067],

Cell[TextData[{
 "Generated when the first argument in ",
 Cell[BoxData[
  ButtonBox["SchurDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SchurDecomposition"]], "InlineFormula"],
 " is a matrix in which not all of the elements are numbers."
}], "Notes",
 CellID->14586]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->527081223],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->818562615],

Cell["\<\
An error occurs in this example because one of the matrix elements is a \
symbol.\
\>", "ExampleText",
 CellID->727744923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SchurDecomposition", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1.0", ",", "2.3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "x"}], "}"}]}], "}"}], "]"}]], "Input",
 CellTags->{"SchurDecomposition::schurn", "HessenbergDecomposition::schurn"},
 CellLabel->"In[1]:=",
 CellID->19505],

Cell[BoxData[
 RowBox[{
  RowBox[{"SchurDecomposition", "::", "\<\"schurn\"\>"}], ":", 
  " ", "\<\"\\!\\(SchurDecomposition\\) has received a matrix with \
non-numeric elements.\"\>"}]], "Message", "MSG",
 CellTags->{"SchurDecomposition::schurn", "HessenbergDecomposition::schurn"},
 CellID->386771930],

Cell[BoxData[
 RowBox[{"SchurDecomposition", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1.`", ",", "2.3`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "x"}], "}"}]}], "}"}], "]"}]], "Output",
 CellTags->{"SchurDecomposition::schurn", "HessenbergDecomposition::schurn"},
 CellLabel->"Out[1]=",
 CellID->363807360]
}, Open  ]],

Cell[TextData[{
 "This shows a valid argument in ",
 Cell[BoxData[
  ButtonBox["SchurDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SchurDecomposition"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->552286929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "1"}], "}"}], ",", 
   RowBox[{"SchurDecomposition", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1.0", ",", "2.3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "x"}], "}"}]}], "}"}], "]"}]}], "]"}]], "Input",
 CellTags->{"SchurDecomposition::schurn", "HessenbergDecomposition::schurn"},
 CellLabel->"In[2]:=",
 CellID->15006],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.561309623247887`", ",", 
       RowBox[{"-", "0.827605888602368`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.827605888602368`", ",", "0.561309623247887`"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.3911649915626345`", ",", 
       RowBox[{"-", "2.7`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "2.3911649915626336`"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellTags->{"SchurDecomposition::schurn", "HessenbergDecomposition::schurn"},
 CellLabel->"Out[2]=",
 CellID->64231934]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SchurDecomposition::schurn - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 26.5869748}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "SchurDecomposition::schurn HessenbergDecomposition::schurn",
     "synonyms" -> {}, "title" -> "SchurDecomposition::schurn", "type" -> 
    "Message", "uri" -> "ref/message/schurn"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1846, 73, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->527081223]},
 "SchurDecomposition::schurn"->{
  Cell[2539, 102, 341, 10, 70, "Input",
   CellTags->{
    "SchurDecomposition::schurn", "HessenbergDecomposition::schurn"},
   CellID->19505],
  Cell[2883, 114, 303, 6, 70, "Message",
   CellTags->{
    "SchurDecomposition::schurn", "HessenbergDecomposition::schurn"},
   CellID->386771930],
  Cell[3189, 122, 347, 10, 70, "Output",
   CellTags->{
    "SchurDecomposition::schurn", "HessenbergDecomposition::schurn"},
   CellID->363807360],
  Cell[3810, 147, 457, 14, 70, "Input",
   CellTags->{
    "SchurDecomposition::schurn", "HessenbergDecomposition::schurn"},
   CellID->15006],
  Cell[4270, 163, 689, 22, 70, "Output",
   CellTags->{
    "SchurDecomposition::schurn", "HessenbergDecomposition::schurn"},
   CellID->64231934]},
 "HessenbergDecomposition::schurn"->{
  Cell[2539, 102, 341, 10, 70, "Input",
   CellTags->{
    "SchurDecomposition::schurn", "HessenbergDecomposition::schurn"},
   CellID->19505],
  Cell[2883, 114, 303, 6, 70, "Message",
   CellTags->{
    "SchurDecomposition::schurn", "HessenbergDecomposition::schurn"},
   CellID->386771930],
  Cell[3189, 122, 347, 10, 70, "Output",
   CellTags->{
    "SchurDecomposition::schurn", "HessenbergDecomposition::schurn"},
   CellID->363807360],
  Cell[3810, 147, 457, 14, 70, "Input",
   CellTags->{
    "SchurDecomposition::schurn", "HessenbergDecomposition::schurn"},
   CellID->15006],
  Cell[4270, 163, 689, 22, 70, "Output",
   CellTags->{
    "SchurDecomposition::schurn", "HessenbergDecomposition::schurn"},
   CellID->64231934]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6006, 215},
 {"SchurDecomposition::schurn", 6158, 219},
 {"HessenbergDecomposition::schurn", 6931, 240}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 103, 4, 70, "ObjectName",
 CellID->8029],
Cell[CellGroupData[{
Cell[831, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1309, 52, 210, 6, 70, "Message",
 CellID->44666067],
Cell[1522, 60, 287, 8, 70, "Notes",
 CellID->14586]
}, Closed]],
Cell[CellGroupData[{
Cell[1846, 73, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->527081223],
Cell[CellGroupData[{
Cell[2231, 87, 148, 5, 70, "ExampleSection",
 CellID->818562615],
Cell[2382, 94, 132, 4, 70, "ExampleText",
 CellID->727744923],
Cell[CellGroupData[{
Cell[2539, 102, 341, 10, 70, "Input",
 CellTags->{"SchurDecomposition::schurn", "HessenbergDecomposition::schurn"},
 CellID->19505],
Cell[2883, 114, 303, 6, 70, "Message",
 CellTags->{"SchurDecomposition::schurn", "HessenbergDecomposition::schurn"},
 CellID->386771930],
Cell[3189, 122, 347, 10, 70, "Output",
 CellTags->{"SchurDecomposition::schurn", "HessenbergDecomposition::schurn"},
 CellID->363807360]
}, Open  ]],
Cell[3551, 135, 234, 8, 70, "ExampleText",
 CellID->552286929],
Cell[CellGroupData[{
Cell[3810, 147, 457, 14, 70, "Input",
 CellTags->{"SchurDecomposition::schurn", "HessenbergDecomposition::schurn"},
 CellID->15006],
Cell[4270, 163, 689, 22, 70, "Output",
 CellTags->{"SchurDecomposition::schurn", "HessenbergDecomposition::schurn"},
 CellID->64231934]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4998, 190, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

