(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9151,        333]
NotebookOptionsPosition[      6375,        239]
NotebookOutlinePosition[      7995,        290]
CellTagsIndexPosition[      7882,        284]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Series::icm", "ObjectName",
 CellID->4326],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "::", "\<\"icm\"\>"}], ":", 
  " ", "\<\"Series in `1` to be combined have unequal expansion points `2` \
and `3`.\"\>"}]], "Message", "MSG",
 CellID->375580599],

Cell["\<\
Generated when two series expansions to be added, multiplied, or otherwise \
combined do not have the same expansion point.\
\>", "Notes",
 CellID->5291]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->524287999],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->6505105],

Cell["\<\
An error occurs in this example because series expansions around different \
expansion points cannot be added together.\
\>", "ExampleText",
 CellID->344330148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}], "+", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "2", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"Series::icm",
 CellLabel->"In[1]:=",
 CellID->16472],

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "::", "\<\"icm\"\>"}], ":", 
  " ", "\<\"Series in \\!\\(x\\) to be combined have unequal expansion points \
\\!\\(1\\) and \\!\\(2\\).\"\>"}]], "Message", "MSG",
 CellTags->"Series::icm",
 CellID->88667394],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     RowBox[{"Sin", "[", "1", "]"}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", "1", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}]}], "-", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"Sin", "[", "1", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "2"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        RowBox[{"x", "-", "1"}], "]"}], "3"],
      SeriesData[$CellContext`x, 1, {}, 0, 3, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 1, {
      Sin[1], 
      Cos[1], Rational[-1, 2] Sin[1]}, 0, 3, 1],
    Editable->False], ")"}], "+", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     RowBox[{"Cos", "[", "2", "]"}], "-", 
     RowBox[{
      RowBox[{"Sin", "[", "2", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "2"}], ")"}]}], "-", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"Cos", "[", "2", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", "2"}], ")"}], "2"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        RowBox[{"x", "-", "2"}], "]"}], "3"],
      SeriesData[$CellContext`x, 2, {}, 0, 3, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 2, {
      Cos[2], -Sin[2], Rational[-1, 2] Cos[2]}, 0, 3, 1],
    Editable->False], ")"}]}]], "Output",
 CellTags->"Series::icm",
 CellLabel->"Out[1]=",
 CellID->231169859]
}, Open  ]],

Cell["\<\
This shows addition of series expansions with the same expansion point.\
\>", "ExampleText",
 CellID->100417369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}], "+", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"Series::icm",
 CellLabel->"In[2]:=",
 CellID->28685],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Cos", "[", "1", "]"}], "+", 
     RowBox[{"Sin", "[", "1", "]"}]}], ")"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cos", "[", "1", "]"}], "-", 
      RowBox[{"Sin", "[", "1", "]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"Cos", "[", "1", "]"}], "2"]}], "-", 
      FractionBox[
       RowBox[{"Sin", "[", "1", "]"}], "2"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "1"}], "]"}], "3"],
    SeriesData[$CellContext`x, 1, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 1, {
   Cos[1] + Sin[1], Cos[1] - Sin[1], Rational[-1, 2] Cos[1] + 
    Rational[-1, 2] Sin[1]}, 0, 3, 1],
  Editable->False]], "Output",
 CellTags->"Series::icm",
 CellLabel->"Out[2]=",
 CellID->246103085]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Series::icm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 42.6967622}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Series::icm", "synonyms" -> {}, "title" -> "Series::icm", 
    "type" -> "Message", "uri" -> "ref/message/icm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1662, 65, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->524287999]},
 "Series::icm"->{
  Cell[2391, 94, 414, 14, 70, "Input",
   CellTags->"Series::icm",
   CellID->16472],
  Cell[2808, 110, 251, 6, 70, "Message",
   CellTags->"Series::icm",
   CellID->88667394],
  Cell[3062, 118, 1569, 51, 70, "Output",
   CellTags->"Series::icm",
   CellID->231169859],
  Cell[4793, 179, 414, 14, 70, "Input",
   CellTags->"Series::icm",
   CellID->28685],
  Cell[5210, 195, 1099, 37, 70, "Output",
   CellTags->"Series::icm",
   CellID->246103085]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7271, 261},
 {"Series::icm", 7408, 265}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 48, 1, 70, "ObjectName",
 CellID->4326],
Cell[CellGroupData[{
Cell[776, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1254, 49, 205, 5, 70, "Message",
 CellID->375580599],
Cell[1462, 56, 163, 4, 70, "Notes",
 CellID->5291]
}, Closed]],
Cell[CellGroupData[{
Cell[1662, 65, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->524287999],
Cell[CellGroupData[{
Cell[2047, 79, 146, 5, 70, "ExampleSection",
 CellID->6505105],
Cell[2196, 86, 170, 4, 70, "ExampleText",
 CellID->344330148],
Cell[CellGroupData[{
Cell[2391, 94, 414, 14, 70, "Input",
 CellTags->"Series::icm",
 CellID->16472],
Cell[2808, 110, 251, 6, 70, "Message",
 CellTags->"Series::icm",
 CellID->88667394],
Cell[3062, 118, 1569, 51, 70, "Output",
 CellTags->"Series::icm",
 CellID->231169859]
}, Open  ]],
Cell[4646, 172, 122, 3, 70, "ExampleText",
 CellID->100417369],
Cell[CellGroupData[{
Cell[4793, 179, 414, 14, 70, "Input",
 CellTags->"Series::icm",
 CellID->28685],
Cell[5210, 195, 1099, 37, 70, "Output",
 CellTags->"Series::icm",
 CellID->246103085]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6348, 237, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

