(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8429,        319]
NotebookOptionsPosition[      5022,        203]
NotebookOutlinePosition[      6921,        263]
CellTagsIndexPosition[      6807,        257]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Series::sbyc", "ObjectName",
 CellID->21195],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "::", "\<\"sbyc\"\>"}], ":", 
  " ", "\<\"Division by a series with no coefficients in `1`.\"\>"}]], \
"Message", "MSG",
 CellID->908904859],

Cell["\<\
Generated when a series expansion with no coefficients is encountered in the \
denominator of an expression.\
\>", "Notes",
 CellID->17200]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->228557052],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->2085537],

Cell["\<\
An error occurs in this example because this division is not well defined.\
\>", "ExampleText",
 CellID->62553936],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"O", "[", "x", "]"}]}]], "Input",
 CellTags->"Series::sbyc",
 CellLabel->"In[1]:=",
 CellID->30426],

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "::", "\<\"sbyc\"\>"}], ":", 
  " ", "\<\"Division by a series with no coefficients in \
\\!\\(1\\/\\*InterpretationBox[\\(\\(O[x]\\)\\^1\\), SeriesData[x, 0, List[], \
1, 1, 1], Rule[Editable, False]]\\).\"\>"}]], "Message", "MSG",
 CellTags->"Series::sbyc",
 CellID->104700152],

Cell[BoxData[
 InterpretationBox[
  FractionBox["1", 
   RowBox[{"O", "[", "x", "]"}]],
  SeriesData[$CellContext`x, 0, {}, -1, -1, 1],
  Editable->False]], "Output",
 CellTags->"Series::sbyc",
 CellLabel->"Out[1]=",
 CellID->158463505]
}, Open  ]],

Cell["This example shows a similar error.", "ExampleText",
 CellID->188405054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ")"}]}]], "Input",\

 CellTags->"Series::sbyc",
 CellLabel->"In[2]:=",
 CellID->22714],

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "::", "\<\"sbyc\"\>"}], ":", 
  " ", "\<\"Division by a series with no coefficients in \
\\!\\(1\\/\\*InterpretationBox[\\(\\(O[x]\\)\\^2\\), SeriesData[x, 0, List[], \
2, 2, 1], Rule[Editable, False]]\\).\"\>"}]], "Message", "MSG",
 CellTags->"Series::sbyc",
 CellID->9348793],

Cell[BoxData[
 InterpretationBox[
  FractionBox["1", 
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "2"]],
  SeriesData[$CellContext`x, 0, {}, -2, -2, 1],
  Editable->False]], "Output",
 CellTags->"Series::sbyc",
 CellLabel->"Out[2]=",
 CellID->658338137]
}, Open  ]],

Cell["\<\
This reciprocal can be computed if more terms are kept in the original \
series.\
\>", "ExampleText",
 CellID->163789632],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]}], ")"}]}]], "Input",\

 CellTags->"Series::sbyc",
 CellLabel->"In[3]:=",
 CellID->29232],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["2", 
    SuperscriptBox["x", "2"]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "0"],
    SeriesData[$CellContext`x, 0, {}, -2, 0, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {2}, -2, 0, 1],
  Editable->False]], "Output",
 CellTags->"Series::sbyc",
 CellLabel->"Out[3]=",
 CellID->104494119]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Series::sbyc - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 43.1655242}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Series::sbyc", "synonyms" -> {}, "title" -> "Series::sbyc", 
    "type" -> "Message", "uri" -> "ref/message/sbyc"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1629, 65, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->228557052]},
 "Series::sbyc"->{
  Cell[2312, 93, 143, 5, 70, "Input",
   CellTags->"Series::sbyc",
   CellID->30426],
  Cell[2458, 100, 323, 7, 70, "Message",
   CellTags->"Series::sbyc",
   CellID->104700152],
  Cell[2784, 109, 236, 8, 70, "Output",
   CellTags->"Series::sbyc",
   CellID->158463505],
  Cell[3138, 125, 324, 12, 70, "Input",
   CellTags->"Series::sbyc",
   CellID->22714],
  Cell[3465, 139, 321, 7, 70, "Message",
   CellTags->"Series::sbyc",
   CellID->9348793],
  Cell[3789, 148, 262, 9, 70, "Output",
   CellTags->"Series::sbyc",
   CellID->658338137],
  Cell[4222, 168, 324, 12, 70, "Input",
   CellTags->"Series::sbyc",
   CellID->29232],
  Cell[4549, 182, 407, 14, 70, "Output",
   CellTags->"Series::sbyc",
   CellID->104494119]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5922, 225},
 {"Series::sbyc", 6060, 229}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 50, 1, 70, "ObjectName",
 CellID->21195],
Cell[CellGroupData[{
Cell[778, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1256, 49, 184, 5, 70, "Message",
 CellID->908904859],
Cell[1443, 56, 149, 4, 70, "Notes",
 CellID->17200]
}, Closed]],
Cell[CellGroupData[{
Cell[1629, 65, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->228557052],
Cell[CellGroupData[{
Cell[2014, 79, 146, 5, 70, "ExampleSection",
 CellID->2085537],
Cell[2163, 86, 124, 3, 70, "ExampleText",
 CellID->62553936],
Cell[CellGroupData[{
Cell[2312, 93, 143, 5, 70, "Input",
 CellTags->"Series::sbyc",
 CellID->30426],
Cell[2458, 100, 323, 7, 70, "Message",
 CellTags->"Series::sbyc",
 CellID->104700152],
Cell[2784, 109, 236, 8, 70, "Output",
 CellTags->"Series::sbyc",
 CellID->158463505]
}, Open  ]],
Cell[3035, 120, 78, 1, 70, "ExampleText",
 CellID->188405054],
Cell[CellGroupData[{
Cell[3138, 125, 324, 12, 70, "Input",
 CellTags->"Series::sbyc",
 CellID->22714],
Cell[3465, 139, 321, 7, 70, "Message",
 CellTags->"Series::sbyc",
 CellID->9348793],
Cell[3789, 148, 262, 9, 70, "Output",
 CellTags->"Series::sbyc",
 CellID->658338137]
}, Open  ]],
Cell[4066, 160, 131, 4, 70, "ExampleText",
 CellID->163789632],
Cell[CellGroupData[{
Cell[4222, 168, 324, 12, 70, "Input",
 CellTags->"Series::sbyc",
 CellID->29232],
Cell[4549, 182, 407, 14, 70, "Output",
 CellTags->"Series::sbyc",
 CellID->104494119]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4995, 201, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

