(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6877,        257]
NotebookOptionsPosition[      4052,        163]
NotebookOutlinePosition[      5704,        214]
CellTagsIndexPosition[      5588,        208]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Series::serlim", "ObjectName",
 CellID->8921],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "::", "\<\"serlim\"\>"}], ":", 
  " ", "\<\"Series order specification `1` is not a machine-size \
integer.\"\>"}]], "Message", "MSG",
 CellID->519006953],

Cell["\<\
Generated when the specification of the number of terms to compute in a \
series is not an integer or cannot be represented as a machine integer on \
your computer.\
\>", "Notes",
 CellID->31714]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->36799758],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->216583441],

Cell["\<\
An error occurs in this example because the limit specification is a symbol \
rather than an integer.\
\>", "ExampleText",
 CellID->629453276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "x"}], "}"}]}], "]"}]], "Input",
 CellTags->"Series::serlim",
 CellLabel->"In[1]:=",
 CellID->294288237],

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "::", "\<\"serlim\"\>"}], ":", 
  " ", "\<\"Series order specification \\!\\(x\\) is not a machine-size \
integer.\"\>"}]], "Message", "MSG",
 CellTags->"Series::serlim",
 CellID->430315281],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "x"}], "}"}]}], "]"}]], "Output",
 CellTags->"Series::serlim",
 CellLabel->"Out[1]=",
 CellID->156500183]
}, Open  ]],

Cell["\<\
This shows a valid specification for the number of terms in a series.\
\>", "ExampleText",
 CellID->383148009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellTags->"Series::serlim",
 CellLabel->"In[2]:=",
 CellID->22077],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 2]}, 0, 4, 1],
  Editable->False]], "Output",
 CellTags->"Series::serlim",
 CellLabel->"Out[2]=",
 CellID->129232022]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Series::serlim - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 43.3217782}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Series::serlim", "synonyms" -> {}, "title" -> 
    "Series::serlim", "type" -> "Message", "uri" -> "ref/message/serlim"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1700, 66, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->36799758]},
 "Series::serlim"->{
  Cell[2412, 95, 244, 8, 70, "Input",
   CellTags->"Series::serlim",
   CellID->294288237],
  Cell[2659, 105, 234, 6, 70, "Message",
   CellTags->"Series::serlim",
   CellID->430315281],
  Cell[2896, 113, 245, 8, 70, "Output",
   CellTags->"Series::serlim",
   CellID->156500183],
  Cell[3301, 131, 240, 8, 70, "Input",
   CellTags->"Series::serlim",
   CellID->22077],
  Cell[3544, 141, 442, 15, 70, "Output",
   CellTags->"Series::serlim",
   CellID->129232022]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4960, 185},
 {"Series::serlim", 5099, 189}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->8921],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 198, 5, 70, "Message",
 CellID->519006953],
Cell[1458, 56, 205, 5, 70, "Notes",
 CellID->31714]
}, Closed]],
Cell[CellGroupData[{
Cell[1700, 66, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->36799758],
Cell[CellGroupData[{
Cell[2084, 80, 148, 5, 70, "ExampleSection",
 CellID->216583441],
Cell[2235, 87, 152, 4, 70, "ExampleText",
 CellID->629453276],
Cell[CellGroupData[{
Cell[2412, 95, 244, 8, 70, "Input",
 CellTags->"Series::serlim",
 CellID->294288237],
Cell[2659, 105, 234, 6, 70, "Message",
 CellTags->"Series::serlim",
 CellID->430315281],
Cell[2896, 113, 245, 8, 70, "Output",
 CellTags->"Series::serlim",
 CellID->156500183]
}, Open  ]],
Cell[3156, 124, 120, 3, 70, "ExampleText",
 CellID->383148009],
Cell[CellGroupData[{
Cell[3301, 131, 240, 8, 70, "Input",
 CellTags->"Series::serlim",
 CellID->22077],
Cell[3544, 141, 442, 15, 70, "Output",
 CellTags->"Series::serlim",
 CellID->129232022]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4025, 161, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

