(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7541,        278]
NotebookOptionsPosition[      4751,        184]
NotebookOutlinePosition[      6379,        235]
CellTagsIndexPosition[      6265,        229]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Series::vcnt", "ObjectName",
 CellID->24811],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "::", "\<\"vcnt\"\>"}], ":", 
  " ", "\<\"Center point `2` of power series expansion involves the variable \
`1`.\"\>"}]], "Message", "MSG",
 CellID->439425427],

Cell[TextData[{
 "Generated when the second argument in ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " specifies an expansion point that is not independent of the expansion  \
variable."
}], "Notes",
 CellID->29150]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->551409503],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->779996550],

Cell["\<\
An error occurs in this example because the expansion point is the same \
symbol as the expansion variable.\
\>", "ExampleText",
 CellID->283855228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellTags->"Series::vcnt",
 CellLabel->"In[1]:=",
 CellID->18766],

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "::", "\<\"vcnt\"\>"}], ":", 
  " ", "\<\"Center point \\!\\(x\\) of power series expansion involves the \
variable \\!\\(x\\).\"\>"}]], "Message", "MSG",
 CellTags->"Series::vcnt",
 CellID->6169249],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "3"}], "}"}]}], "]"}]], "Output",
 CellTags->"Series::vcnt",
 CellLabel->"Out[1]=",
 CellID->231457923]
}, Open  ]],

Cell["\<\
This shows a valid expansion point for this series expansion.\
\>", "ExampleText",
 CellID->198047998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellTags->"Series::vcnt",
 CellLabel->"In[2]:=",
 CellID->43996842],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Cos", "[", "x0", "]"}], "-", 
   RowBox[{
    RowBox[{"Sin", "[", "x0", "]"}], " ", 
    RowBox[{"(", 
     RowBox[{"x", "-", "x0"}], ")"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Cos", "[", "x0", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "x0"}], ")"}], "2"]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"Sin", "[", "x0", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "x0"}], ")"}], "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "x0"}], "]"}], "4"],
    SeriesData[$CellContext`x, $CellContext`x0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, $CellContext`x0, {
    Cos[$CellContext`x0], -Sin[$CellContext`x0], Rational[-1, 2] 
    Cos[$CellContext`x0], Rational[1, 6] Sin[$CellContext`x0]}, 0, 4, 1],
  Editable->False]], "Output",
 CellTags->"Series::vcnt",
 CellLabel->"Out[2]=",
 CellID->19028321]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Series::vcnt - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 43.6811624}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Series::vcnt", "synonyms" -> {}, "title" -> "Series::vcnt", 
    "type" -> "Message", "uri" -> "ref/message/vcnt"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1789, 70, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->551409503]},
 "Series::vcnt"->{
  Cell[2508, 99, 238, 8, 70, "Input",
   CellTags->"Series::vcnt",
   CellID->18766],
  Cell[2749, 109, 243, 6, 70, "Message",
   CellTags->"Series::vcnt",
   CellID->6169249],
  Cell[2995, 117, 243, 8, 70, "Output",
   CellTags->"Series::vcnt",
   CellID->231457923],
  Cell[3390, 135, 242, 8, 70, "Input",
   CellTags->"Series::vcnt",
   CellID->43996842],
  Cell[3635, 145, 1050, 32, 70, "Output",
   CellTags->"Series::vcnt",
   CellID->19028321]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5651, 206},
 {"Series::vcnt", 5789, 210}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 50, 1, 70, "ObjectName",
 CellID->24811],
Cell[CellGroupData[{
Cell[778, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1256, 49, 204, 5, 70, "Message",
 CellID->439425427],
Cell[1463, 56, 289, 9, 70, "Notes",
 CellID->29150]
}, Closed]],
Cell[CellGroupData[{
Cell[1789, 70, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->551409503],
Cell[CellGroupData[{
Cell[2174, 84, 148, 5, 70, "ExampleSection",
 CellID->779996550],
Cell[2325, 91, 158, 4, 70, "ExampleText",
 CellID->283855228],
Cell[CellGroupData[{
Cell[2508, 99, 238, 8, 70, "Input",
 CellTags->"Series::vcnt",
 CellID->18766],
Cell[2749, 109, 243, 6, 70, "Message",
 CellTags->"Series::vcnt",
 CellID->6169249],
Cell[2995, 117, 243, 8, 70, "Output",
 CellTags->"Series::vcnt",
 CellID->231457923]
}, Open  ]],
Cell[3253, 128, 112, 3, 70, "ExampleText",
 CellID->198047998],
Cell[CellGroupData[{
Cell[3390, 135, 242, 8, 70, "Input",
 CellTags->"Series::vcnt",
 CellID->43996842],
Cell[3635, 145, 1050, 32, 70, "Output",
 CellTags->"Series::vcnt",
 CellID->19028321]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4724, 182, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

