(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8193,        301]
NotebookOptionsPosition[      5298,        205]
NotebookOutlinePosition[      6960,        256]
CellTagsIndexPosition[      6843,        250]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["SeriesData::csa", "ObjectName",
 CellID->1522],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeriesData", "::", "\<\"csa\"\>"}], ":", 
  " ", "\<\"Argument `1` in `2` is not a power series.\"\>"}]], "Message", \
"MSG",
 CellID->155424696],

Cell[TextData[{
 "Generated when the indicated argument from ",
 Cell[BoxData[
  ButtonBox["ComposeSeries",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComposeSeries"]], "InlineFormula"],
 " is not a valid series expansion."
}], "Notes",
 CellID->4136],

Cell[TextData[{
 "A series expansion  is an expression with a head of ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->20847]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->17157632],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->898179873],

Cell["\<\
An error occurs in this example because the second argument is not a series \
expansion.\
\>", "ExampleText",
 CellID->62312065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"x", "^", "2"}]}], "]"}]], "Input",
 CellTags->"SeriesData::csa",
 CellLabel->"In[1]:=",
 CellID->13269],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeriesData", "::", "\<\"csa\"\>"}], ":", 
  " ", "\<\"Argument \\!\\(x\\^2\\) in \
\\!\\(ComposeSeries[\\(\\(\\*InterpretationBox[\\(1 - x\\^2\\/2 + \
\\*InterpretationBox[\\(\\(O[x]\\)\\^4\\), SeriesData[x, 0, List[], 0, 4, 1], \
Rule[Editable, False]]\\), SeriesData[x, 0, List[1, 0, Rational[-1, 2]], 0, \
4, 1], Rule[Editable, False]], x\\^2\\)\\)]\\) is not a power \
series.\"\>"}]], "Message", "MSG",
 CellTags->"SeriesData::csa",
 CellID->471073425],

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{
   InterpretationBox[
    RowBox[{"1", "-", 
     FractionBox[
      SuperscriptBox["x", "2"], "2"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "x", "]"}], "4"],
      SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 0, {1, 0, 
      Rational[-1, 2]}, 0, 4, 1],
    Editable->False], ",", 
   SuperscriptBox["x", "2"]}], "]"}]], "Output",
 CellTags->"SeriesData::csa",
 CellLabel->"Out[1]=",
 CellID->4936889]
}, Open  ]],

Cell[TextData[{
 "This shows valid arguments in ",
 Cell[BoxData[
  ButtonBox["ComposeSeries",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComposeSeries"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->280592574],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellTags->"SeriesData::csa",
 CellLabel->"In[2]:=",
 CellID->374505525],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    SuperscriptBox["x", "4"], "2"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 0, 0, 
    Rational[-1, 2]}, 0, 5, 1],
  Editable->False]], "Output",
 CellTags->"SeriesData::csa",
 CellLabel->"Out[2]=",
 CellID->573732936]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SeriesData::csa - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 34.6809320}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "SeriesData::csa", "synonyms" -> {}, "title" -> 
    "SeriesData::csa", "type" -> "Message", "uri" -> "ref/message/csa"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1967, 79, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->17157632]},
 "SeriesData::csa"->{
  Cell[2665, 108, 337, 11, 70, "Input",
   CellTags->"SeriesData::csa",
   CellID->13269],
  Cell[3005, 121, 492, 10, 70, "Message",
   CellTags->"SeriesData::csa",
   CellID->471073425],
  Cell[3500, 133, 552, 18, 70, "Output",
   CellTags->"SeriesData::csa",
   CellID->4936889],
  Cell[4315, 166, 465, 15, 70, "Input",
   CellTags->"SeriesData::csa",
   CellID->374505525],
  Cell[4783, 183, 449, 15, 70, "Output",
   CellTags->"SeriesData::csa",
   CellID->573732936]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6206, 227},
 {"SeriesData::csa", 6346, 231}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->1522],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 180, 5, 70, "Message",
 CellID->155424696],
Cell[1441, 56, 257, 8, 70, "Notes",
 CellID->4136],
Cell[1701, 66, 229, 8, 70, "Notes",
 CellID->20847]
}, Closed]],
Cell[CellGroupData[{
Cell[1967, 79, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->17157632],
Cell[CellGroupData[{
Cell[2351, 93, 148, 5, 70, "ExampleSection",
 CellID->898179873],
Cell[2502, 100, 138, 4, 70, "ExampleText",
 CellID->62312065],
Cell[CellGroupData[{
Cell[2665, 108, 337, 11, 70, "Input",
 CellTags->"SeriesData::csa",
 CellID->13269],
Cell[3005, 121, 492, 10, 70, "Message",
 CellTags->"SeriesData::csa",
 CellID->471073425],
Cell[3500, 133, 552, 18, 70, "Output",
 CellTags->"SeriesData::csa",
 CellID->4936889]
}, Open  ]],
Cell[4067, 154, 223, 8, 70, "ExampleText",
 CellID->280592574],
Cell[CellGroupData[{
Cell[4315, 166, 465, 15, 70, "Input",
 CellTags->"SeriesData::csa",
 CellID->374505525],
Cell[4783, 183, 449, 15, 70, "Output",
 CellTags->"SeriesData::csa",
 CellID->573732936]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5271, 203, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

