(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9144,        322]
NotebookOptionsPosition[      6102,        222]
NotebookOutlinePosition[      7871,        276]
CellTagsIndexPosition[      7753,        270]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["SeriesData::scmn", "ObjectName",
 CellID->17510],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeriesData", "::", "\<\"scmn\"\>"}], ":", 
  " ", "\<\"Order of series `1` is negative.\"\>"}]], "Message", "MSG",
 CellID->11471989],

Cell["\<\
Generated when the order of the inner series in series composition is \
negative.\
\>", "Notes",
 CellID->16102]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->322779359],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->455275174],

Cell["\<\
An error occurs in this example because the order of the leading term in the \
second series expansion is negative.\
\>", "ExampleText",
 CellID->54156530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"1", "/", "t"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "4"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellTags->"SeriesData::scmn",
 CellLabel->"In[1]:=",
 CellID->467435018],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeriesData", "::", "\<\"scmn\"\>"}], ":", 
  " ", "\<\"Order of series \\!\\(\\*InterpretationBox[\\(1\\/t + \
\\*InterpretationBox[\\(\\(O[t]\\)\\^5\\), SeriesData[t, 0, List[], -1, 5, \
1], Rule[Editable, False]]\\), SeriesData[t, 0, List[1], -1, 5, 1], \
Rule[Editable, False]]\\) is negative.\"\>"}]], "Message", "MSG",
 CellTags->"SeriesData::scmn",
 CellID->551080457],

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{
   InterpretationBox[
    RowBox[{"x", "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "x", "]"}], "2"],
      SeriesData[$CellContext`x, 0, {}, 1, 2, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 0, {1}, 1, 2, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     FractionBox["1", "t"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "t", "]"}], "5"],
      SeriesData[$CellContext`t, 0, {}, -1, 5, 1],
      Editable->False]}],
    SeriesData[$CellContext`t, 0, {1}, -1, 5, 1],
    Editable->False]}], "]"}]], "Output",
 CellTags->"SeriesData::scmn",
 CellLabel->"Out[1]=",
 CellID->65769065]
}, Open  ]],

Cell["\<\
A similar error will occur if a series expansion with negative order is \
substituted into another series expansion.\
\>", "ExampleText",
 CellID->4672353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{"x", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], "/.", 
  RowBox[{"x", "->", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"1", "/", "t"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "2"}], "}"}]}], "]"}]}]}]], "Input",
 CellTags->"SeriesData::scmn",
 CellLabel->"In[2]:=",
 CellID->414],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeriesData", "::", "\<\"scmn\"\>"}], ":", 
  " ", "\<\"Order of series \\!\\(\\*InterpretationBox[\\(1\\/t + \
\\*InterpretationBox[\\(\\(O[t]\\)\\^3\\), SeriesData[t, 0, List[], -1, 3, \
1], Rule[Editable, False]]\\), SeriesData[t, 0, List[1], -1, 3, 1], \
Rule[Editable, False]]\\) is negative.\"\>"}]], "Message", "MSG",
 CellTags->"SeriesData::scmn",
 CellID->487014962],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      FractionBox["1", "t"], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", "t", "]"}], "3"],
       SeriesData[$CellContext`t, 0, {}, -1, 3, 1],
       Editable->False]}],
     SeriesData[$CellContext`t, 0, {1}, -1, 3, 1],
     Editable->False], ")"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      InterpretationBox[
       RowBox[{
        FractionBox["1", "t"], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", "t", "]"}], "3"],
         SeriesData[$CellContext`t, 0, {}, -1, 3, 1],
         Editable->False]}],
       SeriesData[$CellContext`t, 0, {1}, -1, 3, 1],
       Editable->False], "]"}], "2"],
    SeriesData[
     SeriesData[$CellContext`t, 0, {1}, -1, 3, 1], 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[
   SeriesData[$CellContext`t, 0, {1}, -1, 3, 1], 0, {1}, 1, 2, 1],
  Editable->False]], "Output",
 CellTags->"SeriesData::scmn",
 CellLabel->"Out[2]=",
 CellID->247171565]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SeriesData::scmn - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 34.8528114}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "SeriesData::scmn", "synonyms" -> {}, "title" -> 
    "SeriesData::scmn", "type" -> "Message", "uri" -> "ref/message/scmn"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1590, 64, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->322779359]},
 "SeriesData::scmn"->{
  Cell[2316, 93, 433, 14, 70, "Input",
   CellTags->"SeriesData::scmn",
   CellID->467435018],
  Cell[2752, 109, 409, 8, 70, "Message",
   CellTags->"SeriesData::scmn",
   CellID->551080457],
  Cell[3164, 119, 743, 24, 70, "Output",
   CellTags->"SeriesData::scmn",
   CellID->65769065],
  Cell[4112, 154, 408, 14, 70, "Input",
   CellTags->"SeriesData::scmn",
   CellID->414],
  Cell[4523, 170, 409, 8, 70, "Message",
   CellTags->"SeriesData::scmn",
   CellID->487014962],
  Cell[4935, 180, 1101, 35, 70, "Output",
   CellTags->"SeriesData::scmn",
   CellID->247171565]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7014, 244},
 {"SeriesData::scmn", 7156, 248}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 54, 1, 70, "ObjectName",
 CellID->17510],
Cell[CellGroupData[{
Cell[782, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1260, 49, 168, 4, 70, "Message",
 CellID->11471989],
Cell[1431, 55, 122, 4, 70, "Notes",
 CellID->16102]
}, Closed]],
Cell[CellGroupData[{
Cell[1590, 64, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->322779359],
Cell[CellGroupData[{
Cell[1975, 78, 148, 5, 70, "ExampleSection",
 CellID->455275174],
Cell[2126, 85, 165, 4, 70, "ExampleText",
 CellID->54156530],
Cell[CellGroupData[{
Cell[2316, 93, 433, 14, 70, "Input",
 CellTags->"SeriesData::scmn",
 CellID->467435018],
Cell[2752, 109, 409, 8, 70, "Message",
 CellTags->"SeriesData::scmn",
 CellID->551080457],
Cell[3164, 119, 743, 24, 70, "Output",
 CellTags->"SeriesData::scmn",
 CellID->65769065]
}, Open  ]],
Cell[3922, 146, 165, 4, 70, "ExampleText",
 CellID->4672353],
Cell[CellGroupData[{
Cell[4112, 154, 408, 14, 70, "Input",
 CellTags->"SeriesData::scmn",
 CellID->414],
Cell[4523, 170, 409, 8, 70, "Message",
 CellTags->"SeriesData::scmn",
 CellID->487014962],
Cell[4935, 180, 1101, 35, 70, "Output",
 CellTags->"SeriesData::scmn",
 CellID->247171565]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6075, 220, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

