(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8549,        299]
NotebookOptionsPosition[      5699,        205]
NotebookOutlinePosition[      7368,        256]
CellTagsIndexPosition[      7250,        250]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["SeriesData::scmp", "ObjectName",
 CellID->31280],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeriesData", "::", "\<\"scmp\"\>"}], ":", 
  " ", "\<\"The constant term of series `1` does not match the expansion \
point of `2`.\"\>"}]], "Message", "MSG",
 CellID->941650686],

Cell["\<\
Generated in series composition when the constant term of the second series \
is not the same as the expansion point in the first series.\
\>", "Notes",
 CellID->7929]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->53333604],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->666109761],

Cell["\<\
An error occurs in this example because the constant term in the second \
series does not match the expansion point of the first series.\
\>", "ExampleText",
 CellID->365732622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"Series", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellTags->"SeriesData::scmp",
 CellLabel->"In[1]:=",
 CellID->9735],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeriesData", "::", "\<\"scmp\"\>"}], ":", 
  " ", "\<\"The constant term of series \
\\!\\(\\*InterpretationBox[\\(\\(\\((x - 1)\\)\\) + \
\\*InterpretationBox[\\(\\(O[\\(\\(x - 1\\)\\)]\\)\\^3\\), SeriesData[x, 1, \
List[], 1, 3, 1], Rule[Editable, False]]\\), SeriesData[x, 1, List[1], 1, 3, \
1], Rule[Editable, False]]\\) does not match the expansion point of \
\\!\\(\\*InterpretationBox[\\(1 - x\\^2\\/2 + \\*InterpretationBox[\\(\\(O[x]\
\\)\\^4\\), SeriesData[x, 0, List[], 0, 4, 1], Rule[Editable, False]]\\), \
SeriesData[x, 0, List[1, 0, Rational[-1, 2]], 0, 4, 1], Rule[Editable, \
False]]\\).\"\>"}]], "Message", "MSG",
 CellTags->"SeriesData::scmp",
 CellID->431681765],

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{
   InterpretationBox[
    RowBox[{"1", "-", 
     FractionBox[
      SuperscriptBox["x", "2"], "2"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "x", "]"}], "4"],
      SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 0, {1, 0, 
      Rational[-1, 2]}, 0, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{"1", "+", 
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        RowBox[{"x", "-", "1"}], "]"}], "3"],
      SeriesData[$CellContext`x, 1, {}, 0, 3, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 1, {1, 1}, 0, 3, 1],
    Editable->False]}], "]"}]], "Output",
 CellTags->"SeriesData::scmp",
 CellLabel->"Out[1]=",
 CellID->140055761]
}, Open  ]],

Cell["This shows a valid series composition.", "ExampleText",
 CellID->295721200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"x", "-", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellTags->"SeriesData::scmp",
 CellLabel->"In[2]:=",
 CellID->17738],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "1"}], "]"}], "4"],
    SeriesData[$CellContext`x, 1, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 1, {1, 0, 
    Rational[-1, 2]}, 0, 4, 1],
  Editable->False]], "Output",
 CellTags->"SeriesData::scmp",
 CellLabel->"Out[2]=",
 CellID->157848901]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SeriesData::scmp - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 35.0246908}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "SeriesData::scmp", "synonyms" -> {}, "title" -> 
    "SeriesData::scmp", "type" -> "Message", "uri" -> "ref/message/scmp"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1690, 65, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->53333604]},
 "SeriesData::scmp"->{
  Cell[2437, 94, 435, 14, 70, "Input",
   CellTags->"SeriesData::scmp",
   CellID->9735],
  Cell[2875, 110, 718, 13, 70, "Message",
   CellTags->"SeriesData::scmp",
   CellID->431681765],
  Cell[3596, 125, 902, 29, 70, "Output",
   CellTags->"SeriesData::scmp",
   CellID->140055761],
  Cell[4619, 162, 462, 15, 70, "Input",
   CellTags->"SeriesData::scmp",
   CellID->17738],
  Cell[5084, 179, 549, 19, 70, "Output",
   CellTags->"SeriesData::scmp",
   CellID->157848901]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6611, 227},
 {"SeriesData::scmp", 6752, 231}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 54, 1, 70, "ObjectName",
 CellID->31280],
Cell[CellGroupData[{
Cell[782, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1260, 49, 213, 5, 70, "Message",
 CellID->941650686],
Cell[1476, 56, 177, 4, 70, "Notes",
 CellID->7929]
}, Closed]],
Cell[CellGroupData[{
Cell[1690, 65, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->53333604],
Cell[CellGroupData[{
Cell[2074, 79, 148, 5, 70, "ExampleSection",
 CellID->666109761],
Cell[2225, 86, 187, 4, 70, "ExampleText",
 CellID->365732622],
Cell[CellGroupData[{
Cell[2437, 94, 435, 14, 70, "Input",
 CellTags->"SeriesData::scmp",
 CellID->9735],
Cell[2875, 110, 718, 13, 70, "Message",
 CellTags->"SeriesData::scmp",
 CellID->431681765],
Cell[3596, 125, 902, 29, 70, "Output",
 CellTags->"SeriesData::scmp",
 CellID->140055761]
}, Open  ]],
Cell[4513, 157, 81, 1, 70, "ExampleText",
 CellID->295721200],
Cell[CellGroupData[{
Cell[4619, 162, 462, 15, 70, "Input",
 CellTags->"SeriesData::scmp",
 CellID->17738],
Cell[5084, 179, 549, 19, 70, "Output",
 CellTags->"SeriesData::scmp",
 CellID->157848901]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5672, 203, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

