(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7950,        295]
NotebookOptionsPosition[      4983,        197]
NotebookOutlinePosition[      6659,        248]
CellTagsIndexPosition[      6540,        242]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["SeriesData::sdatc", "ObjectName",
 CellID->9735],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeriesData", "::", "\<\"sdatc\"\>"}], ":", 
  " ", "\<\"Coefficient specification `1` in `2` is not a list.\"\>"}]], \
"Message", "MSG",
 CellID->328049962],

Cell[TextData[{
 "Generated when the third argument in ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " is not a list."
}], "Notes",
 CellID->24040],

Cell[TextData[{
 "This message is normally seen only  when ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " expressions are constructed directly, rather than constructed  \
automatically by ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15437],

Cell[TextData[{
 "This third argument in ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " is expected to be a list of coefficients."
}], "Notes",
 CellID->17927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->85060815],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->10862590],

Cell[TextData[{
 "An error occurs in this example because the third argument in ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " is a number rather than a list."
}], "ExampleText",
 CellID->197133655],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SeriesData", "[", 
  RowBox[{"x", ",", "b", ",", "3", ",", "7", ",", "12", ",", "1"}], 
  "]"}]], "Input",
 CellTags->"SeriesData::sdatc",
 CellLabel->"In[1]:=",
 CellID->17807],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeriesData", "::", "\<\"sdatc\"\>"}], ":", 
  " ", "\<\"Coefficient specification \\!\\(3\\) in \\!\\(SeriesData[\\(\\(x, \
b, 3, 7, 12, 1\\)\\)]\\) is not a list.\"\>"}]], "Message", "MSG",
 CellTags->"SeriesData::sdatc",
 CellID->127048151],

Cell[BoxData[
 RowBox[{"SeriesData", "[", 
  RowBox[{"x", ",", "b", ",", "3", ",", "7", ",", "12", ",", "1"}], 
  "]"}]], "Output",
 CellTags->"SeriesData::sdatc",
 CellLabel->"Out[1]=",
 CellID->216148403]
}, Open  ]],

Cell[TextData[{
 "This shows a valid ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " expression."
}], "ExampleText",
 CellID->524585253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SeriesData", "[", 
  RowBox[{"x", ",", "b", ",", 
   RowBox[{"{", "3", "}"}], ",", "7", ",", "12", ",", "1"}], "]"}]], "Input",
 CellTags->"SeriesData::sdatc",
 CellLabel->"In[2]:=",
 CellID->7384],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"3", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "b"}], ")"}], "7"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "b"}], "]"}], "12"],
    SeriesData[$CellContext`x, $CellContext`b, {}, 7, 12, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, $CellContext`b, {3}, 7, 12, 1],
  Editable->False]], "Output",
 CellTags->"SeriesData::sdatc",
 CellLabel->"Out[2]=",
 CellID->88778399]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SeriesData::sdatc - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 35.1809448}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "SeriesData::sdatc", "synonyms" -> {}, "title" -> 
    "SeriesData::sdatc", "type" -> "Message", "uri" -> "ref/message/sdatc"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2387, 95, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->85060815]},
 "SeriesData::sdatc"->{
  Cell[3226, 128, 201, 6, 70, "Input",
   CellTags->"SeriesData::sdatc",
   CellID->17807],
  Cell[3430, 136, 277, 6, 70, "Message",
   CellTags->"SeriesData::sdatc",
   CellID->127048151],
  Cell[3710, 144, 206, 6, 70, "Output",
   CellTags->"SeriesData::sdatc",
   CellID->216148403],
  Cell[4173, 165, 221, 6, 70, "Input",
   CellTags->"SeriesData::sdatc",
   CellID->7384],
  Cell[4397, 173, 520, 17, 70, "Output",
   CellTags->"SeriesData::sdatc",
   CellID->88778399]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5899, 219},
 {"SeriesData::sdatc", 6041, 223}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 54, 1, 70, "ObjectName",
 CellID->9735],
Cell[CellGroupData[{
Cell[782, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1260, 49, 191, 5, 70, "Message",
 CellID->328049962],
Cell[1454, 56, 228, 8, 70, "Notes",
 CellID->24040],
Cell[1685, 66, 421, 14, 70, "Notes",
 CellID->15437],
Cell[2109, 82, 241, 8, 70, "Notes",
 CellID->17927]
}, Closed]],
Cell[CellGroupData[{
Cell[2387, 95, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->85060815],
Cell[CellGroupData[{
Cell[2771, 109, 147, 5, 70, "ExampleSection",
 CellID->10862590],
Cell[2921, 116, 280, 8, 70, "ExampleText",
 CellID->197133655],
Cell[CellGroupData[{
Cell[3226, 128, 201, 6, 70, "Input",
 CellTags->"SeriesData::sdatc",
 CellID->17807],
Cell[3430, 136, 277, 6, 70, "Message",
 CellTags->"SeriesData::sdatc",
 CellID->127048151],
Cell[3710, 144, 206, 6, 70, "Output",
 CellTags->"SeriesData::sdatc",
 CellID->216148403]
}, Open  ]],
Cell[3931, 153, 217, 8, 70, "ExampleText",
 CellID->524585253],
Cell[CellGroupData[{
Cell[4173, 165, 221, 6, 70, "Input",
 CellTags->"SeriesData::sdatc",
 CellID->7384],
Cell[4397, 173, 520, 17, 70, "Output",
 CellTags->"SeriesData::sdatc",
 CellID->88778399]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4956, 195, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

