(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8063,        295]
NotebookOptionsPosition[      5146,        199]
NotebookOutlinePosition[      6823,        250]
CellTagsIndexPosition[      6704,        244]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["SeriesData::sdatd", "ObjectName",
 CellID->32414],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeriesData", "::", "\<\"sdatd\"\>"}], ":", 
  " ", "\<\"Power denominator specification `1` in `2` is not a positive \
machine-size integer.\"\>"}]], "Message", "MSG",
 CellID->156191192],

Cell[TextData[{
 "Generated when the sixth argument in ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " is not a positive integer or is too large to be represented as a machine  \
integer on your computer."
}], "Notes",
 CellID->29555],

Cell[TextData[{
 "This message is normally seen  only if a ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " expression is constructed directly, rather than constructed internally by  \
",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1516]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20747702],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->328570916],

Cell[TextData[{
 "An error occurs in this example because a list is not a valid value for the \
 sixth argument in ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->327026168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SeriesData", "[", 
  RowBox[{"x", ",", "0", ",", 
   RowBox[{"{", "3", "}"}], ",", "17", ",", "17", ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Input",
 CellTags->"SeriesData::sdatd",
 CellLabel->"In[1]:=",
 CellID->27553],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeriesData", "::", "\<\"sdatd\"\>"}], ":", 
  " ", "\<\"Power denominator specification \\!\\({}\\) in \
\\!\\(SeriesData[\\(\\(x, 0, \\(\\({3}\\)\\), 17, 17, \
\\(\\({}\\)\\)\\)\\)]\\) is not a positive machine-size integer.\"\>"}]], \
"Message", "MSG",
 CellTags->"SeriesData::sdatd",
 CellID->162028288],

Cell[BoxData[
 RowBox[{"SeriesData", "[", 
  RowBox[{"x", ",", "0", ",", 
   RowBox[{"{", "3", "}"}], ",", "17", ",", "17", ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 CellTags->"SeriesData::sdatd",
 CellLabel->"Out[1]=",
 CellID->28880060]
}, Open  ]],

Cell[TextData[{
 "This shows valid arguments in ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->703328033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SeriesData", "[", 
  RowBox[{"x", ",", "0", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "7", ",", "5"}], "}"}], ",", "17", ",", "23", ",", 
   "2"}], "]"}]], "Input",
 CellTags->"SeriesData::sdatd",
 CellLabel->"In[2]:=",
 CellID->22414],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"3", " ", 
    SuperscriptBox["x", 
     RowBox[{"17", "/", "2"}]]}], "+", 
   RowBox[{"7", " ", 
    SuperscriptBox["x", "9"]}], "+", 
   RowBox[{"5", " ", 
    SuperscriptBox["x", 
     RowBox[{"19", "/", "2"}]]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], 
     RowBox[{"23", "/", "2"}]],
    SeriesData[$CellContext`x, 0, {}, 17, 23, 2],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {3, 7, 5}, 17, 23, 2],
  Editable->False]], "Output",
 CellTags->"SeriesData::sdatd",
 CellLabel->"Out[2]=",
 CellID->219180085]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SeriesData::sdatd - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 35.3528242}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "SeriesData::sdatd", "synonyms" -> {}, "title" -> 
    "SeriesData::sdatd", "type" -> "Message", "uri" -> "ref/message/sdatd"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2256, 86, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->20747702]},
 "SeriesData::sdatd"->{
  Cell[3100, 120, 242, 7, 70, "Input",
   CellTags->"SeriesData::sdatd",
   CellID->27553],
  Cell[3345, 129, 341, 8, 70, "Message",
   CellTags->"SeriesData::sdatd",
   CellID->162028288],
  Cell[3689, 139, 246, 7, 70, "Output",
   CellTags->"SeriesData::sdatd",
   CellID->28880060],
  Cell[4192, 161, 262, 8, 70, "Input",
   CellTags->"SeriesData::sdatd",
   CellID->22414],
  Cell[4457, 171, 623, 21, 70, "Output",
   CellTags->"SeriesData::sdatd",
   CellID->219180085]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6062, 221},
 {"SeriesData::sdatd", 6204, 225}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 55, 1, 70, "ObjectName",
 CellID->32414],
Cell[CellGroupData[{
Cell[783, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1261, 49, 222, 5, 70, "Message",
 CellID->156191192],
Cell[1486, 56, 315, 9, 70, "Notes",
 CellID->29555],
Cell[1804, 67, 415, 14, 70, "Notes",
 CellID->1516]
}, Closed]],
Cell[CellGroupData[{
Cell[2256, 86, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20747702],
Cell[CellGroupData[{
Cell[2640, 100, 148, 5, 70, "ExampleSection",
 CellID->328570916],
Cell[2791, 107, 284, 9, 70, "ExampleText",
 CellID->327026168],
Cell[CellGroupData[{
Cell[3100, 120, 242, 7, 70, "Input",
 CellTags->"SeriesData::sdatd",
 CellID->27553],
Cell[3345, 129, 341, 8, 70, "Message",
 CellTags->"SeriesData::sdatd",
 CellID->162028288],
Cell[3689, 139, 246, 7, 70, "Output",
 CellTags->"SeriesData::sdatd",
 CellID->28880060]
}, Open  ]],
Cell[3950, 149, 217, 8, 70, "ExampleText",
 CellID->703328033],
Cell[CellGroupData[{
Cell[4192, 161, 262, 8, 70, "Input",
 CellTags->"SeriesData::sdatd",
 CellID->22414],
Cell[4457, 171, 623, 21, 70, "Output",
 CellTags->"SeriesData::sdatd",
 CellID->219180085]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5119, 197, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

