(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10557,        362]
NotebookOptionsPosition[      6286,        227]
NotebookOutlinePosition[      8661,        297]
CellTagsIndexPosition[      8534,        291]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["SetStreamPosition::stmrng", "ObjectName",
 CellID->23148],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetStreamPosition", "::", "\<\"stmrng\"\>"}], ":", 
  " ", "\<\"Cannot set the current point in stream `2` to position `1`. The \
requested position exceeds the number of characters in the file.\"\>"}]], \
"Message", "MSG",
 CellID->973803534],

Cell[TextData[{
 "Generated when the value of the second argument in ",
 Cell[BoxData[
  ButtonBox["SetStreamPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetStreamPosition"]], "InlineFormula"],
 " corresponds to a position that is outside of the stream specified in the  \
first argument."
}], "Notes",
 CellID->20555]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->176552693],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->774285463],

Cell[TextData[{
 "An error occurs in this example because the position specified in ",
 Cell[BoxData[
  ButtonBox["SetStreamPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetStreamPosition"]], "InlineFormula"],
 " exceeds the number of characters in the test file."
}], "ExampleText",
 CellID->175933732],

Cell[BoxData[
 RowBox[{"Write", "[", 
  RowBox[{"\"\<TESTFILE\>\"", ",", 
   RowBox[{"OutputForm", "[", "\"\<ABCDEFGHOJKLMNOP\>\"", "]"}]}], 
  "]"}]], "Input",
 CellTags->"SetStreamPosition::stmrng",
 CellLabel->"In[1]:=",
 CellID->28919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "\"\<TESTFILE\>\"", "]"}]], "Input",
 CellTags->"SetStreamPosition::stmrng",
 CellLabel->"In[2]:=",
 CellID->29132],

Cell[BoxData["\<\"TESTFILE\"\>"], "Output",
 CellTags->"SetStreamPosition::stmrng",
 CellLabel->"Out[2]=",
 CellID->112483806]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"s", "=", 
     RowBox[{"OpenRead", "[", "\"\<TESTFILE\>\"", "]"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetStreamPosition", "[", 
     RowBox[{"s", ",", "100"}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<char 101 = \>\"", ",", 
      RowBox[{"Read", "[", 
       RowBox[{"s", ",", "Character"}], "]"}]}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Close", "[", "s", "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellTags->"SetStreamPosition::stmrng",
 CellLabel->"In[3]:=",
 CellID->10547],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetStreamPosition", "::", "\<\"stmrng\"\>"}], ":", 
  " ", "\<\"Cannot set the current point in stream \\!\\(InputStream[\\(\\(\\\
\"TESTFILE\\\", 380\\)\\)]\\) to position \\!\\(100\\). The requested \
position exceeds the number of characters in the file.\"\>"}]], "Message", \
"MSG",
 CellTags->"SetStreamPosition::stmrng",
 CellID->1073826],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"char 101 = \"\>", "\[InvisibleSpace]", "\<\"A\"\>"}],
  SequenceForm["char 101 = ", "A"],
  Editable->False]], "Print",
 CellTags->"SetStreamPosition::stmrng",
 CellLabel->"During evaluation of In[3]:=",
 CellID->117258411],

Cell[BoxData["\<\"TESTFILE\"\>"], "Output",
 CellTags->"SetStreamPosition::stmrng",
 CellLabel->"Out[3]=",
 CellID->133249757]
}, Open  ]],

Cell["This shows a valid position specification for this file.", "ExampleText",
 CellID->100168657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"s", "=", 
     RowBox[{"OpenRead", "[", "\"\<TESTFILE\>\"", "]"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetStreamPosition", "[", 
     RowBox[{"s", ",", "10"}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<char 11 = \>\"", ",", 
      RowBox[{"Read", "[", 
       RowBox[{"s", ",", "Character"}], "]"}]}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Close", "[", "s", "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellTags->"SetStreamPosition::stmrng",
 CellLabel->"In[4]:=",
 CellID->10941],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"char 11 = \"\>", "\[InvisibleSpace]", "\<\"K\"\>"}],
  SequenceForm["char 11 = ", "K"],
  Editable->False]], "Print",
 CellTags->"SetStreamPosition::stmrng",
 CellLabel->"During evaluation of In[4]:=",
 CellID->1016212829],

Cell[BoxData["\<\"TESTFILE\"\>"], "Output",
 CellTags->"SetStreamPosition::stmrng",
 CellLabel->"Out[4]=",
 CellID->23127703]
}, Open  ]],

Cell["Delete the test file.", "ExampleText",
 CellID->523987975],

Cell[BoxData[
 RowBox[{"DeleteFile", "[", "\"\<TESTFILE\>\"", "]"}]], "Input",
 CellTags->"SetStreamPosition::stmrng",
 CellLabel->"In[5]:=",
 CellID->796]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetStreamPosition::stmrng - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 59.3378132}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "SetStreamPosition::stmrng", "synonyms" -> {}, "title" -> 
    "SetStreamPosition::stmrng", "type" -> "Message", "uri" -> 
    "ref/message/stmrng"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1920, 71, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->176552693]},
 "SetStreamPosition::stmrng"->{
  Cell[2776, 102, 239, 7, 70, "Input",
   CellTags->"SetStreamPosition::stmrng",
   CellID->28919],
  Cell[3040, 113, 152, 4, 70, "Input",
   CellTags->"SetStreamPosition::stmrng",
   CellID->29132],
  Cell[3195, 119, 126, 3, 70, "Output",
   CellTags->"SetStreamPosition::stmrng",
   CellID->112483806],
  Cell[3358, 127, 656, 19, 70, "Input",
   CellTags->"SetStreamPosition::stmrng",
   CellID->10547],
  Cell[4017, 148, 379, 8, 70, "Message",
   CellTags->"SetStreamPosition::stmrng",
   CellID->1073826],
  Cell[4399, 158, 272, 7, 70, "Print",
   CellTags->"SetStreamPosition::stmrng",
   CellID->117258411],
  Cell[4674, 167, 126, 3, 70, "Output",
   CellTags->"SetStreamPosition::stmrng",
   CellID->133249757],
  Cell[4939, 178, 654, 19, 70, "Input",
   CellTags->"SetStreamPosition::stmrng",
   CellID->10941],
  Cell[5596, 199, 271, 7, 70, "Print",
   CellTags->"SetStreamPosition::stmrng",
   CellID->1016212829],
  Cell[5870, 208, 125, 3, 70, "Output",
   CellTags->"SetStreamPosition::stmrng",
   CellID->23127703],
  Cell[6077, 217, 155, 4, 70, "Input",
   CellTags->"SetStreamPosition::stmrng",
   CellID->796]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7232, 250},
 {"SetStreamPosition::stmrng", 7383, 254}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 63, 1, 70, "ObjectName",
 CellID->23148],
Cell[CellGroupData[{
Cell[791, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1269, 49, 278, 6, 70, "Message",
 CellID->973803534],
Cell[1550, 57, 333, 9, 70, "Notes",
 CellID->20555]
}, Closed]],
Cell[CellGroupData[{
Cell[1920, 71, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->176552693],
Cell[CellGroupData[{
Cell[2305, 85, 148, 5, 70, "ExampleSection",
 CellID->774285463],
Cell[2456, 92, 317, 8, 70, "ExampleText",
 CellID->175933732],
Cell[2776, 102, 239, 7, 70, "Input",
 CellTags->"SetStreamPosition::stmrng",
 CellID->28919],
Cell[CellGroupData[{
Cell[3040, 113, 152, 4, 70, "Input",
 CellTags->"SetStreamPosition::stmrng",
 CellID->29132],
Cell[3195, 119, 126, 3, 70, "Output",
 CellTags->"SetStreamPosition::stmrng",
 CellID->112483806]
}, Open  ]],
Cell[CellGroupData[{
Cell[3358, 127, 656, 19, 70, "Input",
 CellTags->"SetStreamPosition::stmrng",
 CellID->10547],
Cell[4017, 148, 379, 8, 70, "Message",
 CellTags->"SetStreamPosition::stmrng",
 CellID->1073826],
Cell[4399, 158, 272, 7, 70, "Print",
 CellTags->"SetStreamPosition::stmrng",
 CellID->117258411],
Cell[4674, 167, 126, 3, 70, "Output",
 CellTags->"SetStreamPosition::stmrng",
 CellID->133249757]
}, Open  ]],
Cell[4815, 173, 99, 1, 70, "ExampleText",
 CellID->100168657],
Cell[CellGroupData[{
Cell[4939, 178, 654, 19, 70, "Input",
 CellTags->"SetStreamPosition::stmrng",
 CellID->10941],
Cell[5596, 199, 271, 7, 70, "Print",
 CellTags->"SetStreamPosition::stmrng",
 CellID->1016212829],
Cell[5870, 208, 125, 3, 70, "Output",
 CellTags->"SetStreamPosition::stmrng",
 CellID->23127703]
}, Open  ]],
Cell[6010, 214, 64, 1, 70, "ExampleText",
 CellID->523987975],
Cell[6077, 217, 155, 4, 70, "Input",
 CellTags->"SetStreamPosition::stmrng",
 CellID->796]
}, Open  ]]
}, Open  ]],
Cell[6259, 225, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

