(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25267,        664]
NotebookOptionsPosition[      5498,        196]
NotebookOutlinePosition[     23005,        604]
CellTagsIndexPosition[     22562,        589]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
Solve::tdep
MainSolve::tdep
Roots::tdep
Reduce::tdep
System`Private`OldReduce::tdep
Eliminate::tdep
SolveAlways::tdep
AlgebraicRules::tdep
GroebnerBasis::tdep
PolynomialReduce::tdep\
\>", "ObjectName",
 CellID->13326],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"The equations appear to involve the variables to be solved for in \
an essentially non-algebraic way.\"\>"}]], "Message", "MSG",
 CellID->329462308],

Cell["\<\
This message is generated when the indicated function  encounters a \
transcendental equation.\
\>", "Notes",
 CellID->19347],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " and related functions are primarily designed for solving polynomial  \
equations and equations that can be readily translated into polynomial  \
equations."
}], "Notes",
 CellID->13776]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->56268834],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->358331933],

Cell["\<\
This transcendental equation cannot be solved by algebraic methods.\
\>", "ExampleText",
 CellID->24892885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "==", 
    RowBox[{"Log", "[", "x", "]"}]}], ",", "x"}], "]"}]], "Input",
 CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
   "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
   "AlgebraicRules::tdep", "GroebnerBasis::tdep", "PolynomialReduce::tdep"},
 CellLabel->"In[1]:=",
 CellID->27245],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"The equations appear to involve the variables to be solved for in \
an essentially non-algebraic way.\"\>"}]], "Message", "MSG",
 CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
   "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
   "AlgebraicRules::tdep", "GroebnerBasis::tdep", "PolynomialReduce::tdep"},
 CellID->704720203],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", 
    RowBox[{"Log", "[", "x", "]"}]}], ",", "x"}], "]"}]], "Output",
 CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
   "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
   "AlgebraicRules::tdep", "GroebnerBasis::tdep", "PolynomialReduce::tdep"},
 CellLabel->"Out[1]=",
 CellID->131437249]
}, Open  ]],

Cell[TextData[{
 "In this example you can use ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " to get a numerical approximation for the solution."
}], "ExampleText",
 CellID->5019206],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", "==", " ", 
    RowBox[{"Log", "[", "x", "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
   "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
   "AlgebraicRules::tdep", "GroebnerBasis::tdep", "PolynomialReduce::tdep"},
 CellLabel->"In[2]:=",
 CellID->24960],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "2.2191071489137495`"}], "}"}]], "Output",
 CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
   "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
   "AlgebraicRules::tdep", "GroebnerBasis::tdep", "PolynomialReduce::tdep"},
 CellLabel->"Out[2]=",
 CellID->440629280]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Solve::tdep - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 19, 23.6978118}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Solve::tdep MainSolve::tdep Roots::tdep Reduce::tdep \
System`Private`OldReduce::tdep Eliminate::tdep SolveAlways::tdep \
AlgebraicRules::tdep GroebnerBasis::tdep PolynomialReduce::tdep", 
    "synonyms" -> {}, "title" -> "Solve::tdep", "type" -> "Message", "uri" -> 
    "ref/message/tdep"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2184, 88, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->56268834]},
 "Solve::tdep"->{
  Cell[2861, 116, 445, 11, 70, "Input",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->27245],
  Cell[3309, 129, 469, 9, 70, "Message",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->704720203],
  Cell[3781, 140, 456, 11, 70, "Output",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->131437249],
  Cell[4536, 166, 517, 13, 70, "Input",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->24960],
  Cell[5056, 181, 376, 8, 70, "Output",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->440629280]},
 "MainSolve::tdep"->{
  Cell[2861, 116, 445, 11, 70, "Input",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->27245],
  Cell[3309, 129, 469, 9, 70, "Message",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->704720203],
  Cell[3781, 140, 456, 11, 70, "Output",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->131437249],
  Cell[4536, 166, 517, 13, 70, "Input",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->24960],
  Cell[5056, 181, 376, 8, 70, "Output",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->440629280]},
 "Roots::tdep"->{
  Cell[2861, 116, 445, 11, 70, "Input",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->27245],
  Cell[3309, 129, 469, 9, 70, "Message",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->704720203],
  Cell[3781, 140, 456, 11, 70, "Output",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->131437249],
  Cell[4536, 166, 517, 13, 70, "Input",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->24960],
  Cell[5056, 181, 376, 8, 70, "Output",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->440629280]},
 "Reduce::tdep"->{
  Cell[2861, 116, 445, 11, 70, "Input",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->27245],
  Cell[3309, 129, 469, 9, 70, "Message",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->704720203],
  Cell[3781, 140, 456, 11, 70, "Output",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->131437249],
  Cell[4536, 166, 517, 13, 70, "Input",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->24960],
  Cell[5056, 181, 376, 8, 70, "Output",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->440629280]},
 "System`Private`OldReduce::tdep"->{
  Cell[2861, 116, 445, 11, 70, "Input",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->27245],
  Cell[3309, 129, 469, 9, 70, "Message",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->704720203],
  Cell[3781, 140, 456, 11, 70, "Output",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->131437249],
  Cell[4536, 166, 517, 13, 70, "Input",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->24960],
  Cell[5056, 181, 376, 8, 70, "Output",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->440629280]},
 "Eliminate::tdep"->{
  Cell[2861, 116, 445, 11, 70, "Input",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->27245],
  Cell[3309, 129, 469, 9, 70, "Message",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->704720203],
  Cell[3781, 140, 456, 11, 70, "Output",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->131437249],
  Cell[4536, 166, 517, 13, 70, "Input",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->24960],
  Cell[5056, 181, 376, 8, 70, "Output",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->440629280]},
 "SolveAlways::tdep"->{
  Cell[2861, 116, 445, 11, 70, "Input",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->27245],
  Cell[3309, 129, 469, 9, 70, "Message",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->704720203],
  Cell[3781, 140, 456, 11, 70, "Output",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->131437249],
  Cell[4536, 166, 517, 13, 70, "Input",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->24960],
  Cell[5056, 181, 376, 8, 70, "Output",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->440629280]},
 "AlgebraicRules::tdep"->{
  Cell[2861, 116, 445, 11, 70, "Input",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->27245],
  Cell[3309, 129, 469, 9, 70, "Message",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->704720203],
  Cell[3781, 140, 456, 11, 70, "Output",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->131437249],
  Cell[4536, 166, 517, 13, 70, "Input",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->24960],
  Cell[5056, 181, 376, 8, 70, "Output",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->440629280]},
 "GroebnerBasis::tdep"->{
  Cell[2861, 116, 445, 11, 70, "Input",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->27245],
  Cell[3309, 129, 469, 9, 70, "Message",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->704720203],
  Cell[3781, 140, 456, 11, 70, "Output",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->131437249],
  Cell[4536, 166, 517, 13, 70, "Input",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->24960],
  Cell[5056, 181, 376, 8, 70, "Output",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->440629280]},
 "PolynomialReduce::tdep"->{
  Cell[2861, 116, 445, 11, 70, "Input",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->27245],
  Cell[3309, 129, 469, 9, 70, "Message",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->704720203],
  Cell[3781, 140, 456, 11, 70, "Output",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->131437249],
  Cell[4536, 166, 517, 13, 70, "Input",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->24960],
  Cell[5056, 181, 376, 8, 70, "Output",
   CellTags->{
    "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
     "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep",
      "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
     "PolynomialReduce::tdep"},
   CellID->440629280]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6579, 222},
 {"Solve::tdep", 6715, 226},
 {"MainSolve::tdep", 8297, 262},
 {"Roots::tdep", 9875, 298},
 {"Reduce::tdep", 11454, 334},
 {"System`Private`OldReduce::tdep", 13051, 370},
 {"Eliminate::tdep", 14633, 406},
 {"SolveAlways::tdep", 16217, 442},
 {"AlgebraicRules::tdep", 17804, 478},
 {"GroebnerBasis::tdep", 19390, 514},
 {"PolynomialReduce::tdep", 20979, 550}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 227, 12, 70, "ObjectName",
 CellID->13326],
Cell[CellGroupData[{
Cell[955, 43, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1433, 60, 256, 6, 70, "Message",
 CellID->329462308],
Cell[1692, 68, 135, 4, 70, "Notes",
 CellID->19347],
Cell[1830, 74, 317, 9, 70, "Notes",
 CellID->13776]
}, Closed]],
Cell[CellGroupData[{
Cell[2184, 88, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->56268834],
Cell[CellGroupData[{
Cell[2568, 102, 148, 5, 70, "ExampleSection",
 CellID->358331933],
Cell[2719, 109, 117, 3, 70, "ExampleText",
 CellID->24892885],
Cell[CellGroupData[{
Cell[2861, 116, 445, 11, 70, "Input",
 CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
   "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
   "AlgebraicRules::tdep", "GroebnerBasis::tdep", "PolynomialReduce::tdep"},
 CellID->27245],
Cell[3309, 129, 469, 9, 70, "Message",
 CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
   "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
   "AlgebraicRules::tdep", "GroebnerBasis::tdep", "PolynomialReduce::tdep"},
 CellID->704720203],
Cell[3781, 140, 456, 11, 70, "Output",
 CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
   "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
   "AlgebraicRules::tdep", "GroebnerBasis::tdep", "PolynomialReduce::tdep"},
 CellID->131437249]
}, Open  ]],
Cell[4252, 154, 259, 8, 70, "ExampleText",
 CellID->5019206],
Cell[CellGroupData[{
Cell[4536, 166, 517, 13, 70, "Input",
 CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
   "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
   "AlgebraicRules::tdep", "GroebnerBasis::tdep", "PolynomialReduce::tdep"},
 CellID->24960],
Cell[5056, 181, 376, 8, 70, "Output",
 CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
   "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
   "AlgebraicRules::tdep", "GroebnerBasis::tdep", "PolynomialReduce::tdep"},
 CellID->440629280]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5471, 194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

