(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6634,        251]
NotebookOptionsPosition[      3798,        155]
NotebookOutlinePosition[      5426,        206]
CellTagsIndexPosition[      5312,        200]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Sum::sumwarn", "ObjectName",
 CellID->2821],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sum", "::", "\<\"sumwarn\"\>"}], ":", 
  " ", "\<\"Warning: `1` contains a capital sigma; use \[EscapeKey]sum\
\[EscapeKey] to enter a summation sign.\"\>"}]], "Message", "MSG",
 CellID->380581775],

Cell["\<\
Generated when a capital sigma character \[CapitalSigma] is used in a \
position where a summation sign \[Sum] is expected.\
\>", "Notes",
 CellID->5551],

Cell["\<\
This is a warning message about unexpected typeset input and does not \
necessarily indicate an error.\
\>", "Notes",
 CellID->13305]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->53603880],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->555136977],

Cell["\<\
A warning message is generated in this example because of the unexpected use \
of the capital sigma character.\
\>", "ExampleText",
 CellID->508602956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   UnderoverscriptBox["\[CapitalSigma]", 
    RowBox[{"k", "=", "1"}], "5"],
   ScriptLevel->0], 
  StyleBox[" ",
   ScriptLevel->0], "k"}]], "Input",
 CellTags->"Sum::sumwarn",
 CellLabel->"In[1]:=",
 CellID->13719],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sum", "::", "\<\"sumwarn\"\>"}], ":", 
  " ", "\<\"Warning: \\!\\(\[CapitalSigma]\\+\\(k = 1\\)\\%5\\) contains a \
capital sigma; use \[EscapeKey]sum\[EscapeKey] to enter a summation \
sign.\"\>"}]], "Message", "MSG",
 CellTags->"Sum::sumwarn",
 CellID->400250162],

Cell[BoxData[
 UnderoverscriptBox["\[CapitalSigma]", "1", "5"]], "Output",
 CellTags->"Sum::sumwarn",
 CellLabel->"Out[1]=",
 CellID->571888872]
}, Open  ]],

Cell["This shows the expected typeset input for a sum.", "ExampleText",
 CellID->60756867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"k", "=", "1"}], "5"],
   ScriptLevel->0], 
  StyleBox[" ",
   ScriptLevel->0], "k"}]], "Input",
 CellTags->"Sum::sumwarn",
 CellLabel->"In[2]:=",
 CellID->9679],

Cell[BoxData["15"], "Output",
 CellTags->"Sum::sumwarn",
 CellLabel->"Out[2]=",
 CellID->84453791]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Sum::sumwarn - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 20, 10.2927546}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Sum::sumwarn", "synonyms" -> {}, "title" -> "Sum::sumwarn", 
    "type" -> "Message", "uri" -> "ref/message/sumwarn"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1836, 71, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->53603880]},
 "Sum::sumwarn"->{
  Cell[2557, 100, 252, 10, 70, "Input",
   CellTags->"Sum::sumwarn",
   CellID->13719],
  Cell[2812, 112, 300, 7, 70, "Message",
   CellTags->"Sum::sumwarn",
   CellID->400250162],
  Cell[3115, 121, 144, 4, 70, "Output",
   CellTags->"Sum::sumwarn",
   CellID->571888872],
  Cell[3389, 133, 242, 10, 70, "Input",
   CellTags->"Sum::sumwarn",
   CellID->9679],
  Cell[3634, 145, 98, 3, 70, "Output",
   CellTags->"Sum::sumwarn",
   CellID->84453791]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4701, 177},
 {"Sum::sumwarn", 4838, 181}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 49, 1, 70, "ObjectName",
 CellID->2821],
Cell[CellGroupData[{
Cell[777, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1255, 49, 232, 5, 70, "Message",
 CellID->380581775],
Cell[1490, 56, 163, 4, 70, "Notes",
 CellID->5551],
Cell[1656, 62, 143, 4, 70, "Notes",
 CellID->13305]
}, Closed]],
Cell[CellGroupData[{
Cell[1836, 71, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->53603880],
Cell[CellGroupData[{
Cell[2220, 85, 148, 5, 70, "ExampleSection",
 CellID->555136977],
Cell[2371, 92, 161, 4, 70, "ExampleText",
 CellID->508602956],
Cell[CellGroupData[{
Cell[2557, 100, 252, 10, 70, "Input",
 CellTags->"Sum::sumwarn",
 CellID->13719],
Cell[2812, 112, 300, 7, 70, "Message",
 CellTags->"Sum::sumwarn",
 CellID->400250162],
Cell[3115, 121, 144, 4, 70, "Output",
 CellTags->"Sum::sumwarn",
 CellID->571888872]
}, Open  ]],
Cell[3274, 128, 90, 1, 70, "ExampleText",
 CellID->60756867],
Cell[CellGroupData[{
Cell[3389, 133, 242, 10, 70, "Input",
 CellTags->"Sum::sumwarn",
 CellID->9679],
Cell[3634, 145, 98, 3, 70, "Output",
 CellTags->"Sum::sumwarn",
 CellID->84453791]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3771, 153, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

