(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11168,        426]
NotebookOptionsPosition[      6851,        278]
NotebookOutlinePosition[      9126,        350]
CellTagsIndexPosition[      9011,        344]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Thread::tdlen", "ObjectName",
 CellID->15783],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Thread", "::", "\<\"tdlen\"\>"}], ":", 
  " ", "\<\"Objects of unequal length in `1` cannot be combined.\"\>"}]], \
"Message", "MSG",
 CellID->43021419],

Cell["\<\
Generated when a threading operation is used with  expressions that do not \
have the same length.\
\>", "Notes",
 CellID->10656],

Cell[TextData[{
 " Operations with the ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 " attribute, such as ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ", automatically thread over arguments that are lists."
}], "Notes",
 CellID->19350]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->6567630],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->67071801],

Cell["\<\
An error occurs in this example because the argument expressions in the test \
function do not have the same length.\
\>", "ExampleText",
 CellID->675013711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"test", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "]"}], "]"}]], "Input",
 CellTags->"Thread::tdlen",
 CellLabel->"In[1]:=",
 CellID->23872],

Cell[BoxData[
 RowBox[{
  RowBox[{"Thread", "::", "\<\"tdlen\"\>"}], ":", 
  " ", "\<\"Objects of unequal length in \\!\\(test[\\(\\(\\(\\({1, 2}\\)\\), \
\\(\\({7, 8, 9}\\)\\)\\)\\)]\\) cannot be combined.\"\>"}]], "Message", "MSG",
 
 CellTags->"Thread::tdlen",
 CellID->234480722],

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "]"}]], "Output",
 CellTags->"Thread::tdlen",
 CellLabel->"Out[1]=",
 CellID->671415676]
}, Open  ]],

Cell[TextData[{
 "This shows a valid argument in ",
 Cell[BoxData[
  ButtonBox["Thread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thread"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->167064834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"test", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "]"}], "]"}]], "Input",
 CellTags->"Thread::tdlen",
 CellLabel->"In[2]:=",
 CellID->31440],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"test", "[", 
    RowBox[{"1", ",", "7"}], "]"}], ",", 
   RowBox[{"test", "[", 
    RowBox[{"2", ",", "8"}], "]"}], ",", 
   RowBox[{"test", "[", 
    RowBox[{"3", ",", "9"}], "]"}]}], "}"}]], "Output",
 CellTags->"Thread::tdlen",
 CellLabel->"Out[2]=",
 CellID->344794236]
}, Open  ]],

Cell[TextData[{
 "This message can also be generated when functions with the ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 " attribute, such as ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ", are used with list arguments that do not all have the same length."
}], "ExampleText",
 CellID->140064087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Plus", "]"}]], "Input",
 CellTags->"Thread::tdlen",
 CellLabel->"In[3]:=",
 CellID->11113],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Flat", ",", "Listable", ",", "NumericFunction", ",", "OneIdentity", ",", 
   "Orderless", ",", "Protected"}], "}"}]], "Output",
 CellTags->"Thread::tdlen",
 CellLabel->"Out[3]=",
 CellID->71931364]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"10", "+", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2"}], "}"}], "+", 
  RowBox[{"{", 
   RowBox[{"7", ",", "8", ",", "9"}], "}"}]}]], "Input",
 CellTags->"Thread::tdlen",
 CellLabel->"In[4]:=",
 CellID->66457729],

Cell[BoxData[
 RowBox[{
  RowBox[{"Thread", "::", "\<\"tdlen\"\>"}], ":", 
  " ", "\<\"Objects of unequal length in \\!\\(10 + \\(\\({1, 2}\\)\\) + \
\\(\\({7, 8, 9}\\)\\)\\) cannot be combined.\"\>"}]], "Message", "MSG",
 CellTags->"Thread::tdlen",
 CellID->596989715],

Cell[BoxData[
 RowBox[{"10", "+", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2"}], "}"}], "+", 
  RowBox[{"{", 
   RowBox[{"7", ",", "8", ",", "9"}], "}"}]}]], "Output",
 CellTags->"Thread::tdlen",
 CellLabel->"Out[4]=",
 CellID->6186155]
}, Open  ]],

Cell["\<\
This example shows addition threaded over lists that have the same length.\
\>", "ExampleText",
 CellID->235064196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"10", "+", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "+", 
  RowBox[{"{", 
   RowBox[{"7", ",", "8", ",", "9"}], "}"}]}]], "Input",
 CellTags->"Thread::tdlen",
 CellLabel->"In[5]:=",
 CellID->4498],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"18", ",", "20", ",", "22"}], "}"}]], "Output",
 CellTags->"Thread::tdlen",
 CellLabel->"Out[5]=",
 CellID->451976175]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Thread::tdlen - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 20, 59.0283772}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Thread::tdlen", "synonyms" -> {}, "title" -> 
    "Thread::tdlen", "type" -> "Message", "uri" -> "ref/message/tdlen"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2131, 85, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->6567630]},
 "Thread::tdlen"->{
  Cell[2856, 114, 293, 10, 70, "Input",
   CellTags->"Thread::tdlen",
   CellID->23872],
  Cell[3152, 126, 283, 7, 70, "Message",
   CellTags->"Thread::tdlen",
   CellID->234480722],
  Cell[3438, 135, 260, 9, 70, "Output",
   CellTags->"Thread::tdlen",
   CellID->671415676],
  Cell[3948, 159, 303, 10, 70, "Input",
   CellTags->"Thread::tdlen",
   CellID->31440],
  Cell[4254, 171, 325, 11, 70, "Output",
   CellTags->"Thread::tdlen",
   CellID->344794236],
  Cell[5064, 202, 133, 4, 70, "Input",
   CellTags->"Thread::tdlen",
   CellID->11113],
  Cell[5200, 208, 240, 7, 70, "Output",
   CellTags->"Thread::tdlen",
   CellID->71931364],
  Cell[5477, 220, 234, 8, 70, "Input",
   CellTags->"Thread::tdlen",
   CellID->66457729],
  Cell[5714, 230, 269, 6, 70, "Message",
   CellTags->"Thread::tdlen",
   CellID->596989715],
  Cell[5986, 238, 234, 8, 70, "Output",
   CellTags->"Thread::tdlen",
   CellID->6186155],
  Cell[6385, 256, 240, 8, 70, "Input",
   CellTags->"Thread::tdlen",
   CellID->4498],
  Cell[6628, 266, 157, 5, 70, "Output",
   CellTags->"Thread::tdlen",
   CellID->451976175]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7755, 300},
 {"Thread::tdlen", 7892, 304}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->15783],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 187, 5, 70, "Message",
 CellID->43021419],
Cell[1447, 56, 139, 4, 70, "Notes",
 CellID->10656],
Cell[1589, 62, 505, 18, 70, "Notes",
 CellID->19350]
}, Closed]],
Cell[CellGroupData[{
Cell[2131, 85, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->6567630],
Cell[CellGroupData[{
Cell[2514, 99, 147, 5, 70, "ExampleSection",
 CellID->67071801],
Cell[2664, 106, 167, 4, 70, "ExampleText",
 CellID->675013711],
Cell[CellGroupData[{
Cell[2856, 114, 293, 10, 70, "Input",
 CellTags->"Thread::tdlen",
 CellID->23872],
Cell[3152, 126, 283, 7, 70, "Message",
 CellTags->"Thread::tdlen",
 CellID->234480722],
Cell[3438, 135, 260, 9, 70, "Output",
 CellTags->"Thread::tdlen",
 CellID->671415676]
}, Open  ]],
Cell[3713, 147, 210, 8, 70, "ExampleText",
 CellID->167064834],
Cell[CellGroupData[{
Cell[3948, 159, 303, 10, 70, "Input",
 CellTags->"Thread::tdlen",
 CellID->31440],
Cell[4254, 171, 325, 11, 70, "Output",
 CellTags->"Thread::tdlen",
 CellID->344794236]
}, Open  ]],
Cell[4594, 185, 445, 13, 70, "ExampleText",
 CellID->140064087],
Cell[CellGroupData[{
Cell[5064, 202, 133, 4, 70, "Input",
 CellTags->"Thread::tdlen",
 CellID->11113],
Cell[5200, 208, 240, 7, 70, "Output",
 CellTags->"Thread::tdlen",
 CellID->71931364]
}, Open  ]],
Cell[CellGroupData[{
Cell[5477, 220, 234, 8, 70, "Input",
 CellTags->"Thread::tdlen",
 CellID->66457729],
Cell[5714, 230, 269, 6, 70, "Message",
 CellTags->"Thread::tdlen",
 CellID->596989715],
Cell[5986, 238, 234, 8, 70, "Output",
 CellTags->"Thread::tdlen",
 CellID->6186155]
}, Open  ]],
Cell[6235, 249, 125, 3, 70, "ExampleText",
 CellID->235064196],
Cell[CellGroupData[{
Cell[6385, 256, 240, 8, 70, "Input",
 CellTags->"Thread::tdlen",
 CellID->4498],
Cell[6628, 266, 157, 5, 70, "Output",
 CellTags->"Thread::tdlen",
 CellID->451976175]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6824, 276, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

