(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7804,        291]
NotebookOptionsPosition[      5014,        197]
NotebookOutlinePosition[      6644,        248]
CellTagsIndexPosition[      6530,        242]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Thread::tpos", "ObjectName",
 CellID->17422],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Thread", "::", "\<\"tpos\"\>"}], ":", 
  " ", "\<\"Cannot thread over positions `1` through `2` in `3`.\"\>"}]], \
"Message", "MSG",
 CellID->155819173],

Cell[TextData[{
 "Generated when the positions specified in the third  argument of ",
 Cell[BoxData[
  ButtonBox["Thread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thread"]], "InlineFormula"],
 " are not available in the expression in the first argument."
}], "Notes",
 CellID->19621]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->445421225],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->400974405],

Cell[TextData[{
 "An error occurs in this example because the positions specified in the  \
third argument of ",
 Cell[BoxData[
  ButtonBox["Thread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thread"]], "InlineFormula"],
 " extend beyond the end of the expression in the first argument."
}], "ExampleText",
 CellID->518577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"test", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "9"}], "}"}]}], "]"}], ",", "List", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellTags->"Thread::tpos",
 CellLabel->"In[1]:=",
 CellID->25762],

Cell[BoxData[
 RowBox[{
  RowBox[{"Thread", "::", "\<\"tpos\"\>"}], ":", 
  " ", "\<\"Cannot thread over positions \\!\\(2\\) through \\!\\(4\\) in \\!\
\\(test[\\(\\(\\(\\({1, 2}\\)\\), \\(\\({3, 4}\\)\\), \\(\\({8, \
9}\\)\\)\\)\\)]\\).\"\>"}]], "Message", "MSG",
 CellTags->"Thread::tpos",
 CellID->122462349],

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"test", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "9"}], "}"}]}], "]"}], ",", "List", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}], "]"}]], "Output",
 CellTags->"Thread::tpos",
 CellLabel->"Out[1]=",
 CellID->215776325]
}, Open  ]],

Cell[TextData[{
 "This shows a valid position specification in ",
 Cell[BoxData[
  ButtonBox["Thread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thread"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->28347571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"test", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "9"}], "}"}]}], "]"}], ",", "List", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellTags->"Thread::tpos",
 CellLabel->"In[2]:=",
 CellID->7989],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"test", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", "3", ",", "8"}], "]"}], ",", 
   RowBox[{"test", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", "4", ",", "9"}], "]"}]}], 
  "}"}]], "Output",
 CellTags->"Thread::tpos",
 CellLabel->"Out[2]=",
 CellID->245210497]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Thread::tpos - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 20, 59.1846312}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Thread::tpos", "synonyms" -> {}, "title" -> "Thread::tpos", 
    "type" -> "Message", "uri" -> "ref/message/tpos"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1775, 69, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->445421225]},
 "Thread::tpos"->{
  Cell[2666, 103, 436, 15, 70, "Input",
   CellTags->"Thread::tpos",
   CellID->25762],
  Cell[3105, 120, 312, 7, 70, "Message",
   CellTags->"Thread::tpos",
   CellID->122462349],
  Cell[3420, 129, 441, 15, 70, "Output",
   CellTags->"Thread::tpos",
   CellID->215776325],
  Cell[4124, 159, 435, 15, 70, "Input",
   CellTags->"Thread::tpos",
   CellID->7989],
  Cell[4562, 176, 386, 14, 70, "Output",
   CellTags->"Thread::tpos",
   CellID->245210497]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5914, 219},
 {"Thread::tpos", 6052, 223}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 50, 1, 70, "ObjectName",
 CellID->17422],
Cell[CellGroupData[{
Cell[778, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1256, 49, 187, 5, 70, "Message",
 CellID->155819173],
Cell[1446, 56, 292, 8, 70, "Notes",
 CellID->19621]
}, Closed]],
Cell[CellGroupData[{
Cell[1775, 69, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->445421225],
Cell[CellGroupData[{
Cell[2160, 83, 148, 5, 70, "ExampleSection",
 CellID->400974405],
Cell[2311, 90, 330, 9, 70, "ExampleText",
 CellID->518577],
Cell[CellGroupData[{
Cell[2666, 103, 436, 15, 70, "Input",
 CellTags->"Thread::tpos",
 CellID->25762],
Cell[3105, 120, 312, 7, 70, "Message",
 CellTags->"Thread::tpos",
 CellID->122462349],
Cell[3420, 129, 441, 15, 70, "Output",
 CellTags->"Thread::tpos",
 CellID->215776325]
}, Open  ]],
Cell[3876, 147, 223, 8, 70, "ExampleText",
 CellID->28347571],
Cell[CellGroupData[{
Cell[4124, 159, 435, 15, 70, "Input",
 CellTags->"Thread::tpos",
 CellID->7989],
Cell[4562, 176, 386, 14, 70, "Output",
 CellTags->"Thread::tpos",
 CellID->245210497]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4987, 195, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

