(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8000,        305]
NotebookOptionsPosition[      4719,        195]
NotebookOutlinePosition[      6558,        252]
CellTagsIndexPosition[      6441,        246]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Transpose::nmtx", "ObjectName",
 CellID->27236],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "::", "\<\"nmtx\"\>"}], ":", 
  " ", "\<\"The first two levels of the one-dimensional list `1` cannot be \
transposed.\"\>"}]], "Message", "MSG",
 CellID->161085151],

Cell[TextData[{
 "Generated when the first argument in ",
 Cell[BoxData[
  ButtonBox["Transpose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Transpose"]], "InlineFormula"],
 " is not a matrix."
}], "Notes",
 CellID->27915]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->212560324],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->69953286],

Cell[TextData[{
 "An error occurs in this example because the argument in ",
 Cell[BoxData[
  ButtonBox["Transpose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Transpose"]], "InlineFormula"],
 " is a vector rather than a matrix."
}], "ExampleText",
 CellID->30022333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Input",
 CellTags->"Transpose::nmtx",
 CellLabel->"In[1]:=",
 CellID->23342],

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "::", "\<\"nmtx\"\>"}], ":", 
  " ", "\<\"The first two levels of the one-dimensional list \\!\\({1, 2, \
3}\\) cannot be transposed.\"\>"}]], "Message", "MSG",
 CellTags->"Transpose::nmtx",
 CellID->178283541],

Cell[BoxData[
 RowBox[{"Transpose", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Output",
 CellTags->"Transpose::nmtx",
 CellLabel->"Out[1]=",
 CellID->79173947]
}, Open  ]],

Cell[TextData[{
 "This shows a valid matrix argument in ",
 Cell[BoxData[
  ButtonBox["Transpose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Transpose"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->100586093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], "}"}], "]"}]], "Input",
 CellTags->"Transpose::nmtx",
 CellLabel->"In[2]:=",
 CellID->7658],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "3", "}"}]}], "}"}]], "Output",
 CellTags->"Transpose::nmtx",
 CellLabel->"Out[2]=",
 CellID->323856578]
}, Open  ]],

Cell[TextData[{
 "You can use the permutation specification ",
 StyleBox["{1}", "MR"],
 " if it is necessary to apply ",
 Cell[BoxData[
  ButtonBox["Transpose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Transpose"]], "InlineFormula"],
 " to a vector."
}], "ExampleText",
 CellID->934985481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", "1", "}"}]}], "]"}]], "Input",
 CellTags->"Transpose::nmtx",
 CellLabel->"In[3]:=",
 CellID->28643],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 CellTags->"Transpose::nmtx",
 CellLabel->"Out[3]=",
 CellID->65535860]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Transpose::nmtx - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 21, 15.1381646}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Transpose::nmtx", "synonyms" -> {}, "title" -> 
    "Transpose::nmtx", "type" -> "Message", "uri" -> "ref/message/nmtx"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1739, 69, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->212560324]},
 "Transpose::nmtx"->{
  Cell[2572, 102, 188, 6, 70, "Input",
   CellTags->"Transpose::nmtx",
   CellID->23342],
  Cell[2763, 110, 257, 6, 70, "Message",
   CellTags->"Transpose::nmtx",
   CellID->178283541],
  Cell[3023, 118, 192, 6, 70, "Output",
   CellTags->"Transpose::nmtx",
   CellID->79173947],
  Cell[3478, 139, 212, 7, 70, "Input",
   CellTags->"Transpose::nmtx",
   CellID->7658],
  Cell[3693, 148, 228, 8, 70, "Output",
   CellTags->"Transpose::nmtx",
   CellID->323856578],
  Cell[4258, 173, 237, 8, 70, "Input",
   CellTags->"Transpose::nmtx",
   CellID->28643],
  Cell[4498, 183, 155, 5, 70, "Output",
   CellTags->"Transpose::nmtx",
   CellID->65535860]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5628, 217},
 {"Transpose::nmtx", 5769, 221}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->27236],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 212, 5, 70, "Message",
 CellID->161085151],
Cell[1474, 56, 228, 8, 70, "Notes",
 CellID->27915]
}, Closed]],
Cell[CellGroupData[{
Cell[1739, 69, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->212560324],
Cell[CellGroupData[{
Cell[2124, 83, 147, 5, 70, "ExampleSection",
 CellID->69953286],
Cell[2274, 90, 273, 8, 70, "ExampleText",
 CellID->30022333],
Cell[CellGroupData[{
Cell[2572, 102, 188, 6, 70, "Input",
 CellTags->"Transpose::nmtx",
 CellID->23342],
Cell[2763, 110, 257, 6, 70, "Message",
 CellTags->"Transpose::nmtx",
 CellID->178283541],
Cell[3023, 118, 192, 6, 70, "Output",
 CellTags->"Transpose::nmtx",
 CellID->79173947]
}, Open  ]],
Cell[3230, 127, 223, 8, 70, "ExampleText",
 CellID->100586093],
Cell[CellGroupData[{
Cell[3478, 139, 212, 7, 70, "Input",
 CellTags->"Transpose::nmtx",
 CellID->7658],
Cell[3693, 148, 228, 8, 70, "Output",
 CellTags->"Transpose::nmtx",
 CellID->323856578]
}, Open  ]],
Cell[3936, 159, 297, 10, 70, "ExampleText",
 CellID->934985481],
Cell[CellGroupData[{
Cell[4258, 173, 237, 8, 70, "Input",
 CellTags->"Transpose::nmtx",
 CellID->28643],
Cell[4498, 183, 155, 5, 70, "Output",
 CellTags->"Transpose::nmtx",
 CellID->65535860]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4692, 193, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

