(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18721,        573]
NotebookOptionsPosition[     16109,        493]
NotebookOutlinePosition[     17299,        525]
CellTagsIndexPosition[     17256,        522]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA SYSTEM PROGRAM", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica File Organization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicaFileOrganization"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaSessions"], 
          "System Administration for Network Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
          "System Administration for Single-User Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
SystemAdministrationForSingleUserLicensesOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Mathematica File Organization\"\>", 
       2->"\<\"Mathematica Sessions\"\>", 
       3->"\<\"System Administration for Network Licenses\"\>", 
       4->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{StyleBox["Mathematica", FontSlant -> "Plain"] :> 
          Documentation`HelpLookup[
            If[
             StringMatchQ[
              StringJoin["paclet:ref/", 
               StyleBox["Mathematica", FontSlant -> "Plain"]], "paclet*"], 
             Part[
              Part[{{
                 StyleBox["Mathematica", FontSlant -> "Plain"], 
                 StringJoin["paclet:ref/", 
                  StyleBox["Mathematica", FontSlant -> "Plain"]]}, {
                 RowBox[{"init", ".", "m"}], 
                 StringJoin["paclet:ref/", 
                  RowBox[{"init", ".", "m"}]]}, {
                "mathlm", "paclet:ref/program/mathlm"}, {
                "math", "paclet:ref/program/math"}}, 
               DocumentationTools`Utilities`Private`i], 2], 
             StringJoin["paclet:", 
              Part[
               Part[{{
                  StyleBox["Mathematica", FontSlant -> "Plain"], 
                  StringJoin["paclet:ref/", 
                   StyleBox["Mathematica", FontSlant -> "Plain"]]}, {
                  RowBox[{"init", ".", "m"}], 
                  StringJoin["paclet:ref/", 
                   RowBox[{"init", ".", "m"}]]}, {
                 "mathlm", "paclet:ref/program/mathlm"}, {
                 "math", "paclet:ref/program/math"}}, 
                DocumentationTools`Utilities`Private`i], 2]]]], 
          RowBox[{"init", ".", "m"}] :> Documentation`HelpLookup[
            If[
             StringMatchQ[
              StringJoin["paclet:ref/", 
               RowBox[{"init", ".", "m"}]], "paclet*"], 
             Part[
              Part[{{
                 StyleBox["Mathematica", FontSlant -> "Plain"], 
                 StringJoin["paclet:ref/", 
                  StyleBox["Mathematica", FontSlant -> "Plain"]]}, {
                 RowBox[{"init", ".", "m"}], 
                 StringJoin["paclet:ref/", 
                  RowBox[{"init", ".", "m"}]]}, {
                "mathlm", "paclet:ref/program/mathlm"}, {
                "math", "paclet:ref/program/math"}}, 
               DocumentationTools`Utilities`Private`i], 2], 
             StringJoin["paclet:", 
              Part[
               Part[{{
                  StyleBox["Mathematica", FontSlant -> "Plain"], 
                  StringJoin["paclet:ref/", 
                   StyleBox["Mathematica", FontSlant -> "Plain"]]}, {
                  RowBox[{"init", ".", "m"}], 
                  StringJoin["paclet:ref/", 
                   RowBox[{"init", ".", "m"}]]}, {
                 "mathlm", "paclet:ref/program/mathlm"}, {
                 "math", "paclet:ref/program/math"}}, 
                DocumentationTools`Utilities`Private`i], 2]]]], "mathlm" :> 
          Documentation`HelpLookup["paclet:ref/program/mathlm"], "math" :> 
          Documentation`HelpLookup["paclet:ref/program/math"]}, #, 2]& , 
        Evaluator -> Automatic], {1->
       RowBox[{"StyleBox", "[", 
        RowBox[{"\<\"Mathematica\"\>", ",", 
         RowBox[{"FontSlant", "\[Rule]", "\<\"Plain\"\>"}]}], "]"}], 2->
       RowBox[{"RowBox", "[", 
        RowBox[{"{", 
         RowBox[{"\<\"init\"\>", ",", "\<\".\"\>", ",", "\<\"m\"\>"}], "}"}], 
        "]"}], 3->"\<\"mathlm\"\>", 4->"\<\"math\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink Mathematica Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkMathematicaFunctions"], 
          "Parallel & Grid Computing" :> 
          Documentation`HelpLookup["paclet:guide/ParallelAndGridComputing"], 
          "Stand-Alone Mathematica Kernels" :> 
          Documentation`HelpLookup[
           "paclet:guide/StandaloneMathematicaKernels"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"MathLink Mathematica Functions\"\>", 
       2->"\<\"Parallel & Grid Computing\"\>", 
       3->"\<\"Stand-Alone Mathematica Kernels\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MathKernel", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MathKernel", " ", 
       StyleBox["options", "TI"]}]], "InlineFormula"],
     " \[LineSeparator]starts the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " kernel on Windows and Mac OS X."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["MathKernel"], "InlineFormula"],
 " runs the stand-alone ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. To access the full ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system including the notebook interface, use ",
 Cell[BoxData[
  ButtonBox[
   StyleBox["Mathematica",
    FontSlant->"Plain"],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/Mathematica"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1170061928],

Cell[TextData[{
 "A stand-alone kernel session normally reads input from ",
 Cell[BoxData["stdin"], "InlineFormula"],
 " (typically a keyboard), evaluates the expression, and prints the results \
to ",
 Cell[BoxData["stdout"], "InlineFormula"],
 " (typically a display device). Input and output can be redirected using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " commands or standard shell mechanisms."
}], "Notes",
 CellID->307501305],

Cell["The following command-line options can be given:", "Notes",
 CellID->443060207],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "mathlink"}], Cell[TextData[{
     "communicate only via ",
     StyleBox["MathLink",
      FontSlant->"Italic"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "initfile"}], " ", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\""}], Cell[TextData[{
     "execute the commands in the initialization file ",
     Cell[BoxData[
      StyleBox["file", "TI"]], "InlineFormula"],
     " during startup"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "lmverbose"}], Cell[TextData[{
     "print information on interactions with ",
     StyleBox["MathLM",
      FontSlant->"Italic"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "noinit"}], Cell[
    "do not read any initialization files", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "password"}], " ", "\"\<\!\(\*
StyleBox[\"pw\", \"TI\"]\)\>\""}], Cell[TextData[{
     "use the password ",
     Cell[BoxData[
      StyleBox["pw", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "pwfile"}], " ", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\""}], Cell[TextData[{
     "read passwords from ",
     Cell[BoxData[
      StyleBox["file", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "run"}], " ", 
     StyleBox["cmd", "TI"]}], Cell[TextData[{
     "run ",
     Cell[BoxData[
      StyleBox["cmd", "TI"]], "InlineFormula"],
     " on startup"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "noprompt"}], Cell[TextData[{
     "do not print banner or ",
     Cell[BoxData[
      ButtonBox["In",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/In"]], "InlineFormula"],
     "/",
     Cell[BoxData[
      ButtonBox["Out",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Out"]], "InlineFormula"],
     " prompts (useful for batch input)"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->1187094900],

Cell[TextData[{
 "If no command-line options are given, the kernel will read the value of the \
environment variable ",
 Cell[BoxData["MATHKERNELINIT"], "InlineFormula"],
 " and will use that value as though it had been entered on the command \
line."
}], "Notes",
 CellID->1328778453],

Cell[TextData[{
 "Unless the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " variable ",
 Cell[BoxData[
  ButtonBox["$IgnoreEOF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$IgnoreEOF"]], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", the kernel will exit when it receives an end-of-file character sequence. \
The kernel will always exit when given the command ",
 Cell[BoxData[
  ButtonBox["Quit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quit"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1097014418]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["Mathematica",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData:>"paclet:ref/program/Mathematica"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    RowBox[{"init", ".", "m"}],
    BaseStyle->"Link",
    ButtonData:>"paclet:ref/file/init.m"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["mathlm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/program/mathlm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["math",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/program/math"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1237834562]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaFileOrganization"],
  FontSlant->"Italic"],
 ButtonBox[" File Organization",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaFileOrganization"]
}], "Tutorials",
 CellID->502212112],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"]
}], "Tutorials",
 CellID->515861756],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"Tutorials",
 CellID->341631938],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"Tutorials",
 CellID->1550580332]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"],
 StyleBox[ButtonBox["Mathematica ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"],
  FontSlant->"Italic"],
 ButtonBox["Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"]
}], "MoreAbout"],

Cell[TextData[ButtonBox["Parallel & Grid Computing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ParallelAndGridComputing"]], "MoreAbout"],

Cell[TextData[{
 ButtonBox["Stand-Alone ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StandaloneMathematicaKernels"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StandaloneMathematicaKernels"],
  FontSlant->"Italic"],
 ButtonBox[" Kernels",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StandaloneMathematicaKernels"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathKernel - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 7.0472794}", "context" -> "", 
    "keywords" -> {
     "mathlink", "initfile", "lmverbose", "noinit", "password", "pwfile", 
      "run", "noprompt", "command line switch", "command line options", 
      "kernel options"}, "index" -> True, "label" -> 
    "Mathematica System Program", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MathKernel options starts the Mathematica kernel on Windows and Mac OS \
X.", "synonyms" -> {}, "title" -> "MathKernel", "type" -> "System Program", 
    "uri" -> "ref/program/MathKernel"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 5878, 129, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[6501, 156, 56, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[6560, 159, 470, 15, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[7067, 179, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7545, 196, 481, 17, 70, "Notes",
 CellID->1170061928],
Cell[8029, 215, 446, 11, 70, "Notes",
 CellID->307501305],
Cell[8478, 228, 85, 1, 70, "Notes",
 CellID->443060207],
Cell[8566, 231, 2415, 72, 70, "2ColumnTableMod",
 CellID->1187094900],
Cell[10984, 305, 285, 7, 70, "Notes",
 CellID->1328778453],
Cell[11272, 314, 628, 22, 70, "Notes",
 CellID->1097014418]
}, Closed]],
Cell[CellGroupData[{
Cell[11937, 341, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[12256, 352, 1028, 38, 70, "SeeAlso",
 CellID->1237834562]
}, Open  ]],
Cell[CellGroupData[{
Cell[13321, 395, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[13642, 406, 309, 9, 70, "Tutorials",
 CellID->502212112],
Cell[13954, 417, 284, 9, 70, "Tutorials",
 CellID->515861756],
Cell[14241, 428, 208, 5, 70, "Tutorials",
 CellID->341631938],
Cell[14452, 435, 216, 5, 70, "Tutorials",
 CellID->1550580332]
}, Open  ]],
Cell[CellGroupData[{
Cell[14705, 445, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[15026, 456, 511, 15, 70, "MoreAbout"],
Cell[15540, 473, 141, 2, 70, "MoreAbout"],
Cell[15684, 477, 383, 11, 70, "MoreAbout"]
}, Open  ]],
Cell[16082, 491, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

