(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11897,        389]
NotebookOptionsPosition[      9321,        310]
NotebookOutlinePosition[     10633,        345]
CellTagsIndexPosition[     10590,        342]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA SYSTEM PROGRAM", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica File Organization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicaFileOrganization"], 
          "System Administration for Network Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
          "System Administration for Single-User Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
SystemAdministrationForSingleUserLicensesOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Mathematica File Organization\"\>", 
       2->"\<\"System Administration for Network Licenses\"\>", 
       3->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathKernel" :> 
          Documentation`HelpLookup["paclet:ref/program/MathKernel"], 
          "mathematica" :> 
          Documentation`HelpLookup["paclet:ref/program/mathematica-unix"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"MathKernel\"\>", 
       2->"\<\"mathematica\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Stand-Alone Mathematica Kernels" :> 
          Documentation`HelpLookup[
           "paclet:guide/StandaloneMathematicaKernels"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Stand-Alone Mathematica Kernels\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Mathematica", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["Mathematica",
        FontSlant->"Plain"], " ", 
       StyleBox["options", "TI"]}]], "InlineFormula"],
     " \[LineSeparator]starts the full ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " system including notebook interface on Windows and Mac."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->475838306]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook interface provides dynamic interactivity and enhanced graphics \
functionality, and calls the kernel via ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " to perform calculations."
}], "Notes",
 CellID->1639282791],

Cell["\<\
The first calculation in a notebook may take slightly longer, as it typically \
launches the kernel.\
\>", "Notes",
 CellID->1358160974],

Cell["The following command-line options are typically accepted:", "Notes",
 CellID->1067943069],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "mathlink"}], Cell[TextData[{
     "make the front end run as a child process that is capable of accepting \
",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " packets"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "pwfile"}], " ", 
     StyleBox["file", "TI"]}], Cell[TextData[{
     "specify a file in which to look for ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " passwords"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->1812650399],

Cell["\<\
The following additional command-line options are accepted on Mac:\
\>", "Notes",
 CellID->775137158],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "clean"}], Cell["\<\
ignore stored caches and rebuild the front end preferences file\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "preferencesDirectory"}], " ", 
     StyleBox["dir", "TI"]}], Cell[
    "specify the location where preference settings are stored", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "topDirectory"}], " ", 
     StyleBox["dir", "TI"]}], Cell[TextData[{
     "specify the location of the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " installation directory "
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->961794761]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathKernel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/program/MathKernel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["mathematica",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/program/mathematica-unix"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->800248998]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaFileOrganization"],
  FontSlant->"Italic"],
 ButtonBox[" File Organization",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaFileOrganization"]
}], "Tutorials",
 CellID->502212112],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"Tutorials",
 CellID->341631938],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"Tutorials",
 CellID->1550580332]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[{
 ButtonBox["Stand-Alone ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StandaloneMathematicaKernels"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StandaloneMathematicaKernels"],
  FontSlant->"Italic"],
 ButtonBox[" Kernels",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StandaloneMathematicaKernels"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Mathematica - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 6.4535142}", "context" -> "", 
    "keywords" -> {
     "mathlink", "pwfile", "clean", "preferencesDirectory", "topDirectory", 
      "command line switch", "command line options", "kernel options"}, 
    "index" -> True, "label" -> "Mathematica System Program", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica options starts the full Mathematica system including \
notebook interface on Windows and Mac.", "synonyms" -> {}, "title" -> 
    "Mathematica", "type" -> "System Program", "uri" -> 
    "ref/program/Mathematica"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2444, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3067, 86, 57, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[3127, 89, 546, 17, 70, "Usage",
 CellID->475838306]
}, Open  ]],
Cell[CellGroupData[{
Cell[3710, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4188, 128, 302, 10, 70, "Notes",
 CellID->1639282791],
Cell[4493, 140, 146, 4, 70, "Notes",
 CellID->1358160974],
Cell[4642, 146, 96, 1, 70, "Notes",
 CellID->1067943069],
Cell[4741, 149, 798, 24, 70, "2ColumnTableMod",
 CellID->1812650399],
Cell[5542, 175, 111, 3, 70, "Notes",
 CellID->775137158],
Cell[5656, 180, 943, 26, 70, "2ColumnTableMod",
 CellID->961794761]
}, Closed]],
Cell[CellGroupData[{
Cell[6636, 211, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[6955, 222, 486, 17, 70, "SeeAlso",
 CellID->800248998]
}, Open  ]],
Cell[CellGroupData[{
Cell[7478, 244, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[7799, 255, 309, 9, 70, "Tutorials",
 CellID->502212112],
Cell[8111, 266, 208, 5, 70, "Tutorials",
 CellID->341631938],
Cell[8322, 273, 216, 5, 70, "Tutorials",
 CellID->1550580332]
}, Open  ]],
Cell[CellGroupData[{
Cell[8575, 283, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[8896, 294, 383, 11, 70, "MoreAbout"]
}, Open  ]],
Cell[9294, 308, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

