(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13586,        457]
NotebookOptionsPosition[     11291,        383]
NotebookOutlinePosition[     12269,        412]
CellTagsIndexPosition[     12226,        409]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA SYSTEM PROGRAM", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica File Organization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicaFileOrganization"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Mathematica File Organization\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Install" :> Documentation`HelpLookup["paclet:ref/Install"], 
          "mprep" :> Documentation`HelpLookup["paclet:ref/program/mprep"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Install\"\>", 
       2->"\<\"mprep\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"C/C++ Language Interface" :> 
          Documentation`HelpLookup["paclet:guide/CLanguageInterface"], 
          "Installable MathLink Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/InstallableMathLinkPrograms"], "MathLink API" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkAPI"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"C/C++ Language Interface\"\>", 
       2->"\<\"Installable MathLink Programs\"\>", 
       3->"\<\"MathLink API\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["mcc", "ObjectNameAlt",
 CellID->1704561318],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"mcc", " ", 
       StyleBox["options", "TI"], " ", 
       StyleBox["files", "TI"]}]], "InlineFormula"],
     " \[LineSeparator]",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " template file compiler"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1130220646]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["mcc"], "InlineFormula"],
 " is a C compiling command for creating a program for installation into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " command ",
 Cell[BoxData[
  ButtonBox["Install",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Install"]], "InlineFormula"],
 ". The installed program communicates with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by using the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " protocol. The ",
 Cell[BoxData["mcc"], "InlineFormula"],
 " command should have a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template file as one of its file arguments along with ordinary C source \
files and object files, which encode the functions that are to be installed \
into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template filename should bear a .tm suffix."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "The ",
 Cell[BoxData["mcc"], "InlineFormula"],
 " script first passes the template file to the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " utility ",
 Cell[BoxData[
  ButtonBox["mprep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mprep"]], "InlineFormula"],
 ", which preprocesses it into a C file that uses ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library functions. It then invokes the compiler identified by the \
environment variable ",
 Cell[BoxData["CC"], "InlineFormula"],
 " to compile and link this C file along with the other files, arguments, and \
the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library, ",
 Cell[BoxData[
  RowBox[{"libML", ".", "a"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1434106555],

Cell[TextData[{
 "On operating systems that support multiple binary formats, ",
 Cell[BoxData["mcc"], "InlineFormula"],
 " automatically links with the appropriate ",
 Cell[BoxData[
  RowBox[{"libML", ".", "a"}]], "InlineFormula"],
 " library."
}], "Notes",
 CellID->1819899604],

Cell[TextData[{
 Cell[BoxData["mcc"], "InlineFormula"],
 " passes all defined options through to the C compiler, but it also treats \
the following options specially:"
}], "Notes",
 CellID->443060207],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "g"}], Cell[TextData[{
     "keep the C file generated by ",
     Cell[BoxData[
      ButtonBox["mprep",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/program/mprep"]], "InlineFormula"],
     " and pass the -g option to the C compiler to generate a symbol table \
for debugging"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "E"}], Cell[TextData[{
     "pass the ",
     ButtonBox[".tm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/file/file.tm"],
     " files through ",
     Cell[BoxData[
      ButtonBox["mprep",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/program/mprep"]], "InlineFormula"],
     ", then run the C source files through the C compiler only, sending \
output to ",
     StyleBox["stdout", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "P"}], Cell[TextData[{
     "pass the ",
     ButtonBox[".tm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/file/file.tm"],
     " files through ",
     Cell[BoxData[
      ButtonBox["mprep",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/program/mprep"]], "InlineFormula"],
     ", then run the C source files through the C compiler only, writing the \
output to a file with a .i suffix"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "xo"}], " ", 
     StyleBox["name", "TI"]}], Cell[TextData[{
     "write the output file in ",
     StyleBox["name", "TI"],
     StyleBox["/$SystemID/", "MR"],
     StyleBox["name", "TI"],
     ", to be located by ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Install",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Install"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}]]]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->1187094900]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["mprep",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/program/mprep"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaFileOrganization"],
  FontSlant->"Italic"],
 ButtonBox[" File Organization",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaFileOrganization"]
}], "Tutorials",
 CellID->502212112]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["C/C++ Language Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CLanguageInterface"]], "MoreAbout"],

Cell[TextData[{
 ButtonBox["Installable ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"],
  FontSlant->"Italic"],
 ButtonBox[" API",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"]
}], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->1584193535],

Cell[" XXXX", "RelatedLinks",
 CellID->1038487239]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"mcc - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 14.6724746}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica System Program", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "mcc options files MathLink template file compiler", "synonyms" -> {}, 
    "title" -> "mcc", "type" -> "System Program", "uri" -> 
    "ref/program/mcc"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2162, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2785, 79, 49, 1, 70, "ObjectNameAlt",
 CellID->1704561318],
Cell[2837, 82, 479, 16, 70, "Usage",
 CellID->1130220646]
}, Open  ]],
Cell[CellGroupData[{
Cell[3353, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3831, 120, 1021, 34, 70, "Notes",
 CellID->1067943069],
Cell[4855, 156, 784, 26, 70, "Notes",
 CellID->1434106555],
Cell[5642, 184, 278, 8, 70, "Notes",
 CellID->1819899604],
Cell[5923, 194, 200, 5, 70, "Notes",
 CellID->443060207],
Cell[6126, 201, 2138, 62, 70, "2ColumnTableMod",
 CellID->1187094900]
}, Closed]],
Cell[CellGroupData[{
Cell[8301, 268, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[8620, 279, 455, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[9112, 301, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[9433, 312, 309, 9, 70, "Tutorials",
 CellID->502212112]
}, Open  ]],
Cell[CellGroupData[{
Cell[9779, 326, 299, 8, 70, "MoreAboutSection"],
Cell[10081, 336, 134, 2, 70, "MoreAbout"],
Cell[10218, 340, 378, 11, 70, "MoreAbout"],
Cell[10599, 353, 234, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10870, 366, 326, 9, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[11199, 377, 50, 1, 70, "RelatedLinks",
 CellID->1038487239]
}, Open  ]],
Cell[11264, 381, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

