(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10982,        359]
NotebookOptionsPosition[      8668,        286]
NotebookOutlinePosition[      9723,        315]
CellTagsIndexPosition[      9680,        312]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA SYSTEM PROGRAM", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"System Administration for Network Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
          "System Administration for Single-User Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
SystemAdministrationForSingleUserLicensesOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"System Administration for Network Licenses\"\>", 
       2->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"mathlm" :> 
          Documentation`HelpLookup["paclet:ref/program/mathlm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"mathlm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"System & License Management" :> 
          Documentation`HelpLookup[
           "paclet:guide/SystemAndLicenseManagement"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"System & License Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["monitorlm", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"monitorlm", " ", 
       StyleBox["servername", "TI"], 
       StyleBox[" ", "TI"], 
       StyleBox["options", "TI"]}]], "InlineFormula"],
     " \[LineSeparator]monitors ",
     StyleBox["MathLM",
      FontSlant->"Italic"],
     " running on ",
     Cell[BoxData[
      StyleBox["servername", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["monitorlm"], "InlineFormula"],
 " gives information on the total number of licenses available and checked \
out, the fully qualified domain name and username of those who have them \
checked out, and so on."
}], "Notes",
 CellID->1322670009],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["servername", "TI"]], "InlineFormula"],
 " is not specified, ",
 Cell[BoxData["monitorlm"], "InlineFormula"],
 " defaults to the local machine."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData["monitorlm"], "InlineFormula"],
 " can send output to the terminal, open a web browser, or write to a file."
}], "Notes",
 CellID->1511611166],

Cell["The following command-line options can be used:", "Notes",
 CellID->917322952],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "file"}], " ", 
     StyleBox["file", "TI"]}], Cell[
    "specify the file to which output should be directed", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "format"}], " ", 
     StyleBox["f", "TI"]}], 
    RowBox[{Cell[TextData[{
      "specify the format for the output of ",
      StyleBox["MonitorLM",
       FontSlant->"Italic"]
     }], "TableText"], " "}]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "localtime"}], Cell["\<\
specify that all given times should be in local time, instead of GMT\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "template"}], " ", 
     StyleBox["file", "TI"]}], Cell[TextData[{
     "specify a file that acts as a template for the output of ",
     StyleBox["MonitorLM",
      FontSlant->"Italic"],
     " "
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->661752451],

Cell[TextData[{
 "Possible formats when using ",
 Cell[BoxData[
  RowBox[{"-", "format"}]], "InlineFormula"],
 " are:"
}], "Notes",
 CellID->255636144],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "text", Cell[TextData[{
     "send output in text format to ",
     Cell[BoxData["stdout"]]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "html", Cell["\<\
send output in HTML format to a temporary file and launch a web browser to \
display the file\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "cgi", Cell[TextData[{
     "send output in HTML format to ",
     Cell[BoxData["stdout"]],
     " (used when called directly from a web browser)"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1509378208]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[StyleBox[ButtonBox["mathlm",
 BaseStyle->"Link",
 ButtonData->"paclet:ref/program/mathlm"],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->1175334930]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"Tutorials",
 CellID->341631938],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"Tutorials",
 CellID->1550580332]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["System & License Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemAndLicenseManagement"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"monitorlm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 14.8756048}", "context" -> "", 
    "keywords" -> {"file", "format", "localtime", "template"}, "index" -> 
    True, "label" -> "Mathematica System Program", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "monitorlm servername options monitors MathLM running on servername.", 
    "synonyms" -> {}, "title" -> "monitorlm", "type" -> "System Program", 
    "uri" -> "ref/program/monitorlm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2089, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2712, 79, 55, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[2770, 82, 593, 20, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3400, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3878, 124, 272, 6, 70, "Notes",
 CellID->1322670009],
Cell[4153, 132, 228, 8, 70, "Notes",
 CellID->1067943069],
Cell[4384, 142, 172, 4, 70, "Notes",
 CellID->1511611166],
Cell[4559, 148, 84, 1, 70, "Notes",
 CellID->917322952],
Cell[4646, 151, 1215, 34, 70, "2ColumnTableMod",
 CellID->661752451],
Cell[5864, 187, 151, 6, 70, "Notes",
 CellID->255636144],
Cell[6018, 195, 801, 20, 70, "2ColumnTableMod",
 CellID->1509378208]
}, Closed]],
Cell[CellGroupData[{
Cell[6856, 220, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7175, 231, 163, 4, 70, "SeeAlso",
 CellID->1175334930]
}, Open  ]],
Cell[CellGroupData[{
Cell[7375, 240, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[7696, 251, 208, 5, 70, "Tutorials",
 CellID->341631938],
Cell[7907, 258, 216, 5, 70, "Tutorials",
 CellID->1550580332]
}, Open  ]],
Cell[CellGroupData[{
Cell[8160, 268, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[8481, 279, 145, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[8641, 284, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

