(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16087,        510]
NotebookOptionsPosition[     13500,        432]
NotebookOutlinePosition[     14685,        463]
CellTagsIndexPosition[     14642,        460]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA SYSTEM PROGRAM", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
           "MathLink Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"], 
          "MathLink Developer Guide (Mac)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink Developer Guide (Unix/Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>", 
       2->"\<\"MathLink Developer Guide (Windows)\"\>", 
       3->"\<\"MathLink Developer Guide (Mac)\"\>", 
       4->"\<\"MathLink Developer Guide (Unix/Linux)\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"mcc" :> Documentation`HelpLookup["paclet:ref/program/mcc"], 
          RowBox[{"file", ".", "tm"}] :> 
          Documentation`HelpLookup["paclet:ref/file/file.tm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"mcc\"\>", 2->
       RowBox[{"RowBox", "[", 
        RowBox[{"{", 
         RowBox[{"\<\"file\"\>", ",", "\<\".\"\>", ",", "\<\"tm\"\>"}], "}"}],
         "]"}]}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calling External Programs" :> 
          Documentation`HelpLookup["paclet:guide/CallingExternalPrograms"], 
          "C/C++ Language Interface" :> 
          Documentation`HelpLookup["paclet:guide/CLanguageInterface"], 
          "Installable MathLink Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/InstallableMathLinkPrograms"], "MathLink API" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkAPI"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Calling External Programs\"\>", 
       2->"\<\"C/C++ Language Interface\"\>", 
       3->"\<\"Installable MathLink Programs\"\>", 
       4->"\<\"MathLink API\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["mprep", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"mprep", 
       StyleBox[" ", "TR"], 
       StyleBox["options", "TI"], " ", 
       StyleBox[
        RowBox[{"template", ".", "tm"}], "TI"]}]], "InlineFormula"],
     "\[LineSeparator]preprocesses the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " template file ",
     Cell[BoxData[
      RowBox[{
       StyleBox["template", "TI"], ".", 
       StyleBox["tm", "TI"]}]], "InlineFormula"],
     ", generating a C file called ",
     Cell[BoxData[
      StyleBox["filename", "TI"]], "InlineFormula"],
     " that contains all the necessary ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " code to call C functions from ",
     StyleBox["Mathematica.",
      FontSlant->"Italic"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["mprep", "InlineFormula"],
 " processes ",
 ButtonBox[".tm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/file.tm"],
 " template files that describe interfaces between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions and C functions. These interfaces allow ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to call the C functions from within the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " runtime. "
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 StyleBox["mprep", "InlineFormula"],
 " generates the necessary set of C ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " API function calls to communicate with the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel automatically. Users can take the C code generated by ",
 StyleBox["mprep", "InlineFormula"],
 ", compile it and link it with the rest of their C program.",
 " ",
 "The resulting program is suitable for use with ",
 Cell[BoxData[
  ButtonBox["Install",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Install"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1633401354],

Cell[TextData[{
 StyleBox["mprep", "InlineFormula"],
 " supports the following command-line arguments:"
}], "Notes",
 CellID->1981078624],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "prototypes"}], Cell[
    "enable use of ANSI C function prototypes (default)", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "noprototypes"}], Cell["\<\
disable use of ANSI C function prototypes for compilers that do not support \
ANSI C prototypes\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "lines"}], Cell["\<\
enable recording of source line and source file location in output C file\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "nolines"}], Cell["\<\
disable recording of source line and source file location in output C file\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "h"}], " ", 
     StyleBox["filename", "TI"]}], Cell[TextData[{
     "use the contents of ",
     StyleBox["filename", "TI"],
     " as custom header code in the output C file rather than the default \
header code produced by ",
     StyleBox["mprep ", "InlineCode"],
     "(use with care)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "t"}], " ", 
     StyleBox["filename", "TI"]}], Cell[TextData[{
     "use the contents of ",
     Cell[BoxData[
      StyleBox["filename", "TI"]], "InlineFormula"],
     " as custom trailer code in the output C file rather than the default \
trailer code produced by ",
     StyleBox["mprep", "InlineCode"],
     " (use with care)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "o"}], " ", 
     StyleBox["filename", "TI"]}], Cell[TextData[{
     "write output to the file named ",
     StyleBox["filename", "TI"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "c"}], Cell[TextData[{
     "force ",
     StyleBox["mprep", "InlineCode"],
     " to output C code compatible with the Carbon library on Mac OS X (Mac \
only)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "d"}], Cell[TextData[{
     "force ",
     StyleBox["mprep", "InlineCode"],
     " to output C code compatible with the BSD layer on Mac OS X (Mac only)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "j"}], " ", 
     StyleBox["filename", "TI"]}], Cell[TextData[{
     "read a list of filenames from ",
     StyleBox["filename", "TI"],
     " and process each file in batch mode"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->1401970480],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"-", "lines"}]], "InlineFormula"],
 ", entries from the template files will be preceded by ",
 StyleBox["# line line-number \"sourcefile\"", "InlineCode"],
 StyleBox[".", "TR"]
}], "Notes",
 CellID->548065499]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["mcc",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/program/mcc"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    RowBox[{"file", ".", "tm"}],
    BaseStyle->"Link",
    ButtonData->"paclet:ref/file/file.tm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "Tutorials",
 CellID->341631938],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->1932915348],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" Developer Guide (Mac)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->1523125667],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" Developer Guide (Unix/Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->1168013029]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["Calling External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CallingExternalPrograms"]], "MoreAbout"],

Cell[TextData[ButtonBox["C/C++ Language Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CLanguageInterface"]], "MoreAbout"],

Cell[TextData[{
 ButtonBox["Installable ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"],
  FontSlant->"Italic"],
 ButtonBox[" API",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"mprep - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 15.0943604}", "context" -> "", 
    "keywords" -> {"prototypes", "noprototypes", "lines", "nolines"}, "index" -> 
    True, "label" -> "Mathematica System Program", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "mprep options template.tm preprocesses the MathLink template file \
template.tm, generating a C file called filename that contains all the \
necessary MathLink code to call C functions from Mathematica.", 
    "synonyms" -> {}, "title" -> "mprep", "type" -> "System Program", "uri" -> 
    "ref/program/mprep"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3146, 72, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3769, 99, 51, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[3823, 102, 974, 31, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4834, 138, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5312, 155, 500, 17, 70, "Notes",
 CellID->1067943069],
Cell[5815, 174, 616, 19, 70, "Notes",
 CellID->1633401354],
Cell[6434, 195, 137, 4, 70, "Notes",
 CellID->1981078624],
Cell[6574, 201, 2835, 77, 70, "2ColumnTableMod",
 CellID->1401970480],
Cell[9412, 280, 260, 8, 70, "Notes",
 CellID->548065499]
}, Closed]],
Cell[CellGroupData[{
Cell[9709, 293, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[10028, 304, 479, 18, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[10544, 327, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[10865, 338, 371, 11, 70, "Tutorials",
 CellID->341631938],
Cell[11239, 351, 321, 9, 70, "Tutorials",
 CellID->1932915348],
Cell[11563, 362, 321, 9, 70, "Tutorials",
 CellID->1523125667],
Cell[11887, 373, 318, 9, 70, "Tutorials",
 CellID->1168013029]
}, Open  ]],
Cell[CellGroupData[{
Cell[12242, 387, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[12563, 398, 140, 2, 70, "MoreAbout"],
Cell[12706, 402, 134, 2, 70, "MoreAbout"],
Cell[12843, 406, 378, 11, 70, "MoreAbout"],
Cell[13224, 419, 234, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[13473, 430, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

