(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9997,        364]
NotebookOptionsPosition[      7158,        269]
NotebookOutlinePosition[      8450,        306]
CellTagsIndexPosition[      8366,        301]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interrupts and Aborts" :> 
          Documentation`HelpLookup["paclet:tutorial/InterruptsAndAborts"], 
          "Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/Evaluation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Interrupts and Aborts\"\>", 
       2->"\<\"Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Abort" :> Documentation`HelpLookup["paclet:ref/Abort"], 
          "Interrupt" :> Documentation`HelpLookup["paclet:ref/Interrupt"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Abort\"\>", 
       2->"\<\"Interrupt\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$Aborted", "ObjectName",
 CellID->6985],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$Aborted",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Aborted"]], "InlineFormula"],
     "\[LineSeparator]is a special symbol that is returned as the result from \
a calculation that has been aborted. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16095]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->119884299],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$Aborted",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Aborted"]], "InlineFormula"],
 " is returned by a calculation that was aborted:"
}], "ExampleText",
 CellID->210141898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Print", "[", "a", "]"}], ";", 
  RowBox[{"Abort", "[", "]"}], ";", 
  RowBox[{"Print", "[", "b", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11940356],

Cell[BoxData["a"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->13774231],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->470052053]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->768532996],

Cell["\<\
Try a computation with exact arithmetic and fall back to machine arithmetic \
if it is too slow:\
\>", "ExampleText",
 CellID->773717951],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"g", " ", "=", " ", 
      RowBox[{
       RowBox[{"4", " ", "#", 
        RowBox[{"(", 
         RowBox[{"1", "-", "#"}], ")"}]}], "&"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"x", " ", "=", " ", 
      RowBox[{"TimeConstrained", "[", 
       RowBox[{
        RowBox[{"Nest", "[", 
         RowBox[{"g", ",", 
          RowBox[{"1", "/", "10"}], ",", " ", "n"}], "]"}], ",", "1"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"x", " ", "===", " ", "$Aborted"}], ",", 
       RowBox[{"x", "=", 
        RowBox[{"Nest", "[", 
         RowBox[{"g", ",", ".1", ",", "n"}], "]"}]}]}], "]"}], ";", 
     "\[IndentingNewLine]", "x"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39312436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "4", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1618312],

Cell[BoxData[
 FractionBox["125417972736", "152587890625"]], "Output",
 ImageSize->{99, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->344580332]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "100", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->197961993],

Cell[BoxData["0.37244749676375793`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->679925903]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30574],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abort"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interrupt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interrupt"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27080]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6094],

Cell[TextData[ButtonBox["Interrupts and Aborts",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/InterruptsAndAborts"]], "Tutorials",
 CellID->19931],

Cell[TextData[ButtonBox["Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Evaluation"]], "Tutorials",
 CellID->959752411]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$Aborted - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 12.2284464}", "context" -> "System`", 
    "keywords" -> {
     "result of aborted calculations", "stopped", "terminated computation"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "$Aborted is a special symbol that is returned as the result from a \
calculation that has been aborted. ", "synonyms" -> {}, "title" -> "$Aborted",
     "type" -> "Symbol", "uri" -> "ref/$Aborted"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2548, 82, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8232, 294}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1362, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1985, 60, 45, 1, 70, "ObjectName",
 CellID->6985],
Cell[2033, 63, 478, 14, 70, "Usage",
 CellID->16095]
}, Open  ]],
Cell[CellGroupData[{
Cell[2548, 82, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[2925, 96, 148, 5, 70, "ExampleSection",
 CellID->119884299],
Cell[3076, 103, 224, 7, 70, "ExampleText",
 CellID->210141898],
Cell[CellGroupData[{
Cell[3325, 114, 192, 6, 70, "Input",
 CellID->11940356],
Cell[3520, 122, 90, 2, 23, "Print",
 CellID->13774231],
Cell[3613, 126, 165, 5, 36, "Output",
 CellID->470052053]
}, Open  ]],
Cell[3793, 134, 125, 3, 70, "ExampleDelimiter",
 CellID->768532996],
Cell[3921, 139, 147, 4, 70, "ExampleText",
 CellID->773717951],
Cell[4071, 145, 912, 28, 70, "Input",
 CellID->39312436],
Cell[CellGroupData[{
Cell[5008, 177, 95, 3, 70, "Input",
 CellID->1618312],
Cell[5106, 182, 200, 6, 51, "Output",
 CellID->344580332]
}, Open  ]],
Cell[CellGroupData[{
Cell[5343, 193, 99, 3, 70, "Input",
 CellID->197961993],
Cell[5445, 198, 177, 5, 36, "Output",
 CellID->679925903]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5683, 210, 311, 9, 70, "SeeAlsoSection",
 CellID->30574],
Cell[5997, 221, 447, 17, 70, "SeeAlso",
 CellID->27080]
}, Open  ]],
Cell[CellGroupData[{
Cell[6481, 243, 313, 9, 70, "TutorialsSection",
 CellID->6094],
Cell[6797, 254, 151, 3, 70, "Tutorials",
 CellID->19931],
Cell[6951, 259, 135, 3, 70, "Tutorials",
 CellID->959752411]
}, Open  ]],
Cell[7101, 265, 27, 0, 70, "History"],
Cell[7131, 267, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

